/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Commands;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import narutodestination.Mathioks.Config.NarutoEXPConfig;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncChakraExperienceMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncJutsuPointsMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncResetPointsMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncSkillPointsMessage;
import narutodestination.Mathioks.PacketDispatcher;
import narutodestination.Mathioks.RandomizerToken.ResetPointsToken;
import narutodestination.Mathioks.RandomizerToken.StatTokenItem;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandConsumeToken
extends CommandBase {
    private static final String[] KEYS = new String[]{"sp", "jp", "xp", "rp", "all"};

    public String func_71517_b() {
        return "consumetoken";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender s) {
        return "/consumetoken <sp|jp|xp|rp|all>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        String mode;
        if (!(sender instanceof EntityPlayer)) {
            throw new PlayerNotFoundException("Command can only be run by a player.", new Object[0]);
        }
        String string = mode = args.length == 0 ? "all" : args[0].toLowerCase(Locale.ENGLISH);
        if (!Arrays.asList(KEYS).contains(mode)) {
            throw new PlayerNotFoundException("Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        ExtendedPlayer prop = ExtendedPlayer.get((EntityPlayer)player);
        double rankMul = this.getRankMultiplier(prop.getRankName());
        int gainedSP = 0;
        int gainedJP = 0;
        int gainedXP = 0;
        int gainedRP = 0;
        int tokSP = 0;
        int tokJP = 0;
        int tokXP = 0;
        int tokRP = 0;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            int value;
            ItemStack st = player.field_71071_by.field_70462_a[i];
            if (st == null) continue;
            if (st.func_77973_b() instanceof StatTokenItem) {
                int value2;
                String type = this.parseStatTokenType(st);
                if (!mode.equals("all") && !mode.equals(type) || (value2 = st.func_77960_j()) != 1 && value2 != 5 && value2 != 10 && value2 != 50) continue;
                int count = st.field_77994_a;
                int total = (int)((double)(value2 * count) * rankMul);
                if ("sp".equals(type)) {
                    gainedSP += total;
                    tokSP += count;
                }
                if ("jp".equals(type)) {
                    gainedJP += total;
                    tokJP += count;
                }
                if ("xp".equals(type)) {
                    gainedXP += total;
                    tokXP += count;
                }
                player.field_71071_by.field_70462_a[i] = null;
                continue;
            }
            if (!(st.func_77973_b() instanceof ResetPointsToken) || !mode.equals("all") && !mode.equals("rp") || (value = st.func_77960_j()) != 1 && value != 2 && value != 3) continue;
            int count = st.field_77994_a;
            int total = value * count;
            gainedRP += total;
            tokRP += count;
            player.field_71071_by.field_70462_a[i] = null;
        }
        int totalTok = tokSP + tokJP + tokXP + tokRP;
        if (totalTok == 0) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "No matching tokens found in your inventory."));
            return;
        }
        if (gainedSP > 0) {
            prop.setSkillPoints(prop.getSkillPoints() + gainedSP);
            PacketDispatcher.sendTo(new SyncSkillPointsMessage((EntityPlayer)player), player);
        }
        if (gainedJP > 0) {
            prop.setJutsuPoints(prop.getJutsuPoints() + gainedJP);
            PacketDispatcher.sendTo(new SyncJutsuPointsMessage((EntityPlayer)player), player);
        }
        if (gainedXP > 0) {
            prop.setChakraExperience(prop.getChakraExperience() + gainedXP);
            PacketDispatcher.sendTo(new SyncChakraExperienceMessage((EntityPlayer)player), player);
        }
        if (gainedRP > 0) {
            prop.setResetPoints(prop.getResetPoints() + gainedRP);
            PacketDispatcher.sendTo(new SyncResetPointsMessage((EntityPlayer)player), player);
        }
        String consumed = EnumChatFormatting.GREEN + "Consumed " + totalTok + " token" + (totalTok == 1 ? "" : "s") + ":" + (tokSP > 0 ? " " + EnumChatFormatting.BLUE + tokSP + "\u00d7SP" : "") + (tokJP > 0 ? " " + EnumChatFormatting.GREEN + tokJP + "\u00d7JP" : "") + (tokXP > 0 ? " " + EnumChatFormatting.LIGHT_PURPLE + tokXP + "\u00d7XP" : "") + (tokRP > 0 ? " " + EnumChatFormatting.RED + tokRP + "\u00d7RP" : "");
        String gained = EnumChatFormatting.GREEN + "\u2192 gained:" + (gainedSP > 0 ? " " + EnumChatFormatting.BLUE + "+" + gainedSP + " SP" : "") + (gainedJP > 0 ? " " + EnumChatFormatting.GREEN + "+" + gainedJP + " JP" : "") + (gainedXP > 0 ? " " + EnumChatFormatting.LIGHT_PURPLE + "+" + gainedXP + " XP" : "") + (gainedRP > 0 ? " " + EnumChatFormatting.RED + "+" + gainedRP + " RP" : "");
        player.func_146105_b((IChatComponent)new ChatComponentText(consumed));
        player.func_146105_b((IChatComponent)new ChatComponentText(gained));
        player.field_71069_bz.func_75142_b();
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        return args.length == 1 ? CommandConsumeToken.func_71530_a((String[])args, (String[])KEYS) : null;
    }

    private String parseStatTokenType(ItemStack st) {
        String s = st.func_77977_a();
        int dot = s.indexOf(46) + 1;
        int tok = s.indexOf("Token_");
        return s.substring(dot, tok);
    }

    private double getRankMultiplier(String rank) {
        switch (rank) {
            case "Villager": {
                return NarutoEXPConfig.villagerMultiplier;
            }
            case "Genin": {
                return NarutoEXPConfig.geninMultiplier;
            }
            case "Chunin": {
                return NarutoEXPConfig.chuninMultiplier;
            }
            case "TokubetsuJonin": {
                return NarutoEXPConfig.tokubetsuJoninMultiplier;
            }
            case "Jonin": {
                return NarutoEXPConfig.joninMultiplier;
            }
            case "Missing-Nin": {
                return NarutoEXPConfig.missingNinMultiplier;
            }
            case "ExplosionCorps": {
                return NarutoEXPConfig.explosionCorpsMultiplier;
            }
            case "Taka": {
                return NarutoEXPConfig.takaMultiplier;
            }
            case "Hebi": {
                return NarutoEXPConfig.hebiMultiplier;
            }
            case "oftheBloodyMist": {
                return NarutoEXPConfig.oftheBloodyMistMultiplier;
            }
            case "Samurai": {
                return NarutoEXPConfig.samuraiMultiplier;
            }
            case "Anbu": {
                return NarutoEXPConfig.anbuMultiplier;
            }
            case "MedicalTeam": {
                return NarutoEXPConfig.medicalTeamMultiplier;
            }
            case "IntelTeam": {
                return NarutoEXPConfig.intelTeamMultiplier;
            }
            case "AnbuCaptain": {
                return NarutoEXPConfig.anbuCaptainMultiplier;
            }
            case "MedicalCaptain": {
                return NarutoEXPConfig.medicalCaptainMultiplier;
            }
            case "IntelCaptain": {
                return NarutoEXPConfig.intelCaptainMultiplier;
            }
            case "Akatsuki": {
                return NarutoEXPConfig.akatsukiMultiplier;
            }
            case "KinkakuForce": {
                return NarutoEXPConfig.kinkakuForceMultiplier;
            }
            case "12GuardianNinja": {
                return NarutoEXPConfig.twelveGuardianNinjaMultiplier;
            }
            case "PuppetBrigade": {
                return NarutoEXPConfig.puppetBrigadeMultiplier;
            }
            case "AcademyStudent": {
                return NarutoEXPConfig.academyStudentMultiplier;
            }
            case "7NinjaSwordsmen": {
                return NarutoEXPConfig.ninjaSwordsmenMultiplier;
            }
            case "Kage": {
                return NarutoEXPConfig.kageMultiplier;
            }
            case "AkatsukiLeader": {
                return NarutoEXPConfig.akatsukiLeaderMultiplier;
            }
            case "Sannin": {
                return NarutoEXPConfig.sanninMultiplier;
            }
            case "D-Rank": {
                return NarutoEXPConfig.dRankMultiplier;
            }
            case "C-Rank": {
                return NarutoEXPConfig.cRankMultiplier;
            }
            case "B-Rank": {
                return NarutoEXPConfig.bRankMultiplier;
            }
            case "A-Rank": {
                return NarutoEXPConfig.aRankMultiplier;
            }
            case "S-Rank": {
                return NarutoEXPConfig.sRankMultiplier;
            }
            case "TailedBeast": {
                return NarutoEXPConfig.tailedBeastMultiplier;
            }
        }
        return 1.0;
    }
}

