/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Commands;

import java.util.ArrayList;
import java.util.List;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.Final.JutsuItem;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandMastery
extends CommandBase {
    public String func_71517_b() {
        return "mastery";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/mastery <addxp/setxp/setlevel/levelup> <amount/level> [player] [slot/jutsu_name]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayerMP player;
        int amountOrLevel;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String action = args[0].toLowerCase();
        try {
            amountOrLevel = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("Amount or level must be a number.", new Object[0]);
        }
        if (args.length >= 3) {
            player = CommandMastery.func_82359_c((ICommandSender)sender, (String)args[2]);
        } else if (sender instanceof EntityPlayer) {
            player = (EntityPlayerMP)sender;
        } else {
            throw new WrongUsageException("You must specify a player if the command sender is not a player.", new Object[0]);
        }
        ExtendedPlayer props = ExtendedPlayer.get((EntityPlayer)player);
        ItemStack jutsuItemStack = null;
        int foundSlot = -1;
        if (args.length >= 4) {
            String slotOrJutsuName = args[3];
            try {
                int slot = Integer.parseInt(slotOrJutsuName) - 1;
                if (slot >= 0 && slot < 9) {
                    jutsuItemStack = player.field_71071_by.func_70301_a(slot);
                    foundSlot = slot;
                }
            }
            catch (NumberFormatException e) {
                jutsuItemStack = this.findJutsuByName(player, slotOrJutsuName);
                foundSlot = this.findJutsuSlotByName(player, slotOrJutsuName);
            }
            if (jutsuItemStack == null) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Could not find jutsu item by slot '" + slotOrJutsuName + "' or jutsu name '" + slotOrJutsuName + "'."));
                return;
            }
        } else {
            foundSlot = player.field_71071_by.field_70461_c;
            jutsuItemStack = player.field_71071_by.func_70301_a(foundSlot);
        }
        if (jutsuItemStack == null || !(jutsuItemStack.func_77973_b() instanceof JutsuItem)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("The specified item is not a jutsu item."));
            return;
        }
        NBTTagCompound tagCompound = jutsuItemStack.field_77990_d;
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("JutsuXP", 0);
            tagCompound.func_74768_a("JutsuLevel", 1);
            jutsuItemStack.field_77990_d = tagCompound;
        }
        if (!tagCompound.func_74764_b("JutsuXP")) {
            tagCompound.func_74768_a("JutsuXP", 0);
        }
        if (!tagCompound.func_74764_b("JutsuLevel")) {
            tagCompound.func_74768_a("JutsuLevel", 1);
        }
        String jutsuName = this.getJutsuDisplayName(jutsuItemStack);
        switch (action) {
            case "addxp": {
                this.addExperience(tagCompound, amountOrLevel);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Added " + amountOrLevel + " XP to " + jutsuName + "."));
                break;
            }
            case "setxp": {
                this.setExperience(tagCompound, amountOrLevel);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Set " + jutsuName + " XP to " + amountOrLevel + "."));
                break;
            }
            case "setlevel": {
                if (amountOrLevel < 1 || amountOrLevel > 100) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Level must be between 1 and 100."));
                    return;
                }
                tagCompound.func_74768_a("JutsuLevel", amountOrLevel);
                tagCompound.func_74768_a("JutsuXP", 0);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Set " + jutsuName + " level to " + amountOrLevel + " and reset XP."));
                break;
            }
            case "levelup": {
                int levelsToIncrease = args.length > 1 ? amountOrLevel : 1;
                this.levelUp(tagCompound, levelsToIncrease);
                sender.func_145747_a((IChatComponent)new ChatComponentText(jutsuName + " leveled up by " + levelsToIncrease + " level(s) to " + tagCompound.func_74762_e("JutsuLevel") + "."));
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    private ItemStack findJutsuByName(EntityPlayerMP player, String jutsuName) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            String itemName;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof JutsuItem) || !(itemName = this.getJutsuSearchName(stack)).equalsIgnoreCase(jutsuName) && !itemName.toLowerCase().contains(jutsuName.toLowerCase())) continue;
            return stack;
        }
        return null;
    }

    private int findJutsuSlotByName(EntityPlayerMP player, String jutsuName) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            String itemName;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof JutsuItem) || !(itemName = this.getJutsuSearchName(stack)).equalsIgnoreCase(jutsuName) && !itemName.toLowerCase().contains(jutsuName.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    private List<String> getPlayerJutsuNames(EntityPlayerMP player) {
        ArrayList<String> jutsuNames = new ArrayList<String>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            String jutsuName;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof JutsuItem) || jutsuNames.contains(jutsuName = this.getJutsuSearchName(stack))) continue;
            jutsuNames.add(jutsuName);
            String displayName = this.getJutsuDisplayName(stack);
            String cleanDisplayName = displayName.toLowerCase().replace(" ", "").replace("_", "");
            if (jutsuNames.contains(cleanDisplayName) || cleanDisplayName.equals(jutsuName)) continue;
            jutsuNames.add(cleanDisplayName);
        }
        return jutsuNames;
    }

    private String getJutsuDisplayName(ItemStack stack) {
        if (stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        return stack.func_77973_b().func_77658_a().substring(5);
    }

    private String getJutsuSearchName(ItemStack stack) {
        String unlocalizedName = stack.func_77973_b().func_77658_a();
        if (unlocalizedName.startsWith("item.")) {
            unlocalizedName = unlocalizedName.substring(5);
        }
        return unlocalizedName.toLowerCase().replace("_", "").replace(" ", "");
    }

    private List<String> getAllJutsuNames() {
        ArrayList<String> jutsuNames = new ArrayList<String>();
        for (Object itemObj : Item.field_150901_e) {
            Item item;
            String unlocalizedName;
            if (!(itemObj instanceof JutsuItem) || !(unlocalizedName = (item = (Item)itemObj).func_77658_a()).startsWith("item.")) continue;
            String cleanName = unlocalizedName.substring(5);
            jutsuNames.add(cleanName);
            if (!cleanName.contains("_")) continue;
            jutsuNames.add(cleanName.replace("_", ""));
        }
        return jutsuNames;
    }

    private void addExperience(NBTTagCompound tagCompound, int xpToAdd) {
        int currentXP = tagCompound.func_74762_e("JutsuXP");
        int currentLevel = tagCompound.func_74762_e("JutsuLevel");
        while (xpToAdd > 0 && currentLevel < 100) {
            int xpForNextLevel = this.getXpForNextLevel(currentLevel);
            int xpNeeded = xpForNextLevel - currentXP;
            if (xpToAdd >= xpNeeded) {
                ++currentLevel;
                xpToAdd -= xpNeeded;
                currentXP = 0;
                continue;
            }
            currentXP += xpToAdd;
            xpToAdd = 0;
        }
        tagCompound.func_74768_a("JutsuXP", currentXP);
        tagCompound.func_74768_a("JutsuLevel", currentLevel);
    }

    private void setExperience(NBTTagCompound tagCompound, int xpToSet) {
        int currentLevel = tagCompound.func_74762_e("JutsuLevel");
        while (xpToSet > 0 && currentLevel < 100) {
            int xpForNextLevel = this.getXpForNextLevel(currentLevel);
            if (xpToSet >= xpForNextLevel) {
                ++currentLevel;
                xpToSet -= xpForNextLevel;
                continue;
            }
            tagCompound.func_74768_a("JutsuXP", xpToSet);
            xpToSet = 0;
        }
        tagCompound.func_74768_a("JutsuLevel", currentLevel);
    }

    private void levelUp(NBTTagCompound tagCompound, int levelsToIncrease) {
        int currentLevel = tagCompound.func_74762_e("JutsuLevel");
        for (int i = 0; i < levelsToIncrease && currentLevel < 100; ++currentLevel, ++i) {
        }
        tagCompound.func_74768_a("JutsuLevel", currentLevel);
        tagCompound.func_74768_a("JutsuXP", 0);
    }

    private int getXpForNextLevel(int currentLevel) {
        return (int)(100.0 * Math.pow(1.5, currentLevel - 1));
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandMastery.func_71530_a((String[])args, (String[])new String[]{"addxp", "setxp", "setlevel", "levelup"});
        }
        if (args.length == 2) {
            String action;
            switch (action = args[0].toLowerCase()) {
                case "addxp": 
                case "setxp": {
                    return CommandMastery.func_71530_a((String[])args, (String[])new String[]{"100", "500", "1000", "2500", "5000", "10000", "25000", "50000"});
                }
                case "setlevel": {
                    return CommandMastery.func_71530_a((String[])args, (String[])new String[]{"1", "5", "10", "15", "20", "25", "30", "40", "50", "60", "70", "80", "90", "100"});
                }
                case "levelup": {
                    return CommandMastery.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "5", "10", "15", "20", "25"});
                }
            }
            return CommandMastery.func_71530_a((String[])args, (String[])new String[]{"1", "5", "10", "25", "50", "100"});
        }
        if (args.length == 3) {
            return CommandMastery.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        if (args.length == 4) {
            EntityPlayerMP targetPlayer = null;
            if (args.length >= 3) {
                try {
                    targetPlayer = CommandMastery.func_82359_c((ICommandSender)sender, (String)args[2]);
                }
                catch (Exception e) {
                    if (sender instanceof EntityPlayer) {
                        targetPlayer = (EntityPlayerMP)sender;
                    }
                }
            } else if (sender instanceof EntityPlayer) {
                targetPlayer = (EntityPlayerMP)sender;
            }
            ArrayList<String> options = new ArrayList<String>();
            for (int i = 1; i <= 9; ++i) {
                options.add(String.valueOf(i));
            }
            if (targetPlayer != null) {
                options.addAll(this.getPlayerJutsuNames(targetPlayer));
            }
            return CommandMastery.func_71530_a((String[])args, (String[])options.toArray(new String[0]));
        }
        return null;
    }

    public int func_82362_a() {
        return 2;
    }
}

