/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import narutodestination.Mathioks.ExtendedPlayer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandNarutoInspect
extends CommandBase {
    private static final DecimalFormat DF = new DecimalFormat("#,###");

    public String func_71517_b() {
        return "narutoinspect";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender s) {
        return "/narutoinspect <playerName|uuid>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (MinecraftServer.func_71276_C().func_71264_H()) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Just open your stat card ..."));
            return;
        }
        if (args.length != 1) {
            throw new PlayerNotFoundException("Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        String targetId = args[0];
        MinecraftServer server = MinecraftServer.func_71276_C();
        EntityPlayerMP online = server.func_71203_ab().func_152612_a(targetId);
        if (online != null) {
            long ticks = this.getPlayTicks(server, online.func_110124_au());
            this.printStats(sender, online.func_70005_c_(), ExtendedPlayer.get((EntityPlayer)online), true, ticks);
            return;
        }
        UUID uuid = null;
        try {
            uuid = UUID.fromString(targetId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (uuid == null) {
            throw new PlayerNotFoundException("Could not find saved data for '" + targetId + "'.", new Object[0]);
        }
        ExtendedPlayer extendedPlayer = new ExtendedPlayer();
        try {
            extendedPlayer.loadFromDatabase(uuid.toString());
            if (!extendedPlayer.getHasJoinedBefore()) {
                throw new PlayerNotFoundException("Could not find saved data for '" + targetId + "'.", new Object[0]);
            }
            long ticks = this.getPlayTicks(server, uuid);
            this.printStats(sender, this.resolveName(uuid, MinecraftServer.func_71276_C()), extendedPlayer, false, ticks);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getPlayTicks(MinecraftServer srv, UUID uuid) {
        File statsFile = new File(new File(srv.func_130014_f_().func_72860_G().func_75765_b(), "stats"), uuid.toString() + ".json");
        if (!statsFile.isFile()) {
            return -1L;
        }
        try (FileReader r = new FileReader(statsFile);){
            JsonElement rootEl = new JsonParser().parse((Reader)r);
            if (!rootEl.isJsonObject()) {
                long l = -1L;
                return l;
            }
            JsonObject root = rootEl.getAsJsonObject();
            if (root.has("stat.playOneMinute")) {
                long l = root.get("stat.playOneMinute").getAsLong();
                return l;
            }
            JsonObject stats = root.getAsJsonObject("stats");
            if (stats == null) return -1L;
            if (!stats.has("stat.playOneMinute")) return -1L;
            long l = ((JsonElement)((Map.Entry)stats.getAsJsonObject("stat.playOneMinute").entrySet().iterator().next()).getValue()).getAsLong();
            return l;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandNarutoInspect.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        return null;
    }

    private void printStats(ICommandSender to, String name, ExtendedPlayer ep, boolean online, long playTicks) {
        int soup = ep.getSageSoupCounter() * 5;
        int spent = ep.getTaijutsu() + ep.getKenjutsu() + ep.getSpeedPoints() + ep.getMedical() + ep.getKinjutsu() + ep.getNinjutsu() + ep.getShurikenJutsu() + ep.getSummoning() + ep.getGenjutsu() + (ep.getSenjutsu() - soup);
        int unspent = ep.getSkillPoints();
        this.header(to, name);
        this.line(to, "Skill Points (spent)", spent, EnumChatFormatting.GOLD);
        this.line(to, "Unspent Skill Pts", unspent, EnumChatFormatting.YELLOW);
        to.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_GRAY + ""));
        this.line(to, "Ninjutsu", ep.getNinjutsu(), EnumChatFormatting.AQUA);
        this.line(to, "Taijutsu", ep.getTaijutsu(), EnumChatFormatting.RED);
        this.line(to, "Genjutsu", ep.getGenjutsu(), EnumChatFormatting.DARK_PURPLE);
        this.line(to, "Kenjutsu", ep.getKenjutsu(), EnumChatFormatting.BLUE);
        this.line(to, "Senjutsu", ep.getSenjutsu(), EnumChatFormatting.DARK_AQUA, soup > 0 ? "  (\u00a7f" + soup + " refunded)" : "");
        this.line(to, "Medical", ep.getMedical(), EnumChatFormatting.DARK_GREEN);
        this.line(to, "Kinjutsu", ep.getKinjutsu(), EnumChatFormatting.GOLD);
        this.line(to, "Speed", ep.getSpeedPoints(), EnumChatFormatting.GRAY);
        this.footer(to);
        if (playTicks >= 0L) {
            this.lineTime(to, playTicks);
        }
        if (!online) {
            to.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.DARK_GRAY + "(offline data)"));
        }
    }

    private void header(ICommandSender to, String name) {
        to.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_GRAY + "\u2500\u2500\u2500\u2500\u2500  " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + "Stats for " + name + "  " + EnumChatFormatting.DARK_GRAY + "\u2500\u2500\u2500\u2500\u2500"));
    }

    private void footer(ICommandSender to) {
        to.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_GRAY + "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500"));
    }

    private void line(ICommandSender to, String label, int value, EnumChatFormatting col) {
        this.line(to, label, value, col, "");
    }

    private void line(ICommandSender to, String label, int value, EnumChatFormatting col, String suffix) {
        to.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + "\u2022 " + EnumChatFormatting.WHITE + label + EnumChatFormatting.GRAY + " \u2026\u2026\u2026\u2026 " + col + DF.format(value) + suffix));
    }

    private void lineTime(ICommandSender to, long ticks) {
        long totalSec = ticks / 20L;
        long hours = totalSec / 3600L;
        long mins = totalSec % 3600L / 60L;
        to.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + "\u2022 " + EnumChatFormatting.WHITE + "Play-time" + EnumChatFormatting.GRAY + " \u2026\u2026\u2026 " + EnumChatFormatting.AQUA + hours + " h " + mins + " min"));
    }

    private String resolveName(UUID uuid, MinecraftServer srv) {
        PlayerProfileCache cache = srv.func_152358_ax();
        GameProfile gp = cache.func_152652_a(uuid);
        if (gp != null && gp.getName() != null) {
            return gp.getName();
        }
        return uuid.toString();
    }
}

