/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class DNAConfig {
    public static Configuration configuration;
    public static int minimumIntelligenceToIdentify;
    public static int[] intelligenceThresholds;
    public static int[] identificationSuccessChances;
    public static int natureReleaseProbability;
    public static int kekkeiGenkaiProbability;
    public static int otsutsukiChanceWithinKekkeiGenkai;
    public static int minimumMedicalForNatureImplant;
    public static int minimumMedicalForKKGImplant;
    public static int minimumMedicalForDojutsuImplant;
    public static int minimumMedicalForOtsutsuki;
    public static int[] medicalThresholds;
    public static int[] implantSuccessChances;
    public static int successEffectDuration;
    public static int failureEffectDuration;
    public static int successDigSlowLevel;
    public static int successConfusionLevel;
    public static int successMoveSlowLevel;
    public static int successWeaknessLevel;
    public static int failureDigSlowLevel;
    public static int failureConfusionLevel;
    public static int failureMoveSlowLevel;
    public static int failureWeaknessLevel;
    public static int failurePoisonLevel;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        }
        try {
            configuration.load();
            DNAConfig.loadConfiguration();
        }
        catch (Exception e) {
            System.err.println("Error loading DNAConfig!");
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static void reload(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        } else {
            configuration.load();
        }
        DNAConfig.loadConfiguration();
    }

    private static void loadConfiguration() {
        minimumIntelligenceToIdentify = configuration.get("DNA Identification", "MinimumIntelligenceToIdentify", 20, "Minimum Intelligence stat required to identify DNA").getInt();
        int[] defaultIntelThresholds = new int[]{20, 40, 60, 80, 90, 100};
        intelligenceThresholds = configuration.get("DNA Identification", "IntelligenceThresholds", defaultIntelThresholds, "Intelligence thresholds for different identification success rates").getIntList();
        int[] defaultSuccessChances = new int[]{1, 5, 15, 25, 50, 70};
        identificationSuccessChances = configuration.get("DNA Identification", "IdentificationSuccessChances", defaultSuccessChances, "Success chances (%) for each intelligence threshold").getIntList();
        natureReleaseProbability = configuration.get("DNA Identification", "NatureReleaseProbability", 90, "Probability (%) of getting Nature Release DNA when identifying").getInt();
        otsutsukiChanceWithinKekkeiGenkai = configuration.get("DNA Identification", "OtsutsukiChanceWithinKekkeiGenkai", 5, "Chance (%) of getting Otsutsuki DNA within Kekkei Genkai results").getInt();
        minimumMedicalForNatureImplant = configuration.get("DNA Implantation", "MinimumMedicalForNatureImplant", 50, "Minimum Medical stat required to implant Nature DNA").getInt();
        minimumMedicalForKKGImplant = configuration.get("DNA Implantation", "MinimumMedicalForKekkeiGenkaiImplant", 300, "Minimum Medical stat required to implant Kekkei Genkai DNA").getInt();
        minimumMedicalForDojutsuImplant = configuration.get("DNA Implantation", "MinimumMedicalForDojutsuImplant", 500, "Minimum Medical stat required to implant Dojutsu DNA").getInt();
        minimumMedicalForOtsutsuki = configuration.get("DNA Implantation", "MinimumMedicalForOtsutsuki", 10000, "Minimum Medical stat required to implant Otsutsuki DNA").getInt();
        int[] defaultMedicalThresholds = new int[]{300, 400, 500};
        medicalThresholds = configuration.get("DNA Implantation", "MedicalThresholds", defaultMedicalThresholds, "Medical stat thresholds for different implant success rates").getIntList();
        int[] defaultImplantChances = new int[]{20, 40, 70};
        implantSuccessChances = configuration.get("DNA Implantation", "ImplantSuccessChances", defaultImplantChances, "Success chances (%) for each medical threshold").getIntList();
        successEffectDuration = configuration.get("Potion Effects", "SuccessEffectDuration", 200, "Duration (ticks) of potion effects on successful DNA implant").getInt();
        failureEffectDuration = configuration.get("Potion Effects", "FailureEffectDuration", 600, "Duration (ticks) of potion effects on failed DNA implant").getInt();
        successDigSlowLevel = configuration.get("Potion Effects", "SuccessDigSlowLevel", 5, "Mining Fatigue level for successful implant").getInt();
        successConfusionLevel = configuration.get("Potion Effects", "SuccessConfusionLevel", 50, "Nausea level for successful implant").getInt();
        successMoveSlowLevel = configuration.get("Potion Effects", "SuccessMoveSlowLevel", 5, "Slowness level for successful implant").getInt();
        successWeaknessLevel = configuration.get("Potion Effects", "SuccessWeaknessLevel", 50, "Weakness level for successful implant").getInt();
        failureDigSlowLevel = configuration.get("Potion Effects", "FailureDigSlowLevel", 5, "Mining Fatigue level for failed implant").getInt();
        failureConfusionLevel = configuration.get("Potion Effects", "FailureConfusionLevel", 50, "Nausea level for failed implant").getInt();
        failureMoveSlowLevel = configuration.get("Potion Effects", "FailureMoveSlowLevel", 5, "Slowness level for failed implant").getInt();
        failureWeaknessLevel = configuration.get("Potion Effects", "FailureWeaknessLevel", 50, "Weakness level for failed implant").getInt();
        failurePoisonLevel = configuration.get("Potion Effects", "FailurePoisonLevel", 1, "Poison level for failed implant").getInt();
        kekkeiGenkaiProbability = 100 - natureReleaseProbability;
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void reload() {
        if (configuration != null) {
            configuration.load();
            DNAConfig.loadConfiguration();
        }
    }

    public static int getIdentificationChance(int intelligence) {
        for (int i = intelligenceThresholds.length - 1; i >= 0; --i) {
            if (intelligence < intelligenceThresholds[i]) continue;
            return identificationSuccessChances[i];
        }
        return 0;
    }

    public static int getImplantChance(int medical) {
        for (int i = medicalThresholds.length - 1; i >= 0; --i) {
            if (medical < medicalThresholds[i]) continue;
            return implantSuccessChances[i];
        }
        return 0;
    }

    static {
        minimumIntelligenceToIdentify = 20;
        intelligenceThresholds = new int[]{20, 40, 60, 80, 90, 100};
        identificationSuccessChances = new int[]{1, 5, 15, 25, 50, 70};
        natureReleaseProbability = 90;
        kekkeiGenkaiProbability = 10;
        otsutsukiChanceWithinKekkeiGenkai = 5;
        minimumMedicalForNatureImplant = 50;
        minimumMedicalForKKGImplant = 300;
        minimumMedicalForDojutsuImplant = 500;
        minimumMedicalForOtsutsuki = 10000;
        medicalThresholds = new int[]{300, 400, 500};
        implantSuccessChances = new int[]{20, 40, 70};
        successEffectDuration = 200;
        failureEffectDuration = 600;
        successDigSlowLevel = 5;
        successConfusionLevel = 50;
        successMoveSlowLevel = 5;
        successWeaknessLevel = 50;
        failureDigSlowLevel = 5;
        failureConfusionLevel = 50;
        failureMoveSlowLevel = 5;
        failureWeaknessLevel = 50;
        failurePoisonLevel = 1;
    }
}

