/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Config;

import java.io.File;
import narutodestination.Mathioks.ExtendedPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;

public class KenjutsuConfig {
    public static Configuration configuration;
    public static double heavenCutterScaling;
    public static double crescentMoonScaling;
    public static double shockwaveSlashScaling;
    public static double moonlightScaling;
    public static double flashScaling;
    public static int heavenCutterStatic;
    public static int crescentMoonStatic;
    public static int shockwaveSlashStatic;
    public static int moonlightStatic;
    public static int flashStatic;
    public static int heavenCutterCooldown;
    public static int crescentMoonCooldown;
    public static int shockwaveSlashCooldown;
    public static int moonlightCooldown;
    public static int flashCooldown;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        }
        try {
            configuration.load();
            KenjutsuConfig.loadConfiguration();
        }
        catch (Exception e) {
            System.err.println("Error loading KenjutsuConfig!");
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void loadConfiguration() {
        heavenCutterScaling = configuration.get("general", "HeavenCutterScaling", 0.08, "Determines how Heaven Cutter damage scales with the Kenjutsu stat (e.g. 0.08 damage per point).").getDouble();
        crescentMoonScaling = configuration.get("general", "CrescentMoonScaling", 0.09, "Determines how Crescent Moon Slash damage scales with the Kenjutsu stat (e.g. 0.09 damage per point).").getDouble();
        shockwaveSlashScaling = configuration.get("general", "ShockwaveSlashScaling", 0.06, "Determines how Shockwave Slash damage scales with the Kenjutsu stat (e.g. 0.06 damage per point).").getDouble();
        moonlightScaling = configuration.get("general", "MoonlightScaling", 0.07, "Determines how Moonlight technique damage scales with the Kenjutsu stat (e.g. 0.07 damage per point).").getDouble();
        flashScaling = configuration.get("general", "FlashScaling", 0.1, "Determines how Flash technique damage scales with the Kenjutsu stat (e.g. 0.10 damage per point).").getDouble();
        heavenCutterStatic = configuration.get("general", "HeavenCutterStatic", 5, "Base damage for the Heaven Cutter technique.").getInt();
        crescentMoonStatic = configuration.get("general", "CrescentMoonStatic", 5, "Base damage for the Crescent Moon Slash technique.").getInt();
        shockwaveSlashStatic = configuration.get("general", "ShockwaveSlashStatic", 5, "Base damage for the Shockwave Slash technique.").getInt();
        moonlightStatic = configuration.get("general", "MoonlightStatic", 5, "Base damage for the Moonlight technique.").getInt();
        flashStatic = configuration.get("general", "FlashStatic", 5, "Base damage for the Flash technique.").getInt();
        heavenCutterCooldown = configuration.get("general", "HeavenCutterCooldown", 100, "Cooldown time in ticks for the Heaven Cutter technique (20 ticks = 1 second).").getInt();
        crescentMoonCooldown = configuration.get("general", "CrescentMoonCooldown", 100, "Cooldown time in ticks for the Crescent Moon Slash technique (20 ticks = 1 second).").getInt();
        shockwaveSlashCooldown = configuration.get("general", "ShockwaveSlashCooldown", 100, "Cooldown time in ticks for the Chakra Shockwave Slash technique (20 ticks = 1 second).").getInt();
        moonlightCooldown = configuration.get("general", "MoonlightCooldown", 100, "Cooldown time in ticks for the Moonlight technique (20 ticks = 1 second).").getInt();
        flashCooldown = configuration.get("general", "FlashCooldown", 100, "Cooldown time in ticks for the Flash technique (20 ticks = 1 second).").getInt();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static int getHeavenCutterDamage(EntityPlayer player) {
        ExtendedPlayer props = ExtendedPlayer.get(player);
        return (int)((double)heavenCutterStatic + heavenCutterScaling * (double)props.getKenjutsu());
    }

    public static int getCrescentMoonDamage(EntityPlayer player) {
        ExtendedPlayer props = ExtendedPlayer.get(player);
        return (int)((double)crescentMoonStatic + crescentMoonScaling * (double)props.getKenjutsu());
    }

    public static int getShockwaveSlashDamage(EntityPlayer player) {
        ExtendedPlayer props = ExtendedPlayer.get(player);
        return (int)((double)shockwaveSlashStatic + shockwaveSlashScaling * (double)props.getKenjutsu());
    }

    public static int getHeavenCutterDamage(ExtendedPlayer props) {
        return (int)((double)heavenCutterStatic + heavenCutterScaling * (double)props.getKenjutsu());
    }

    public static int getCrescentMoonDamage(ExtendedPlayer props) {
        return (int)((double)crescentMoonStatic + crescentMoonScaling * (double)props.getKenjutsu());
    }

    public static int getShockwaveSlashDamage(ExtendedPlayer props) {
        return (int)((double)shockwaveSlashStatic + shockwaveSlashScaling * (double)props.getKenjutsu());
    }

    public static int getMoonlightDamage(EntityPlayer player) {
        ExtendedPlayer props = ExtendedPlayer.get(player);
        return (int)((double)moonlightStatic + moonlightScaling * (double)props.getKenjutsu());
    }

    public static int getFlashDamage(EntityPlayer player) {
        ExtendedPlayer props = ExtendedPlayer.get(player);
        return (int)((double)flashStatic + flashScaling * (double)props.getKenjutsu());
    }

    public static int getMoonlightDamage(ExtendedPlayer props) {
        return (int)((double)moonlightStatic + moonlightScaling * (double)props.getKenjutsu());
    }

    public static int getFlashDamage(ExtendedPlayer props) {
        return (int)((double)flashStatic + flashScaling * (double)props.getKenjutsu());
    }

    static {
        heavenCutterScaling = 0.08;
        crescentMoonScaling = 0.09;
        shockwaveSlashScaling = 0.06;
        moonlightScaling = 0.07;
        flashScaling = 0.1;
        heavenCutterStatic = 5;
        crescentMoonStatic = 5;
        shockwaveSlashStatic = 5;
        moonlightStatic = 5;
        flashStatic = 5;
        heavenCutterCooldown = 100;
        crescentMoonCooldown = 100;
        shockwaveSlashCooldown = 100;
        moonlightCooldown = 100;
        flashCooldown = 100;
    }
}

