/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Config;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import narutodestination.Mathioks.SkillLearners.BaseSkillLearner;
import net.minecraftforge.common.config.Configuration;

public class LearnerConfig {
    private static Configuration configuration;
    private static final Map<String, Map<String, Boolean>> learnerProgressionStates;
    private static final Map<String, Map<String, Integer>> learnerProgressionCosts;
    private static final Map<String, List<ProgressionInfo>> learnerProgressions;
    private static Set<Class<? extends BaseSkillLearner>> discoveredLearners;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        }
        try {
            configuration.load();
            LearnerConfig.discoverSkillLearners();
            LearnerConfig.loadConfiguration();
            BaseSkillLearner.forceConfigReload();
        }
        catch (Exception e) {
            System.err.println("Error loading LearnerConfig!");
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void discoverSkillLearners() {
        discoveredLearners.clear();
        learnerProgressions.clear();
        try {
            discoveredLearners = new HashSet<Class<? extends BaseSkillLearner>>(BaseSkillLearner.REGISTERED_LEARNERS);
            for (Class<? extends BaseSkillLearner> learnerClass : discoveredLearners) {
                LearnerConfig.extractProgressionInfo(learnerClass);
            }
        }
        catch (Exception e) {
            System.err.println("Error discovering skill learners: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("Discovered " + discoveredLearners.size() + " skill learners");
        for (Class<? extends BaseSkillLearner> learner : discoveredLearners) {
            System.out.println("  - " + learner.getSimpleName());
        }
    }

    private static void extractProgressionInfo(Class<? extends BaseSkillLearner> learnerClass) {
        try {
            BaseSkillLearner learnerInstance = learnerClass.newInstance();
            Field progressionField = BaseSkillLearner.class.getDeclaredField("progression");
            progressionField.setAccessible(true);
            List progression = (List)progressionField.get((Object)learnerInstance);
            ArrayList<ProgressionInfo> progressionInfos = new ArrayList<ProgressionInfo>();
            for (Object item : progression) {
                Class<?> itemClass = item.getClass();
                Field descField = itemClass.getDeclaredField("description");
                Field jpCostField = itemClass.getDeclaredField("jpCost");
                descField.setAccessible(true);
                jpCostField.setAccessible(true);
                String description = (String)descField.get(item);
                int jpCost = (Integer)jpCostField.get(item);
                String type = itemClass.getSimpleName();
                progressionInfos.add(new ProgressionInfo(description, type, jpCost));
            }
            learnerProgressions.put(learnerClass.getSimpleName(), progressionInfos);
        }
        catch (Exception e) {
            System.err.println("Error extracting progression info from " + learnerClass.getSimpleName() + ": " + e.getMessage());
        }
    }

    private static void loadConfiguration() {
        learnerProgressionStates.clear();
        learnerProgressionCosts.clear();
        for (Class<? extends BaseSkillLearner> learnerClass : discoveredLearners) {
            String learnerName = learnerClass.getSimpleName();
            LearnerConfig.configureLearner(learnerName);
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private static void configureLearner(String learnerName) {
        String category = "SkillLearners." + learnerName;
        HashMap<String, Boolean> states = new HashMap<String, Boolean>();
        HashMap<String, Integer> costs = new HashMap<String, Integer>();
        List<ProgressionInfo> progressions = learnerProgressions.get(learnerName);
        if (progressions == null) {
            return;
        }
        configuration.setCategoryComment(category, "Configuration for " + learnerName + " progression steps");
        int index = 1;
        for (ProgressionInfo info : progressions) {
            String baseKey = String.format("%02d_%s", index, info.description.replaceAll("[^a-zA-Z0-9_]", "_"));
            String enabledKey = baseKey + "_Enabled";
            String enabledComment = String.format("%s: %s (Default Cost: %d JP)", info.type, info.description, info.jpCost);
            boolean enabled = configuration.get(category, enabledKey, true, enabledComment).getBoolean();
            String costKey = baseKey + "_Cost";
            String costComment = String.format("JP cost for %s", info.description);
            int cost = configuration.get(category, costKey, info.jpCost, costComment, 1, Integer.MAX_VALUE).getInt();
            states.put(info.description, enabled);
            costs.put(info.description, cost);
            ++index;
        }
        learnerProgressionStates.put(learnerName, states);
        learnerProgressionCosts.put(learnerName, costs);
    }

    public static boolean isProgressionEnabled(Class<?> learnerClass, String progressionDescription) {
        return LearnerConfig.isProgressionEnabled(learnerClass.getSimpleName(), progressionDescription);
    }

    public static boolean isProgressionEnabled(String learnerName, String progressionDescription) {
        Map<String, Boolean> learnerStates = learnerProgressionStates.get(learnerName);
        if (learnerStates != null) {
            Boolean state = learnerStates.get(progressionDescription);
            return state != null ? state : true;
        }
        return true;
    }

    public static int getProgressionCost(Class<?> learnerClass, String progressionDescription, int defaultCost) {
        return LearnerConfig.getProgressionCost(learnerClass.getSimpleName(), progressionDescription, defaultCost);
    }

    public static int getProgressionCost(String learnerName, String progressionDescription, int defaultCost) {
        Map<String, Integer> learnerCosts = learnerProgressionCosts.get(learnerName);
        if (learnerCosts != null) {
            Integer cost = learnerCosts.get(progressionDescription);
            return cost != null ? cost : defaultCost;
        }
        return defaultCost;
    }

    public static void reload() {
        if (configuration != null) {
            LearnerConfig.discoverSkillLearners();
            configuration.load();
            LearnerConfig.loadConfiguration();
            BaseSkillLearner.forceConfigReload();
        }
    }

    public static Set<String> getDiscoveredLearners() {
        HashSet<String> names = new HashSet<String>();
        for (Class<? extends BaseSkillLearner> clazz : discoveredLearners) {
            names.add(clazz.getSimpleName());
        }
        return names;
    }

    public static List<String> getLearnerProgressions(String learnerName) {
        ArrayList<String> progressions = new ArrayList<String>();
        List<ProgressionInfo> infos = learnerProgressions.get(learnerName);
        if (infos != null) {
            for (ProgressionInfo info : infos) {
                progressions.add(info.description);
            }
        }
        return progressions;
    }

    public static List<String> getLearnerProgressionDetails(String learnerName) {
        ArrayList<String> details = new ArrayList<String>();
        List<ProgressionInfo> infos = learnerProgressions.get(learnerName);
        Map<String, Integer> costs = learnerProgressionCosts.get(learnerName);
        if (infos != null && costs != null) {
            for (ProgressionInfo info : infos) {
                Integer configuredCost = costs.get(info.description);
                int actualCost = configuredCost != null ? configuredCost : info.jpCost;
                details.add(String.format("%s (Cost: %d JP)", info.description, actualCost));
            }
        }
        return details;
    }

    static {
        learnerProgressionStates = new HashMap<String, Map<String, Boolean>>();
        learnerProgressionCosts = new HashMap<String, Map<String, Integer>>();
        learnerProgressions = new HashMap<String, List<ProgressionInfo>>();
        discoveredLearners = new HashSet<Class<? extends BaseSkillLearner>>();
    }

    private static class ProgressionInfo {
        final String description;
        final String type;
        final int jpCost;

        ProgressionInfo(String description, String type, int jpCost) {
            this.description = description;
            this.type = type;
            this.jpCost = jpCost;
        }
    }
}

