/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.DNA;

import java.util.List;
import narutodestination.Mathioks.Config.DNAConfig;
import narutodestination.Mathioks.CreativeTabLoader;
import narutodestination.Mathioks.ExtendedPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class BaseDNA
extends Item {
    protected abstract boolean hasKekkeiGenkai(ExtendedPlayer var1);

    protected abstract void applyKekkeiGenkai(ExtendedPlayer var1);

    protected abstract ItemStack getSkillLearnerItem();

    protected abstract String getSuccessMessage();

    protected abstract String getAlreadyHasMessage();

    protected abstract void sendSyncMessage(EntityPlayerMP var1);

    protected int getMinimumMedicalRequirement() {
        if (this.isNature()) {
            return DNAConfig.minimumMedicalForNatureImplant;
        }
        if (this.isKekkeiGenkai()) {
            return DNAConfig.minimumMedicalForKKGImplant;
        }
        if (this.isDojutsu()) {
            return DNAConfig.minimumMedicalForDojutsuImplant;
        }
        return 0;
    }

    protected boolean isNature() {
        return false;
    }

    protected boolean isKekkeiGenkai() {
        return false;
    }

    protected boolean isDojutsu() {
        return false;
    }

    public BaseDNA() {
        this.func_77656_e(10);
        this.func_77625_d(64);
        this.func_77637_a(CreativeTabLoader.tabRelease);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.performImplant(player, player, itemStack, world);
        }
        return itemStack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity target) {
        if (target instanceof EntityPlayer && !player.field_70170_p.field_72995_K) {
            EntityPlayer targetPlayer = (EntityPlayer)target;
            ExtendedPlayer targetProps = ExtendedPlayer.get(targetPlayer);
            ExtendedPlayer playerProps = ExtendedPlayer.get(player);
            if (!targetPlayer.func_70093_af()) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The target must be sneaking to receive the DNA implant!"));
                return false;
            }
            int requiredMedical = this.getMinimumMedicalRequirement();
            if (playerProps.getMedical() < requiredMedical) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need at least " + requiredMedical + " Medical to implant this DNA!"));
                return false;
            }
            if (this.hasKekkeiGenkai(targetProps)) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The target already possesses this DNA."));
                return false;
            }
            this.performImplant(player, targetPlayer, stack, player.field_70170_p);
            return true;
        }
        return false;
    }

    private void performImplant(EntityPlayer sourcePlayer, EntityPlayer targetPlayer, ItemStack itemStack, World world) {
        int requiredMedical;
        ExtendedPlayer targetProps = ExtendedPlayer.get(targetPlayer);
        ExtendedPlayer sourceProps = ExtendedPlayer.get(sourcePlayer);
        if (this.hasKekkeiGenkai(targetProps)) {
            sourcePlayer.func_146105_b((IChatComponent)new ChatComponentText(this.getAlreadyHasMessage()));
            return;
        }
        int medicalStat = sourceProps.getMedical();
        if (medicalStat < (requiredMedical = this.getMinimumMedicalRequirement())) {
            sourcePlayer.func_146105_b((IChatComponent)new ChatComponentText("You need at least " + requiredMedical + " Medical to implant this DNA."));
            return;
        }
        int successChance = DNAConfig.getImplantChance(medicalStat);
        int rand = world.field_73012_v.nextInt(100);
        if (rand < successChance) {
            this.successfulImplant(sourcePlayer, targetPlayer, targetProps, itemStack);
        } else {
            this.failedImplant(targetPlayer, itemStack);
        }
    }

    private void successfulImplant(EntityPlayer sourcePlayer, EntityPlayer targetPlayer, ExtendedPlayer targetProps, ItemStack itemStack) {
        this.applyKekkeiGenkai(targetProps);
        if (!targetPlayer.field_70170_p.field_72995_K && targetPlayer instanceof EntityPlayerMP) {
            this.sendSyncMessage((EntityPlayerMP)targetPlayer);
        }
        sourcePlayer.func_146105_b((IChatComponent)new ChatComponentText(this.getSuccessMessage()));
        targetPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "DNA implanted successfully!"));
        this.applyImplantEffects(targetPlayer, true);
        ItemStack skillLearner = this.getSkillLearnerItem();
        if (skillLearner != null) {
            targetPlayer.field_71071_by.func_70441_a(skillLearner);
        }
        if (!sourcePlayer.field_71075_bZ.field_75098_d) {
            --itemStack.field_77994_a;
        }
    }

    private void applyImplantEffects(EntityPlayer player, boolean success) {
        int duration;
        int n = duration = success ? DNAConfig.successEffectDuration : DNAConfig.failureEffectDuration;
        if (success) {
            player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, duration, DNAConfig.successDigSlowLevel));
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, duration, DNAConfig.successConfusionLevel));
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, duration, DNAConfig.successMoveSlowLevel));
            player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, duration, DNAConfig.successWeaknessLevel));
        } else {
            player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, duration, DNAConfig.failureDigSlowLevel));
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, duration, DNAConfig.failureConfusionLevel));
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, duration, DNAConfig.failureMoveSlowLevel));
            player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, duration, DNAConfig.failureWeaknessLevel));
            player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, duration, DNAConfig.failurePoisonLevel));
        }
    }

    private void failedImplant(EntityPlayer targetPlayer, ItemStack itemStack) {
        targetPlayer.func_146105_b((IChatComponent)new ChatComponentText("The DNA implant failed.."));
        targetPlayer.func_146105_b((IChatComponent)new ChatComponentText("You still feel weak because of the effects and your blood is poisoned!"));
        this.applyImplantEffects(targetPlayer, false);
        if (!targetPlayer.field_71075_bZ.field_75098_d) {
            --itemStack.field_77994_a;
        }
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        int requiredMedical;
        ExtendedPlayer props = ExtendedPlayer.get(player);
        int medicalStat = props.getMedical();
        if (medicalStat < (requiredMedical = this.getMinimumMedicalRequirement())) {
            list.add(EnumChatFormatting.RED + "You need at least " + requiredMedical + " Medical to implant this DNA.");
        } else {
            int successChance = DNAConfig.getImplantChance(medicalStat);
            list.add(EnumChatFormatting.GREEN + "You have a " + successChance + "% chance to implant DNA successfully.");
        }
        list.add(EnumChatFormatting.GRAY + "Success effects: " + DNAConfig.successEffectDuration / 20 + "s");
        list.add(EnumChatFormatting.GRAY + "Failure effects: " + DNAConfig.failureEffectDuration / 20 + "s (+ poison)");
    }
}

