/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import narutodestination.Mathioks.block.JutsuBlock;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class DustAtomicDismantlingCubeEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final ResourceLocation CUBE_TEXTURE = new ResourceLocation("tm:textures/entity/dust_cube.png");
    private static final ResourceLocation SPHERE_TEXTURE = new ResourceLocation("tm:textures/entity/dust_sphere.png");
    private EntityPlayer owner;
    private double damage;
    private int duration = 50;
    private static final Random RANDOM = new Random();
    public float currentScale = 1.0f;
    public static final float MAX_SCALE = 7.0f;
    private final float rotationX = -10.0f + RANDOM.nextFloat() * 20.0f;
    private final float rotationY = -10.0f + RANDOM.nextFloat() * 20.0f;
    private final float rotationZ = -10.0f + RANDOM.nextFloat() * 20.0f;

    public DustAtomicDismantlingCubeEntity(World world) {
        super(world);
    }

    public DustAtomicDismantlingCubeEntity(World world, EntityPlayer owner, double damage) {
        this(world);
        this.owner = owner;
        this.damage = damage;
        this.currentScale = 1.0f;
    }

    protected void func_70088_a() {
        this.func_70096_w().func_75682_a(20, (Object)255);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 40 && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false);
            AxisAlignedBB detectionBox = this.field_70121_D.func_72314_b(3.5, 3.5, 3.5);
            List entitiesInCube = this.field_70170_p.func_72872_a(EntityLivingBase.class, detectionBox);
            for (EntityLivingBase entity : entitiesInCube) {
                if (entity == this.owner) continue;
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.owner), (float)this.damage);
            }
            int minX = (int)Math.floor(detectionBox.field_72340_a);
            int minY = (int)Math.floor(detectionBox.field_72338_b);
            int minZ = (int)Math.floor(detectionBox.field_72339_c);
            int maxX = (int)Math.ceil(detectionBox.field_72336_d);
            int maxY = (int)Math.ceil(detectionBox.field_72337_e);
            int maxZ = (int)Math.ceil(detectionBox.field_72334_f);
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (!(this.field_70170_p.func_147439_a(x, y, z) instanceof JutsuBlock)) continue;
                        this.field_70170_p.func_147468_f(x, y, z);
                    }
                }
            }
        }
        if (this.field_70173_aa >= 50 && this.field_70173_aa < 60) {
            float fadeFactor = 1.0f - (float)(this.field_70173_aa - 50) / 10.0f;
            this.setEntityAlpha(fadeFactor);
        }
        if (this.field_70173_aa >= 60) {
            this.func_70106_y();
        }
    }

    private void setEntityAlpha(float alpha) {
        this.func_70096_w().func_75692_b(20, (Object)Math.round(alpha * 255.0f));
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        this.duration = tagCompound.func_74762_e("Duration");
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Duration", this.duration);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.duration);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.duration = additionalData.readInt();
    }

    @SideOnly(value=Side.CLIENT)
    public static class Renderer
    extends Render {
        private final ModelDustAtomicCube model = new ModelDustAtomicCube();
        private final ModelDustSphere modelSphere = new ModelDustSphere();
        private static final float SCALE_INCREMENT = 0.25f;

        protected ResourceLocation func_110775_a(Entity entity) {
            return CUBE_TEXTURE;
        }

        public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTicks) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            DustAtomicDismantlingCubeEntity cubeEntity = (DustAtomicDismantlingCubeEntity)entity;
            if (cubeEntity.currentScale < 7.0f) {
                cubeEntity.currentScale += 0.25f;
                if (cubeEntity.currentScale > 7.0f) {
                    cubeEntity.currentScale = 7.0f;
                }
            }
            float alpha = (float)cubeEntity.func_70096_w().func_75679_c(20) / 255.0f;
            GL11.glRotatef((float)cubeEntity.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)cubeEntity.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)cubeEntity.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)cubeEntity.currentScale, (float)cubeEntity.currentScale, (float)cubeEntity.currentScale);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GL11.glDisable((int)2884);
            GL11.glDepthMask((boolean)false);
            this.func_110777_b(entity);
            this.model.renderOuterCube(0.0625f);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            float sphereScale = cubeEntity.currentScale * 1.0f;
            GL11.glScalef((float)sphereScale, (float)sphereScale, (float)sphereScale);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.func_110776_a(SPHERE_TEXTURE);
            this.modelSphere.renderSphere(0.0625f);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }

        @SideOnly(value=Side.CLIENT)
        public static class ModelDustSphere
        extends ModelBase {
            private final ModelRenderer sphere = new ModelRenderer((ModelBase)this);

            public ModelDustSphere() {
                this.sphere.func_78789_a(-0.5f, -0.5f, -0.5f, 1, 1, 1);
            }

            public void renderSphere(float scale) {
                this.sphere.func_78785_a(scale);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static class ModelDustAtomicCube
        extends ModelBase {
            private final ModelRenderer outerCube = new ModelRenderer((ModelBase)this);

            public ModelDustAtomicCube() {
                this.outerCube.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 16, 16);
            }

            public void renderOuterCube(float scale) {
                this.outerCube.func_78785_a(scale);
            }
        }
    }
}

