/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class DustAtomicDismantlingCylinderEntity
extends Entity {
    private static final ResourceLocation CYLINDER_TEXTURE = new ResourceLocation("tm:textures/entity/dust_cylinder.png");
    private EntityPlayer owner;
    private double damage;
    private int duration = 100;
    private final double length = 5.0;

    public DustAtomicDismantlingCylinderEntity(World world) {
        super(world);
    }

    public DustAtomicDismantlingCylinderEntity(World world, EntityPlayer owner, double damage) {
        super(world);
        this.owner = owner;
        this.damage = damage;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.owner == null || this.owner.field_70128_L) {
            this.func_70106_y();
            return;
        }
        Vec3 look = this.owner.func_70040_Z();
        double offsetX = look.field_72450_a * 5.0 * 0.5;
        double offsetY = look.field_72448_b * 5.0 * 0.5;
        double offsetZ = look.field_72449_c * 5.0 * 0.5;
        this.func_70107_b(this.owner.field_70165_t + look.field_72450_a, this.owner.field_70163_u + (double)this.owner.func_70047_e() + look.field_72448_b, this.owner.field_70161_v + look.field_72449_c);
        AxisAlignedBB beamBoundingBox = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 0.5), (double)(this.field_70163_u - 0.5), (double)(this.field_70161_v - 0.5), (double)(this.field_70165_t + offsetX), (double)(this.field_70163_u + offsetY), (double)(this.field_70161_v + offsetZ)).func_72314_b(0.5, 0.5, 0.5);
        if (!this.field_70170_p.field_72995_K) {
            List entitiesInRange = this.field_70170_p.func_72872_a(EntityLivingBase.class, beamBoundingBox);
            for (EntityLivingBase entity : entitiesInRange) {
                if (entity == this.owner) continue;
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.owner), (float)this.damage);
            }
        }
        if (--this.duration <= 0) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        this.duration = tagCompound.func_74762_e("Duration");
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Duration", this.duration);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Renderer
    extends Render {
        private static final ResourceLocation CYLINDER_TEXTURE = new ResourceLocation("tm:textures/entity/dust_cylinder.png");
        private final ModelCylinder model = new ModelCylinder();

        protected ResourceLocation func_110775_a(Entity entity) {
            return CYLINDER_TEXTURE;
        }

        public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTicks) {
            if (!(entity instanceof DustAtomicDismantlingCylinderEntity)) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            DustAtomicDismantlingCylinderEntity cylinderEntity = (DustAtomicDismantlingCylinderEntity)entity;
            EntityPlayer owner = cylinderEntity.owner;
            if (owner != null) {
                Vec3 look = owner.func_70040_Z();
                double pitch = Math.toDegrees(Math.asin(look.field_72448_b));
                double yawRotation = Math.toDegrees(Math.atan2(look.field_72449_c, look.field_72450_a)) - 90.0;
                GL11.glRotatef((float)((float)(-yawRotation)), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(-pitch)), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glScalef((float)1.0f, (float)1.0f, (float)5.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            this.func_110777_b(entity);
            this.model.render(0.125f);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }

        @SideOnly(value=Side.CLIENT)
        public static class ModelCylinder
        extends ModelBase {
            private final ModelRenderer cylinder = new ModelRenderer((ModelBase)this, 0, 0);

            public ModelCylinder() {
                this.cylinder.func_78789_a(-0.5f, -0.5f, -0.5f, 1, 1, 1);
            }

            public void render(float scale) {
                this.cylinder.func_78785_a(scale);
            }
        }
    }
}

