/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.ExtraFunctions;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import narutodestination.Mathioks.AbstractMessage;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncSpeedMessage;
import narutodestination.Mathioks.PacketDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;

public class IncreaseSpeedMessage
extends AbstractMessage<IncreaseSpeedMessage> {
    private int increaseValue;

    public IncreaseSpeedMessage() {
    }

    public IncreaseSpeedMessage(int increaseValue) {
        this.increaseValue = increaseValue;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.increaseValue = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.increaseValue);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            return;
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.get(player);
        int skillPoints = extendedPlayer.getSkillPoints();
        if (skillPoints < this.increaseValue) {
            PacketDispatcher.sendTo(new SyncSpeedMessage(player), (EntityPlayerMP)player);
            System.out.println("Player " + player.getDisplayName() + " tried to increase speed by " + this.increaseValue + " but only has " + skillPoints + " skillpoints");
            return;
        }
        if (extendedPlayer.getSpeedPoints() + this.increaseValue > 500) {
            PacketDispatcher.sendTo(new SyncSpeedMessage(player), (EntityPlayerMP)player);
            System.out.println("Player " + player.getDisplayName() + " tried to increase speed over the limit of 200");
            return;
        }
        extendedPlayer.setSpeedPoints(extendedPlayer.getSpeedPoints() + this.increaseValue);
        extendedPlayer.setSkillPoints(extendedPlayer.getSkillPoints() - this.increaseValue);
    }
}

