/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Final;

import java.util.List;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.Final.JutsuItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ByakuganPalmRotation
extends JutsuItem {
    private static final double RADIUS = 3.0;
    private static final int DURATION_TICKS = 40;
    private static final float ROTATION_SPEED = 36.0f;

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (stack.field_77990_d != null && stack.field_77990_d.func_74767_n("rotationActive")) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Palm Rotation is already active!"));
                return stack;
            }
            if (this.handleClick(stack, player, world)) {
                if (stack.field_77990_d == null) {
                    this.initializeItem(stack, player);
                }
                stack.field_77990_d.func_74757_a("rotationActive", true);
                stack.field_77990_d.func_74768_a("rotationTicker", 0);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + "Byakugan: Eight Trigrams Palm Rotation!"));
            }
        }
        return stack;
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, world, entity, par4, par5);
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74767_n("rotationActive")) {
            return;
        }
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null || heldItem != itemStack) {
            itemStack.field_77990_d.func_74757_a("rotationActive", false);
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Palm Rotation interrupted!"));
            }
            return;
        }
        int rotationTicker = itemStack.field_77990_d.func_74762_e("rotationTicker");
        itemStack.field_77990_d.func_74768_a("rotationTicker", ++rotationTicker);
        if (world.field_72995_K) {
            this.rotatePlayerClientSide(player);
            this.spawnRotationParticles(world, player);
        } else {
            this.damageNearbyEntities(player, world, ExtendedPlayer.get(player), itemStack);
            this.destroyNearbyArrows(player, world);
            this.rotatePlayerServerSide(player);
        }
        if (rotationTicker >= 40) {
            itemStack.field_77990_d.func_74757_a("rotationActive", false);
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Eight Trigrams Palm Rotation completed!"));
            }
        }
    }

    private void rotatePlayerClientSide(EntityPlayer player) {
        player.field_70177_z += 36.0f;
        player.field_70759_as += 36.0f;
        player.field_70126_B += 36.0f;
        player.field_70758_at += 36.0f;
        if (player.field_70177_z >= 360.0f) {
            player.field_70177_z -= 360.0f;
            player.field_70126_B -= 360.0f;
        }
        if (player.field_70759_as >= 360.0f) {
            player.field_70759_as -= 360.0f;
            player.field_70758_at -= 360.0f;
        }
    }

    private void rotatePlayerServerSide(EntityPlayer player) {
        player.field_70177_z += 36.0f;
        player.field_70759_as += 36.0f;
        if (player.field_70177_z >= 360.0f) {
            player.field_70177_z -= 360.0f;
        }
        if (player.field_70759_as >= 360.0f) {
            player.field_70759_as -= 360.0f;
        }
    }

    private void damageNearbyEntities(EntityPlayer player, World world, ExtendedPlayer props, ItemStack stack) {
        List entitiesInRange = world.func_72872_a(EntityLivingBase.class, player.field_70121_D.func_72314_b(3.0, 3.0, 3.0));
        for (EntityLivingBase entity : entitiesInRange) {
            if (entity == player) continue;
            entity.field_70172_ad = 1;
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)this.getDamage(props, stack));
        }
    }

    private void destroyNearbyArrows(EntityPlayer player, World world) {
        List arrows = world.func_72872_a(EntityArrow.class, player.field_70121_D.func_72314_b(4.0, 4.0, 4.0));
        for (EntityArrow arrow : arrows) {
            world.func_72869_a("crit", arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, 0.0, 0.1, 0.0);
            world.func_72869_a("smoke", arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, 0.0, 0.0, 0.0);
            arrow.func_70106_y();
        }
    }

    private void spawnRotationParticles(World world, EntityPlayer player) {
        int rotationTicker = player.func_70694_bm().field_77990_d.func_74762_e("rotationTicker");
        double radius = 2.55;
        int ringsCount = 5;
        int particlesPerRing = 6;
        for (int ring = 0; ring < ringsCount; ++ring) {
            double phi = Math.PI * (double)ring / (double)(ringsCount - 1);
            double ringY = player.field_70163_u + 1.0 + radius * Math.cos(phi);
            double ringRadius = radius * Math.sin(phi);
            if (ringRadius < 0.1) continue;
            for (int p = 0; p < particlesPerRing; ++p) {
                double theta = Math.PI * 2 * (double)p / (double)particlesPerRing + (double)rotationTicker * 0.25;
                double particleX = player.field_70165_t + Math.cos(theta) * ringRadius;
                double particleZ = player.field_70161_v + Math.sin(theta) * ringRadius;
                if ((ring + p) % 2 == 0) {
                    world.func_72869_a("cloud", particleX, ringY, particleZ, 0.0, 0.0, 0.0);
                    continue;
                }
                world.func_72869_a("splash", particleX, ringY, particleZ, 0.0, 0.0, 0.0);
            }
        }
        for (int i = 0; i < 4; ++i) {
            double angle = (double)rotationTicker * 0.1 + (double)i * Math.PI / 2.0;
            double smallRadius = 0.8;
            double particleX = player.field_70165_t + Math.cos(angle) * smallRadius;
            double particleZ = player.field_70161_v + Math.sin(angle) * smallRadius;
            double particleY = player.field_70163_u + 1.0 + Math.sin((double)rotationTicker * 0.1 + (double)i) * 0.3;
            world.func_72869_a("snowballpoof", particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
    }
}

