/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Final;

import java.util.List;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.Final.JutsuItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ByakuganTwinLionFists
extends JutsuItem {
    private static final double TARGETING_RANGE = 5.0;
    private static final int DURATION_TICKS = 60;
    private static final int HIT_INTERVAL = 5;
    private static final double FOLLOW_DISTANCE = 1.0;

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (stack.field_77990_d != null && stack.field_77990_d.func_74767_n("comboActive")) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Twin Lion Fists is already active!"));
                return stack;
            }
            EntityLivingBase target = this.findTargetEntity(player, world);
            if (target == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "No target in range."));
                return stack;
            }
            if (this.handleClick(stack, player, world)) {
                if (stack.field_77990_d == null) {
                    this.initializeItem(stack, player);
                }
                stack.field_77990_d.func_74757_a("comboActive", true);
                stack.field_77990_d.func_74768_a("comboTicker", 0);
                stack.field_77990_d.func_74768_a("targetEntityId", target.func_145782_y());
                stack.field_77990_d.func_74768_a("hitCounter", 0);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.BLUE + "Byakugan: Twin Lion Fists!"));
            }
        }
        return stack;
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, world, entity, par4, par5);
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74767_n("comboActive")) {
            return;
        }
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null || heldItem != itemStack) {
            itemStack.field_77990_d.func_74757_a("comboActive", false);
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Twin Lion Fists interrupted!"));
            }
            return;
        }
        int comboTicker = itemStack.field_77990_d.func_74762_e("comboTicker");
        int targetId = itemStack.field_77990_d.func_74762_e("targetEntityId");
        int hitCounter = itemStack.field_77990_d.func_74762_e("hitCounter");
        EntityLivingBase target = null;
        if (!world.field_72995_K) {
            target = this.findEntityById(world, targetId);
            if (target == null) {
                itemStack.field_77990_d.func_74757_a("comboActive", false);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Target lost!"));
                return;
            }
            if (target.field_70128_L) {
                itemStack.field_77990_d.func_74757_a("comboActive", false);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Target eliminated!"));
                return;
            }
        }
        itemStack.field_77990_d.func_74768_a("comboTicker", ++comboTicker);
        if (world.field_72995_K) {
            EntityLivingBase clientTarget = this.findEntityById(world, targetId);
            if (clientTarget != null) {
                this.spawnComboParticles(world, player, clientTarget);
                if (comboTicker % 5 == 0) {
                    player.func_71038_i();
                }
            }
        } else if (target != null) {
            this.executeComboTick(player, world, target, itemStack, comboTicker, hitCounter);
        }
        if (comboTicker >= 60) {
            itemStack.field_77990_d.func_74757_a("comboActive", false);
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Twin Lion Fists completed! Total hits: " + hitCounter));
            }
        }
    }

    private void executeComboTick(EntityPlayer player, World world, EntityLivingBase target, ItemStack stack, int ticker, int hitCounter) {
        this.followTarget(player, target);
        if (ticker % 5 == 0) {
            this.executeHit(player, world, target, stack);
            stack.field_77990_d.func_74768_a("hitCounter", ++hitCounter);
        }
    }

    private void followTarget(EntityPlayer player, EntityLivingBase target) {
        double deltaX = target.field_70165_t - player.field_70165_t;
        double deltaY = target.field_70163_u - player.field_70163_u;
        double deltaZ = target.field_70161_v - player.field_70161_v;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        if (distance > 1.0) {
            double moveSpeed;
            deltaX /= distance;
            deltaY /= distance;
            deltaZ /= distance;
            if (distance > 4.0) {
                double newX = target.field_70165_t - deltaX * 1.0;
                double newY = target.field_70163_u - deltaY * 1.0;
                double newZ = target.field_70161_v - deltaZ * 1.0;
                player.func_70634_a(newX, newY, newZ);
                return;
            }
            if (distance > 2.0) {
                moveSpeed = 1.5;
            } else {
                double moveDistance = distance - 1.0;
                moveSpeed = Math.min(moveDistance * 0.4, 0.8);
            }
            player.field_70159_w = deltaX * moveSpeed;
            player.field_70181_x = deltaY * moveSpeed * 0.4;
            player.field_70179_y = deltaZ * moveSpeed;
        } else {
            player.field_70159_w *= 0.3;
            player.field_70181_x *= 0.3;
            player.field_70179_y *= 0.3;
        }
        double angle = Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI - 90.0;
        player.field_70177_z = (float)angle;
        player.field_70759_as = (float)angle;
    }

    private void executeHit(EntityPlayer player, World world, EntityLivingBase target, ItemStack stack) {
        EntityPlayer targetPlayer;
        ExtendedPlayer targetProps;
        ExtendedPlayer props = ExtendedPlayer.get(player);
        double prevMotionX = target.field_70159_w;
        double prevMotionZ = target.field_70179_y;
        target.field_70172_ad = 1;
        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)this.getDamage(props, stack));
        Vec3 direction = Vec3.func_72443_a((double)(target.field_70165_t - player.field_70165_t), (double)0.0, (double)(target.field_70161_v - player.field_70161_v)).func_72432_b();
        target.field_70159_w = direction.field_72450_a * 0.7;
        target.field_70181_x = 0.0;
        target.field_70179_y = direction.field_72449_c * 0.7;
        if (target instanceof EntityPlayer && (targetProps = ExtendedPlayer.get(targetPlayer = (EntityPlayer)target)) != null) {
            targetProps.consumeChakra(targetProps.getMaxChakra() / 200);
        }
        this.spawnHitParticles(world, target);
    }

    private void spawnHitParticles(World world, EntityLivingBase target) {
        for (int i = 0; i < 8; ++i) {
            double offsetX = (Math.random() - 0.5) * 1.0;
            double offsetY = Math.random() * (double)target.field_70131_O;
            double offsetZ = (Math.random() - 0.5) * 1.0;
            world.func_72869_a("splash", target.field_70165_t + offsetX, target.field_70163_u + offsetY, target.field_70161_v + offsetZ, 0.0, 0.1, 0.0);
        }
    }

    private void spawnComboParticles(World world, EntityPlayer player, EntityLivingBase target) {
        int i;
        double deltaX = target.field_70165_t - player.field_70165_t;
        double deltaY = target.field_70163_u + (double)(target.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e());
        double deltaZ = target.field_70161_v - player.field_70161_v;
        int particleCount = 3;
        for (i = 1; i <= particleCount; ++i) {
            double ratio = (double)i / (double)(particleCount + 1);
            double particleX = player.field_70165_t + deltaX * ratio;
            double particleY = player.field_70163_u + (double)player.func_70047_e() + deltaY * ratio;
            double particleZ = player.field_70161_v + deltaZ * ratio;
            world.func_72869_a("splash", particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 2; ++i) {
            double angle = (double)player.field_70177_z * Math.PI / 180.0 + (double)i * Math.PI;
            double fistX = player.field_70165_t + Math.cos(angle) * 0.8;
            double fistZ = player.field_70161_v + Math.sin(angle) * 0.8;
            double fistY = player.field_70163_u + (double)player.func_70047_e() - 0.3;
            world.func_72869_a("splash", fistX, fistY, fistZ, 0.0, 0.0, 0.0);
        }
    }

    private EntityLivingBase findTargetEntity(EntityPlayer player, World world) {
        Vec3 lookVector = player.func_70040_Z();
        Vec3 start = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 end = start.func_72441_c(lookVector.field_72450_a * 5.0, lookVector.field_72448_b * 5.0, lookVector.field_72449_c * 5.0);
        List entities = world.func_72839_b((Entity)player, player.field_70121_D.func_72314_b(5.0, 5.0, 5.0));
        EntityLivingBase closestTarget = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distance;
            Vec3 toEntity;
            double dot;
            if (!(entity instanceof EntityLivingBase) || entity == player || !((dot = lookVector.func_72430_b((toEntity = Vec3.func_72443_a((double)(entity.field_70165_t - player.field_70165_t), (double)(entity.field_70163_u - player.field_70163_u), (double)(entity.field_70161_v - player.field_70161_v))).func_72432_b())) > 0.7) || !((distance = (double)player.func_70032_d(entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestTarget = (EntityLivingBase)entity;
        }
        return closestTarget;
    }

    private EntityLivingBase findEntityById(World world, int entityId) {
        Entity entity = world.func_73045_a(entityId);
        return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
    }
}

