/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Final.CT;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class HomingLogic {
    private final EntityThrowable projectile;
    private final double searchRadius;
    private EntityLivingBase target;
    private boolean hasTarget;
    private int searchCooldown;

    public HomingLogic(EntityThrowable projectile, double searchRadius) {
        this.projectile = projectile;
        this.searchRadius = searchRadius;
        this.hasTarget = false;
        this.searchCooldown = 0;
    }

    public void updateHoming() {
        if (!this.hasTarget && this.searchCooldown % 5 == 0) {
            this.findTarget();
        }
        if (this.hasTarget && this.target != null && !this.target.field_70128_L) {
            this.adjustMotionToTarget();
        } else {
            this.hasTarget = false;
            this.projectile.field_70181_x = -0.1;
        }
        ++this.searchCooldown;
    }

    public boolean hasTarget() {
        return this.hasTarget && this.target != null && !this.target.field_70128_L;
    }

    private void findTarget() {
        World world = this.projectile.field_70170_p;
        List entities = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.projectile.field_70165_t - this.searchRadius), (double)(this.projectile.field_70163_u - this.searchRadius), (double)(this.projectile.field_70161_v - this.searchRadius), (double)(this.projectile.field_70165_t + this.searchRadius), (double)(this.projectile.field_70163_u + this.searchRadius), (double)(this.projectile.field_70161_v + this.searchRadius)));
        EntityLivingBase closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        for (EntityLivingBase entity : entities) {
            double distance;
            if (!this.canAttackEntity(entity) || !((distance = (double)this.projectile.func_70032_d((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        if (closestEntity != null) {
            this.target = closestEntity;
            this.hasTarget = true;
        } else {
            this.hasTarget = false;
        }
        this.searchCooldown = 0;
    }

    private void adjustMotionToTarget() {
        double dx = this.target.field_70165_t - this.projectile.field_70165_t;
        double dy = this.target.field_70163_u + (double)this.target.field_70131_O / 2.0 - this.projectile.field_70163_u;
        double dz = this.target.field_70161_v - this.projectile.field_70161_v;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.projectile.field_70159_w = dx / distance * 0.8;
        this.projectile.field_70181_x = dy / distance * 0.4;
        this.projectile.field_70179_y = dz / distance * 0.8;
    }

    private boolean canAttackEntity(EntityLivingBase entity) {
        return entity != null && entity.func_70089_S() && entity != this.projectile.func_85052_h();
    }
}

