/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Final.ClanJutsu;

import java.util.List;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.Final.JutsuItem;
import narutodestination.Mathioks.NickModels.UzumakiShinigamiEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class UzumakiReaperDeathSeal
extends JutsuItem {
    private static final int CHARGE_RATE = 2;

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity par3Entity, int par4, boolean par5) {
        boolean charging;
        super.func_77663_a(stack, world, par3Entity, par4, par5);
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)par3Entity;
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("charge", 0);
            stack.field_77990_d.func_74757_a("charging", false);
            stack.field_77990_d.func_74768_a("chargeTicks", 0);
        }
        if ((charging = stack.field_77990_d.func_74767_n("charging")) && player.func_70694_bm() == stack) {
            int chargeTicks = stack.field_77990_d.func_74762_e("chargeTicks");
            int currentCharge = stack.field_77990_d.func_74762_e("charge");
            if (++chargeTicks >= 2 && currentCharge < 100) {
                stack.field_77990_d.func_74768_a("charge", ++currentCharge);
                chargeTicks = 0;
                if (world.field_72995_K) {
                    int particleCount = Math.max(1, currentCharge / 10);
                    for (int i = 0; i < particleCount; ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)particleCount;
                        double x = player.field_70165_t + Math.cos(angle) * 2.0;
                        double z = player.field_70161_v + Math.sin(angle) * 2.0;
                        double y = player.field_70163_u + world.field_73012_v.nextDouble() * 2.0;
                        world.func_72869_a("portal", x, y, z, 0.0, 0.1, 0.0);
                    }
                }
                if (currentCharge == 25 || currentCharge == 50 || currentCharge == 75 || currentCharge == 100) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "Reaper Death Seal: " + currentCharge + "% charged"));
                }
            }
            stack.field_77990_d.func_74768_a("chargeTicks", chargeTicks);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ExtendedPlayer props = ExtendedPlayer.get(player);
        if (props.getKinjutsu() < 65) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need 65 Kinjutsu to use this"));
            return stack;
        }
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74757_a("charging", true);
        stack.field_77990_d.func_74768_a("charge", 0);
        stack.field_77990_d.func_74768_a("chargeTicks", 0);
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "Forbidden Jutsu: Reaper Death Seal - Charging..."));
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int itemInUseCount) {
        if (stack.field_77990_d == null) {
            return;
        }
        boolean charging = stack.field_77990_d.func_74767_n("charging");
        if (!charging) {
            return;
        }
        int charge = stack.field_77990_d.func_74762_e("charge");
        if (charge <= 0) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Reaper Death Seal cancelled - no charge"));
            stack.field_77990_d.func_74757_a("charging", false);
            return;
        }
        EntityPlayer target = this.findNearestPlayer(player, world, 20.0);
        if (target == null) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "No target found within range!"));
            stack.field_77990_d.func_74757_a("charging", false);
            stack.field_77990_d.func_74768_a("charge", 0);
            return;
        }
        UzumakiShinigamiEntity shinigami = new UzumakiShinigamiEntity(world, charge);
        shinigami.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        shinigami.func_152115_b(player.func_110124_au().toString());
        shinigami.func_70903_f(true);
        shinigami.setTarget(target);
        world.func_72838_d((Entity)shinigami);
        float chargePercent = (float)charge / 100.0f;
        float newHealth = charge >= 100 ? 1.0f : player.func_110143_aJ() * (1.0f - chargePercent);
        player.func_70606_j(Math.max(1.0f, newHealth));
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "Reaper Death Seal released at " + charge + "% power!"));
        stack.field_77990_d.func_74757_a("charging", false);
        stack.field_77990_d.func_74768_a("charge", 0);
    }

    private EntityPlayer findNearestPlayer(EntityPlayer user, World world, double range) {
        List entities = world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(user.field_70165_t - range), (double)(user.field_70163_u - range / 2.0), (double)(user.field_70161_v - range), (double)(user.field_70165_t + range), (double)(user.field_70163_u + range / 2.0), (double)(user.field_70161_v + range)));
        EntityPlayer nearest = null;
        double nearestDist = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double dist;
            if (!(entity instanceof EntityPlayer) || entity == user || !((dist = entity.func_70068_e((Entity)user)) < nearestDist)) continue;
            nearestDist = dist;
            nearest = (EntityPlayer)entity;
        }
        return nearest;
    }
}

