/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Final;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import narutodestination.Mathioks.Config.GeneralConfig;
import narutodestination.Mathioks.CreativeTabLoader;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ModeMultiplierHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.input.Keyboard;

public class JutsuItem
extends Item {
    private long lastConfigReload = 0L;
    protected double ninScaling;
    protected double taiScaling;
    protected double genScaling;
    protected double kenScaling;
    protected double shurikenScaling;
    protected double summonScaling;
    protected double kinScaling;
    protected double senScaling;
    protected double medScaling;
    protected double baseDamage;
    protected int chakraBaseCost;
    protected double chakraCostScaling;
    protected int senBaseCost;
    protected double senCostScaling;
    protected String description;
    protected String style;
    protected int cooldown;
    protected String requiredRelease;
    public boolean enableMastery;
    protected int receivedXPPerUse;
    public int convertedXP;
    public int convertedJP;
    protected int cloneLifetime;
    protected int effectDuration;
    protected int healAmount;
    protected boolean jutsuBanned;
    protected double damageCap;
    private static boolean hasAddedConfigExplanation = false;
    public static Configuration configuration;

    public JutsuItem() {
        this.field_77777_bU = 1;
        this.func_77656_e(20000);
        this.func_77637_a(CreativeTabLoader.tabJutsu);
    }

    public void loadData() {
        if (this.excludeFromConfig()) {
            return;
        }
        if (!hasAddedConfigExplanation) {
            this.addConfigurationExplanation();
            hasAddedConfigExplanation = true;
        }
        String CONFIG_NAME = ((Object)((Object)this)).getClass().getSimpleName().toLowerCase();
        this.requiredRelease = configuration.get(CONFIG_NAME, "A RequiredReleases", "").getString();
        if (this.pureDebuffJutsu()) {
            this.cooldown = configuration.get(CONFIG_NAME, "B Cooldown", "600").getInt();
            this.style = configuration.get(CONFIG_NAME, "C Style", "Debuff").getString();
            this.description = configuration.get(CONFIG_NAME, "D Description", "").getString();
            this.effectDuration = configuration.get(CONFIG_NAME, "E EffectDuration", 80).getInt();
            this.ninScaling = configuration.get(CONFIG_NAME, "F NinScaling", 0.0).getDouble();
            this.taiScaling = configuration.get(CONFIG_NAME, "G TaiScaling", 0.0).getDouble();
            this.genScaling = configuration.get(CONFIG_NAME, "H GenScaling", 0.03).getDouble();
            this.kenScaling = configuration.get(CONFIG_NAME, "I KenScaling", 0.0).getDouble();
            this.shurikenScaling = configuration.get(CONFIG_NAME, "J ShurikenScaling", 0.0).getDouble();
            this.summonScaling = configuration.get(CONFIG_NAME, "K SummonScaling", 0.0).getDouble();
            this.kinScaling = configuration.get(CONFIG_NAME, "L KinScaling", 0.0).getDouble();
            this.senScaling = configuration.get(CONFIG_NAME, "M SenScaling", 0.0).getDouble();
            this.medScaling = configuration.get(CONFIG_NAME, "N MedScaling", 0.0).getDouble();
            this.chakraBaseCost = configuration.get(CONFIG_NAME, "O ChakraBaseCost", 50).getInt();
            this.chakraCostScaling = configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.03).getDouble();
            this.senBaseCost = configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).getInt();
            this.senCostScaling = configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).getDouble();
            ConfigCategory removedCategory = configuration.getCategory(CONFIG_NAME);
            configuration.removeCategory(removedCategory);
            configuration.get(CONFIG_NAME, "A RequiredReleases", "").set(this.requiredRelease);
            configuration.get(CONFIG_NAME, "B Cooldown", 600).set(this.cooldown);
            configuration.get(CONFIG_NAME, "C Style", "Debuff").set(this.style);
            configuration.get(CONFIG_NAME, "D Description", "").set(this.description);
            configuration.get(CONFIG_NAME, "E EffectDuration", 80).set(this.effectDuration);
            configuration.get(CONFIG_NAME, "F NinScaling", 0.0).set(this.ninScaling);
            configuration.get(CONFIG_NAME, "G TaiScaling", 0.0).set(this.taiScaling);
            configuration.get(CONFIG_NAME, "H GenScaling", 0.03).set(this.genScaling);
            configuration.get(CONFIG_NAME, "I KenScaling", 0.0).set(this.kenScaling);
            configuration.get(CONFIG_NAME, "J ShurikenScaling", 0.0).set(this.shurikenScaling);
            configuration.get(CONFIG_NAME, "K SummonScaling", 0.0).set(this.summonScaling);
            configuration.get(CONFIG_NAME, "L KinScaling", 0.0).set(this.kinScaling);
            configuration.get(CONFIG_NAME, "M SenScaling", 0.0).set(this.senScaling);
            configuration.get(CONFIG_NAME, "N MedScaling", 0.0).set(this.medScaling);
            configuration.get(CONFIG_NAME, "O ChakraBaseCost", 50).set(this.chakraBaseCost);
            configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.03).set(this.chakraCostScaling);
            configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).set(this.senBaseCost);
            configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).set(this.senCostScaling);
        } else if (this.modeJutsu()) {
            this.style = configuration.get(CONFIG_NAME, "C Style", "Buff").getString();
            this.description = configuration.get(CONFIG_NAME, "D Description", "").getString();
            this.chakraBaseCost = configuration.get(CONFIG_NAME, "O ChakraBaseCost", 1).getInt();
            this.chakraCostScaling = configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.001).getDouble();
            this.senBaseCost = configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).getInt();
            this.senCostScaling = configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).getDouble();
            ConfigCategory removedCategory = configuration.getCategory(CONFIG_NAME);
            configuration.removeCategory(removedCategory);
            configuration.get(CONFIG_NAME, "A RequiredReleases", "").set(this.requiredRelease);
            configuration.get(CONFIG_NAME, "C Style", "Buff").set(this.style);
            configuration.get(CONFIG_NAME, "D Description", "").set(this.description);
            configuration.get(CONFIG_NAME, "O ChakraBaseCost", 1).set(this.chakraBaseCost);
            configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.001).set(this.chakraCostScaling);
            configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).set(this.senBaseCost);
            configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).set(this.senCostScaling);
        } else if (this.healJutsu()) {
            this.cooldown = configuration.get(CONFIG_NAME, "B Cooldown", "600").getInt();
            this.style = configuration.get(CONFIG_NAME, "C Style", "Heal").getString();
            this.description = configuration.get(CONFIG_NAME, "D Description", "").getString();
            this.healAmount = configuration.get(CONFIG_NAME, "E HealAmount", 5).getInt();
            this.ninScaling = configuration.get(CONFIG_NAME, "F NinScaling", 0.0).getDouble();
            this.taiScaling = configuration.get(CONFIG_NAME, "G TaiScaling", 0.0).getDouble();
            this.genScaling = configuration.get(CONFIG_NAME, "H GenScaling", 0.0).getDouble();
            this.kenScaling = configuration.get(CONFIG_NAME, "I KenScaling", 0.0).getDouble();
            this.shurikenScaling = configuration.get(CONFIG_NAME, "J ShurikenScaling", 0.0).getDouble();
            this.summonScaling = configuration.get(CONFIG_NAME, "K SummonScaling", 0.0).getDouble();
            this.kinScaling = configuration.get(CONFIG_NAME, "L KinScaling", 0.0).getDouble();
            this.senScaling = configuration.get(CONFIG_NAME, "M SenScaling", 0.0).getDouble();
            this.medScaling = configuration.get(CONFIG_NAME, "N MedScaling", 0.06).getDouble();
            this.chakraBaseCost = configuration.get(CONFIG_NAME, "O ChakraBaseCost", 50).getInt();
            this.chakraCostScaling = configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.05).getDouble();
            this.senBaseCost = configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).getInt();
            this.senCostScaling = configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).getDouble();
            ConfigCategory removedCategory = configuration.getCategory(CONFIG_NAME);
            configuration.removeCategory(removedCategory);
            configuration.get(CONFIG_NAME, "A RequiredReleases", "").set(this.requiredRelease);
            configuration.get(CONFIG_NAME, "B Cooldown", 600).set(this.cooldown);
            configuration.get(CONFIG_NAME, "C Style", "Heal").set(this.style);
            configuration.get(CONFIG_NAME, "D Description", "").set(this.description);
            configuration.get(CONFIG_NAME, "E HealAmount", 3).set(this.healAmount);
            configuration.get(CONFIG_NAME, "F NinScaling", 0.0).set(this.ninScaling);
            configuration.get(CONFIG_NAME, "G TaiScaling", 0.0).set(this.taiScaling);
            configuration.get(CONFIG_NAME, "H GenScaling", 0.0).set(this.genScaling);
            configuration.get(CONFIG_NAME, "I KenScaling", 0.0).set(this.kenScaling);
            configuration.get(CONFIG_NAME, "J ShurikenScaling", 0.0).set(this.shurikenScaling);
            configuration.get(CONFIG_NAME, "K SummonScaling", 0.0).set(this.summonScaling);
            configuration.get(CONFIG_NAME, "L KinScaling", 0.0).set(this.kinScaling);
            configuration.get(CONFIG_NAME, "M SenScaling", 0.0).set(this.senScaling);
            configuration.get(CONFIG_NAME, "N MedScaling", 0.03).set(this.medScaling);
            configuration.get(CONFIG_NAME, "O ChakraBaseCost", 50).set(this.chakraBaseCost);
            configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.05).set(this.chakraCostScaling);
            configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).set(this.senBaseCost);
            configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).set(this.senCostScaling);
        } else if (this.summonJutsu()) {
            this.cooldown = configuration.get(CONFIG_NAME, "B Cooldown", "1200").getInt();
            this.style = configuration.get(CONFIG_NAME, "C Style", "Summon").getString();
            this.description = configuration.get(CONFIG_NAME, "D Description", "").getString();
            this.baseDamage = configuration.get(CONFIG_NAME, "E BaseDamage", 30.0).getDouble();
            this.ninScaling = configuration.get(CONFIG_NAME, "F NinScaling", 0.0).getDouble();
            this.taiScaling = configuration.get(CONFIG_NAME, "G TaiScaling", 0.0).getDouble();
            this.genScaling = configuration.get(CONFIG_NAME, "H GenScaling", 0.0).getDouble();
            this.kenScaling = configuration.get(CONFIG_NAME, "I KenScaling", 0.0).getDouble();
            this.shurikenScaling = configuration.get(CONFIG_NAME, "J ShurikenScaling", 0.0).getDouble();
            this.summonScaling = configuration.get(CONFIG_NAME, "K SummonScaling", 0.045).getDouble();
            this.kinScaling = configuration.get(CONFIG_NAME, "L KinScaling", 0.0).getDouble();
            this.senScaling = configuration.get(CONFIG_NAME, "M SenScaling", 0.0).getDouble();
            this.medScaling = configuration.get(CONFIG_NAME, "N MedScaling", 0.0).getDouble();
            this.chakraBaseCost = configuration.get(CONFIG_NAME, "O ChakraBaseCost", 100).getInt();
            this.chakraCostScaling = configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.08).getDouble();
            this.senBaseCost = configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).getInt();
            this.senCostScaling = configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).getDouble();
            this.enableMastery = configuration.get(CONFIG_NAME, "S EnableMastery", true).getBoolean(true);
            this.receivedXPPerUse = configuration.get(CONFIG_NAME, "T XPPerUse", 1).getInt();
            this.convertedXP = configuration.get(CONFIG_NAME, "U XP Per Convert", 1).getInt();
            this.convertedJP = configuration.get(CONFIG_NAME, "V JP Per Convert", 1).getInt();
            this.cloneLifetime = configuration.get(CONFIG_NAME, "W CloneLifetime", 1200).getInt();
            this.damageCap = configuration.get(CONFIG_NAME, "X DamageCap", -1.0).getDouble();
            ConfigCategory removedCategory = configuration.getCategory(CONFIG_NAME);
            configuration.removeCategory(removedCategory);
            configuration.get(CONFIG_NAME, "A RequiredReleases", "").set(this.requiredRelease);
            configuration.get(CONFIG_NAME, "B Cooldown", 1200).set(this.cooldown);
            configuration.get(CONFIG_NAME, "C Style", "Summon").set(this.style);
            configuration.get(CONFIG_NAME, "D Description", "").set(this.description);
            configuration.get(CONFIG_NAME, "E BaseDamage", 30.0).set(this.baseDamage);
            configuration.get(CONFIG_NAME, "F NinScaling", 0.0).set(this.ninScaling);
            configuration.get(CONFIG_NAME, "G TaiScaling", 0.0).set(this.taiScaling);
            configuration.get(CONFIG_NAME, "H GenScaling", 0.0).set(this.genScaling);
            configuration.get(CONFIG_NAME, "I KenScaling", 0.0).set(this.kenScaling);
            configuration.get(CONFIG_NAME, "J ShurikenScaling", 0.0).set(this.shurikenScaling);
            configuration.get(CONFIG_NAME, "K SummonScaling", 0.045).set(this.summonScaling);
            configuration.get(CONFIG_NAME, "L KinScaling", 0.0).set(this.kinScaling);
            configuration.get(CONFIG_NAME, "M SenScaling", 0.0).set(this.senScaling);
            configuration.get(CONFIG_NAME, "N MedScaling", 0.0).set(this.medScaling);
            configuration.get(CONFIG_NAME, "O ChakraBaseCost", 100).set(this.chakraBaseCost);
            configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.08).set(this.chakraCostScaling);
            configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).set(this.senBaseCost);
            configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).set(this.senCostScaling);
            configuration.get(CONFIG_NAME, "S EnableMastery", true).set(this.enableMastery);
            configuration.get(CONFIG_NAME, "T XPPerUse", 1).set(this.receivedXPPerUse);
            configuration.get(CONFIG_NAME, "U XP Per Convert", 1).set(this.convertedXP);
            configuration.get(CONFIG_NAME, "V JP Per Convert", 1).set(this.convertedJP);
            configuration.get(CONFIG_NAME, "W CloneLifetime", 1200).set(this.cloneLifetime);
            configuration.get(CONFIG_NAME, "X DamageCap", -1.0).set(this.damageCap);
        } else if (this.utilityJutsu()) {
            this.cooldown = configuration.get(CONFIG_NAME, "B Cooldown", "10").getInt();
            this.style = configuration.get(CONFIG_NAME, "C Style", "").getString();
            this.description = configuration.get(CONFIG_NAME, "D Description", "").getString();
            this.chakraBaseCost = configuration.get(CONFIG_NAME, "O ChakraBaseCost", 10).getInt();
            this.chakraCostScaling = configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.03).getDouble();
            this.senBaseCost = configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).getInt();
            this.senCostScaling = configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).getDouble();
            ConfigCategory removedCategory = configuration.getCategory(CONFIG_NAME);
            configuration.removeCategory(removedCategory);
            configuration.get(CONFIG_NAME, "A RequiredReleases", "").set(this.requiredRelease);
            configuration.get(CONFIG_NAME, "B Cooldown", 10).set(this.cooldown);
            configuration.get(CONFIG_NAME, "C Style", "").set(this.style);
            configuration.get(CONFIG_NAME, "D Description", "").set(this.description);
            configuration.get(CONFIG_NAME, "O ChakraBaseCost", 10).set(this.chakraBaseCost);
            configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.03).set(this.chakraCostScaling);
            configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).set(this.senBaseCost);
            configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).set(this.senCostScaling);
        } else {
            this.cooldown = configuration.get(CONFIG_NAME, "B Cooldown", "20").getInt();
            this.style = configuration.get(CONFIG_NAME, "C Style", "").getString();
            this.description = configuration.get(CONFIG_NAME, "D Description", "").getString();
            this.baseDamage = configuration.get(CONFIG_NAME, "E BaseDamage", 10.0).getDouble();
            this.ninScaling = configuration.get(CONFIG_NAME, "F NinScaling", 0.025).getDouble();
            this.taiScaling = configuration.get(CONFIG_NAME, "G TaiScaling", 0.02).getDouble();
            this.genScaling = configuration.get(CONFIG_NAME, "H GenScaling", 0.02).getDouble();
            this.kenScaling = configuration.get(CONFIG_NAME, "I KenScaling", 0.02).getDouble();
            this.shurikenScaling = configuration.get(CONFIG_NAME, "J ShurikenScaling", 0.02).getDouble();
            this.summonScaling = configuration.get(CONFIG_NAME, "K SummonScaling", 0.02).getDouble();
            this.kinScaling = configuration.get(CONFIG_NAME, "L KinScaling", 0.02).getDouble();
            this.senScaling = configuration.get(CONFIG_NAME, "M SenScaling", 0.02).getDouble();
            this.medScaling = configuration.get(CONFIG_NAME, "N MedScaling", 0.02).getDouble();
            this.chakraBaseCost = configuration.get(CONFIG_NAME, "O ChakraBaseCost", 20).getInt();
            this.chakraCostScaling = configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.03).getDouble();
            this.senBaseCost = configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).getInt();
            this.senCostScaling = configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).getDouble();
            this.enableMastery = configuration.get(CONFIG_NAME, "S EnableMastery", true).getBoolean(true);
            this.receivedXPPerUse = configuration.get(CONFIG_NAME, "T XPPerUse", 1).getInt();
            this.convertedXP = configuration.get(CONFIG_NAME, "U XP Per Convert", 1).getInt();
            this.convertedJP = configuration.get(CONFIG_NAME, "V JP Per Convert", 1).getInt();
            this.damageCap = configuration.get(CONFIG_NAME, "W DamageCap", -1.0).getDouble();
            ConfigCategory removedCategory = configuration.getCategory(CONFIG_NAME);
            configuration.removeCategory(removedCategory);
            configuration.get(CONFIG_NAME, "A RequiredReleases", "").set(this.requiredRelease);
            configuration.get(CONFIG_NAME, "B Cooldown", 20).set(this.cooldown);
            configuration.get(CONFIG_NAME, "C Style", "").set(this.style);
            configuration.get(CONFIG_NAME, "D Description", "").set(this.description);
            configuration.get(CONFIG_NAME, "E BaseDamage", 10.0).set(this.baseDamage);
            configuration.get(CONFIG_NAME, "F NinScaling", 0.025).set(this.ninScaling);
            configuration.get(CONFIG_NAME, "G TaiScaling", 0.02).set(this.taiScaling);
            configuration.get(CONFIG_NAME, "H GenScaling", 0.02).set(this.genScaling);
            configuration.get(CONFIG_NAME, "I KenScaling", 0.02).set(this.kenScaling);
            configuration.get(CONFIG_NAME, "J ShurikenScaling", 0.02).set(this.shurikenScaling);
            configuration.get(CONFIG_NAME, "K SummonScaling", 0.02).set(this.summonScaling);
            configuration.get(CONFIG_NAME, "L KinScaling", 0.02).set(this.kinScaling);
            configuration.get(CONFIG_NAME, "M SenScaling", 0.02).set(this.senScaling);
            configuration.get(CONFIG_NAME, "N MedScaling", 0.02).set(this.medScaling);
            configuration.get(CONFIG_NAME, "O ChakraBaseCost", 20).set(this.chakraBaseCost);
            configuration.get(CONFIG_NAME, "P ChakraCostScaling", 0.03).set(this.chakraCostScaling);
            configuration.get(CONFIG_NAME, "Q SenBaseCost", 0).set(this.senBaseCost);
            configuration.get(CONFIG_NAME, "R SenCostScaling", 0.0).set(this.senCostScaling);
            configuration.get(CONFIG_NAME, "S EnableMastery", true).set(this.enableMastery);
            configuration.get(CONFIG_NAME, "T XPPerUse", 1).set(this.receivedXPPerUse);
            configuration.get(CONFIG_NAME, "U XP Per Convert", 1).set(this.convertedXP);
            configuration.get(CONFIG_NAME, "V JP Per Convert", 1).set(this.convertedJP);
            configuration.get(CONFIG_NAME, "W DamageCap", -1.0).set(this.damageCap);
        }
        this.jutsuBanned = configuration.get(CONFIG_NAME, "Z JutsuBanned", false).getBoolean(false);
        JutsuItem.configuration.get((String)CONFIG_NAME, (String)"A RequiredReleases", (String)"").comment = LanguageRegistry.instance().getStringLocalization(this.func_77658_a() + ".name");
        if (configuration.hasChanged()) {
            configuration.save();
        }
        this.lastConfigReload = System.currentTimeMillis();
    }

    private void addConfigurationExplanation() {
        configuration.addCustomCategoryComment("AAA Explanation", "# Naruto Destination - Jutsu Configuration\n# ======================================================================================\n# HOW TO USE THIS CONFIG FILE\n# ======================================================================================\n# This configuration file controls the properties and behavior of all jutsus in the mod.\n# Each jutsu is defined in its own section with various parameters that affect its\n# performance, requirements, and scaling values.\n#\n# GENERAL FORMAT:\n# Each jutsu follows this pattern:\n#   jutsuname {\n#       # Jutsu Display Name\n#       S:\"A RequiredReleases\"=Release Type\n#       I:\"B Cooldown\"=Value\n#       S:\"C Style\"=Style Type\n#       S:\"D Description\"=Description text\n#       ... other parameters ...\n#       B:\"Z JutsuBanned\"=false\n#   }\n#\n# PARAMETER EXPLANATIONS\n# ======================================================================================\n#\n# BASIC PARAMETERS:\n# -----------------\n# \"RequiredReleases\" - Chakra nature(s) needed to use this jutsu\n#   Format: Single release (e.g. \"Fire\"), OR relationship (\"Fire-Water\" means Fire OR Water),\n#           AND relationship (\"Fire+Earth\" means both Fire AND Earth required)\n# \n# \"Cooldown\" - Time in ticks before jutsu can be used again (20 ticks = 1 second)\n# \n# \"Style\" - Combat style category (e.g. \"Ranged\", \"Buff\", \"Debuff\", \"Summon\", \"Trap\", etc.) this is entirely optional and visual\n# \n# \"Description\" - Short description of what the jutsu does\n#\n# DAMAGE PARAMETERS:\n# -----------------\n# \"BaseDamage\" - Base damage value before any scaling (higher = stronger)\n# \n# \"DamageCap\" - Maximum possible damage this jutsu can deal (-1 = no limit)\n#\n# SCALING PARAMETERS:\n# -----------------\n# Scaling values determine how much a jutsu's power increases per point in a specific stat.\n# 0.1 NinScaling means that this jutsu\u00b4s damage increases by 0.1 per Skillpoint invested into Ninjutsu.\n#\n# \"NinScaling\" - How much jutsu scales with Ninjutsu skill\n# \"TaiScaling\" - How much jutsu scales with Taijutsu skill\n# \"GenScaling\" - How much jutsu scales with Genjutsu skill\n# \"KenScaling\" - How much jutsu scales with Kenjutsu skill\n# \"ShurikenScaling\" - How much jutsu scales with Shurikenjutsu skill\n# \"SummonScaling\" - How much jutsu scales with Summoning skill\n# \"KinScaling\" - How much jutsu scales with Kinjutsu skill\n# \"SenScaling\" - How much jutsu scales with Senjutsu skill\n# \"MedScaling\" - How much jutsu scales with Medical skill\n#\n# CHAKRA COST PARAMETERS:\n# -----------------\n# \"ChakraBaseCost\" - Minimum chakra required to use the jutsu\n# \"ChakraCostScaling\" - How much additional chakra cost scales with player's max chakra\n# \"SenBaseCost\" - Minimum senjutsu chakra required to use the jutsu\n# \"SenCostScaling\" - How much additional senjutsu cost scales with player's max senjutsu\n#\n# MASTERY PARAMETERS:\n# -----------------\n# \"EnableMastery\" - Whether this jutsu can level up with use (true/false)\n# \"XPPerUse\" - XP gained each time the jutsu is used\n# \"XP Per Convert\" - XP gained per JutsuPoint for mastery level conversions\n# \"JP Per Convert\" - Jutsu Points used per conversion\n#\n# ADDITIONAL PARAMETERS:\n# -----------------\n# For healing jutsus:\n# \"HealAmount\" - Base amount of health restored\n#\n# For summon jutsus:\n# \"CloneLifetime\" - Duration in ticks the summon will remain (20 ticks = 1 second)\n#\n# For debuff jutsus:\n# \"EffectDuration\" - Duration in ticks the debuff will last (20 ticks = 1 second)\n#\n# RESTRICTIONS:\n# -----------------\n# \"JutsuBanned\" - If true, jutsu cannot be used on the server\n#\n# BALANCING RECOMMENDATIONS\n# ======================================================================================\n# - Basic jutsu: BaseDamage 5-15, Scaling 0.01-0.02, ChakraCost 50-150\n# - Advanced jutsu: BaseDamage 15-35, Scaling 0.02-0.04, ChakraCost 150-250\n# - Kekkei Genkai/Elite jutsu: BaseDamage 35-50, Scaling 0.04-0.06, ChakraCost 250-350\n#\n# For optimal balance between different nature types:\n# - Fire: Higher base damage but longer cooldowns\n# - Wind: Medium damage with good scaling and medium cooldowns\n# - Lightning: Fast cooldowns with lower base damage but good scaling\n# - Earth: Lower damage but higher defensive properties\n# - Water: Balanced mix of damage and utility effects\n#\n# SCALING EXAMPLES\n# ======================================================================================\n# - Fire jutsus: High NinScaling, low-medium GenScaling\n# - Water jutsus: Medium NinScaling, medium GenScaling\n# - Wind jutsus: Medium NinScaling, medium ShurikenScaling\n# - Earth jutsus: Low-medium NinScaling, high TaiScaling\n# - Lightning jutsus: High NinScaling, medium KenScaling\n# - Wood jutsus: Medium NinScaling, high GenScaling, medium SummonScaling\n# - Healing jutsus: High MedScaling\n# - Summon jutsus: High SummonScaling\n# - Physical attack jutsus: High TaiScaling\n# - Weapon enhancement jutsus: High KenScaling\n#\n# ======================================================================================");
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (this.isJutsuBanned()) {
            itemStack.field_77990_d = null;
            return;
        }
        if (entity instanceof EntityPlayer) {
            int currentXP;
            int xpForNextLevel;
            int cooldown;
            EntityPlayer player = (EntityPlayer)entity;
            if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("OwnerUUID")) {
                this.initializeItem(itemStack, player);
                if (!world.field_72995_K) {
                    this.writeToNBT(itemStack.field_77990_d);
                    itemStack.field_77990_d.func_74772_a("lastConfigReload", this.lastConfigReload);
                }
            } else if (!world.field_72995_K && itemStack.field_77990_d.func_74763_f("lastConfigReload") < this.lastConfigReload) {
                this.writeToNBT(itemStack.field_77990_d);
                itemStack.field_77990_d.func_74772_a("lastConfigReload", this.lastConfigReload);
            }
            if (itemStack.field_77990_d.func_74764_b("cooldown") && (cooldown = itemStack.field_77990_d.func_74762_e("cooldown")) > 0) {
                itemStack.field_77990_d.func_74768_a("cooldown", --cooldown);
            }
            int currentLevel = itemStack.field_77990_d.func_74762_e("JutsuLevel");
            for (currentXP = itemStack.field_77990_d.func_74762_e("JutsuXP"); currentLevel < 100 && currentXP >= (xpForNextLevel = this.getXpForNextLevel(currentLevel)); currentXP -= xpForNextLevel) {
                itemStack.field_77990_d.func_74768_a("JutsuLevel", ++currentLevel);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Jutsu leveled up to " + currentLevel + "!"));
            }
            itemStack.field_77990_d.func_74768_a("JutsuXP", currentXP);
        }
    }

    protected void initializeItem(ItemStack stack, EntityPlayer player) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.field_77990_d.func_74764_b("JutsuXP")) {
            stack.field_77990_d.func_74768_a("JutsuXP", 0);
            stack.field_77990_d.func_74768_a("JutsuLevel", 1);
        }
        if (!stack.field_77990_d.func_74764_b("OwnerUUID")) {
            stack.field_77990_d.func_74778_a("OwnerUUID", player.func_110124_au().toString());
        }
    }

    public int getChakraRequirement(ExtendedPlayer props) {
        if (this.chakraBaseCost > 0 || this.chakraCostScaling > 0.0) {
            return (int)Math.ceil((double)this.chakraBaseCost + (double)props.getMaxChakra() * this.chakraCostScaling);
        }
        return 0;
    }

    public int getSenjutsuChakraRequirement(ExtendedPlayer props) {
        if (this.senBaseCost > 0 || this.senCostScaling > 0.0) {
            return (int)Math.ceil((double)this.senBaseCost + (double)props.getMaxSenChakra() * this.senCostScaling);
        }
        return 0;
    }

    public double getDamage(ExtendedPlayer props) {
        return this.getDamage(props, null);
    }

    public double getDamage(ExtendedPlayer props, ItemStack stack) {
        int jutsuLevel = 0;
        if (stack != null) {
            jutsuLevel = this.getJutsuLevel(stack);
        }
        double baseDamageTotal = this.baseDamage + (double)props.getNinjutsu() * this.ninScaling + (double)props.getTaijutsu() * this.taiScaling + (double)props.getGenjutsu() * this.genScaling + (double)props.getKenjutsu() * this.kenScaling + (double)props.getShurikenJutsu() * this.shurikenScaling + (double)props.getSummoning() * this.summonScaling + (double)props.getKinjutsu() * this.kinScaling + (double)props.getSenjutsu() * this.senScaling + (double)props.getMedical() * this.medScaling;
        double damageBonus = 1.0 + (double)jutsuLevel * 0.005;
        double modeDamageMultiplier = ModeMultiplierHandler.getModeMultiplier(props);
        double finalDamage = baseDamageTotal * damageBonus * modeDamageMultiplier;
        if (this.damageCap > 0.0 && finalDamage > this.damageCap) {
            return this.damageCap;
        }
        return finalDamage;
    }

    public double getHealing(ExtendedPlayer props) {
        return this.getHealing(props, null);
    }

    public double getHealing(ExtendedPlayer props, ItemStack stack) {
        int jutsuLevel = 1;
        if (stack != null) {
            jutsuLevel = this.getJutsuLevel(stack);
        }
        double baseHealAmount = (double)this.healAmount + (double)props.getNinjutsu() * this.ninScaling + (double)props.getTaijutsu() * this.taiScaling + (double)props.getGenjutsu() * this.genScaling + (double)props.getKenjutsu() * this.kenScaling + (double)props.getShurikenJutsu() * this.shurikenScaling + (double)props.getSummoning() * this.summonScaling + (double)props.getKinjutsu() * this.kinScaling + (double)props.getSenjutsu() * this.senScaling + (double)props.getMedical() * this.medScaling;
        double levelHealBonus = 1.0 + (double)jutsuLevel * 0.005;
        return baseHealAmount * levelHealBonus;
    }

    public void addJutsuXP(ItemStack itemStack, EntityPlayer player) {
        if (!this.enableMastery || !this.isOwner(itemStack, player)) {
            return;
        }
        int currentLevel = itemStack.field_77990_d.func_74762_e("JutsuLevel");
        if (currentLevel >= 100) {
            return;
        }
        int currentXP = itemStack.field_77990_d.func_74762_e("JutsuXP");
        int xpForNextLevel = this.getXpForNextLevel(currentLevel);
        if ((currentXP += this.receivedXPPerUse) >= xpForNextLevel) {
            currentXP -= xpForNextLevel;
            itemStack.field_77990_d.func_74768_a("JutsuLevel", ++currentLevel);
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Jutsu leveled up to " + currentLevel + "!"));
        }
        itemStack.field_77990_d.func_74768_a("JutsuXP", currentXP);
    }

    private int getXpForNextLevel(int currentLevel) {
        return (int)(100.0 * Math.pow(1.05, currentLevel - 1));
    }

    public int getJutsuLevel(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return stack.field_77990_d.func_74762_e("JutsuLevel");
        }
        return 1;
    }

    public boolean isOwner(ItemStack stack, EntityPlayer player) {
        if (stack.field_77990_d != null) {
            String ownerUUID = stack.field_77990_d.func_74779_i("OwnerUUID");
            return ownerUUID.equals(player.func_110124_au().toString());
        }
        return player.field_71075_bZ.field_75098_d;
    }

    public final boolean handleClick(ItemStack stack, EntityPlayer player, World world) {
        boolean hasSenChakra;
        if (world.field_72995_K) {
            return false;
        }
        if (!GeneralConfig.allowJutsusDuringChakraCharge) {
            this.sendMessage(player, "You cannot use jutsus while charging chakra.");
            return false;
        }
        if (this.isJutsuBanned()) {
            this.sendMessage(player, "This Jutsu is banned and cannot be used.");
            return false;
        }
        if (!this.isOwner(stack, player)) {
            if (!world.field_72995_K) {
                this.sendMessage(player, "You are not the owner of this item");
            }
            return false;
        }
        ExtendedPlayer props = ExtendedPlayer.get(player);
        if (!this.checkRequiredRelease(props, this.requiredRelease, player, world)) {
            return false;
        }
        int requiredChakra = this.getChakraRequirement(props);
        int requiredSenChakra = this.getSenjutsuChakraRequirement(props);
        boolean requiresChakra = requiredChakra > 0;
        boolean requiresSenChakra = requiredSenChakra > 0;
        boolean hasChakra = !requiresChakra || props.getCurrentChakra() >= requiredChakra;
        boolean bl = hasSenChakra = !requiresSenChakra || props.getCurrentSenChakra() >= requiredSenChakra;
        if (!hasChakra || !hasSenChakra) {
            if (!world.field_72995_K) {
                StringBuilder message = new StringBuilder("You need ");
                if (!hasChakra) {
                    message.append(requiredChakra).append(" Chakra ");
                }
                if (!hasChakra && !hasSenChakra) {
                    message.append("and ");
                }
                if (!hasSenChakra) {
                    message.append(requiredSenChakra).append(" Senjutsu Chakra ");
                }
                message.append("to use this");
                this.sendMessage(player, message.toString().trim());
            }
            return false;
        }
        if (stack.field_77990_d.func_74764_b("cooldown") && stack.field_77990_d.func_74762_e("cooldown") > 0) {
            int remainingCooldown = stack.field_77990_d.func_74762_e("cooldown");
            int secondsRemaining = (int)Math.ceil((double)remainingCooldown / 20.0);
            if (!world.field_72995_K) {
                this.sendMessage(player, "You must wait " + secondsRemaining + " seconds before using this jutsu again");
            }
            return false;
        }
        if (!this.modeJutsu()) {
            if (requiresChakra) {
                props.consumeChakra(requiredChakra);
            }
            if (requiresSenChakra) {
                props.consumeSenjutsu(requiredSenChakra);
            }
        }
        if (this.cooldown > 0) {
            stack.field_77990_d.func_74768_a("cooldown", this.cooldown);
        }
        this.addJutsuXP(stack, player);
        return true;
    }

    public boolean checkRequiredRelease(ExtendedPlayer props, String requiredRelease, EntityPlayer player, World world) {
        String[] andReleases;
        if (requiredRelease == null || requiredRelease.isEmpty()) {
            return true;
        }
        for (String orGroup : andReleases = requiredRelease.split("\\+")) {
            String[] orReleases = orGroup.split("\\-");
            boolean hasAnyRelease = false;
            for (String release : orReleases) {
                if (!this.hasRelease(props, release = release.trim())) continue;
                hasAnyRelease = true;
                break;
            }
            if (hasAnyRelease) continue;
            if (!world.field_72995_K) {
                this.sendMessage(player, "You need " + requiredRelease + " to use this");
            }
            return false;
        }
        return true;
    }

    public boolean hasRelease(ExtendedPlayer props, String release) {
        switch (release.toLowerCase()) {
            case "wind": {
                return props.getWindRelease() == 1;
            }
            case "fire": {
                return props.getFireRelease() == 1;
            }
            case "water": {
                return props.getWaterRelease() == 1;
            }
            case "earth": {
                return props.getEarthRelease() == 1;
            }
            case "lightning": {
                return props.getLightningRelease() == 1;
            }
            case "yin": {
                return props.getYinRelease() == 1;
            }
            case "yang": {
                return props.getYangRelease() == 1;
            }
            case "wood": {
                return props.getwoodRelease() == 1;
            }
            case "lava": {
                return props.getlavaRelease() == 1;
            }
            case "scorch": {
                return props.getscorchRelease() == 1;
            }
            case "boil": {
                return props.getboilRelease() == 1;
            }
            case "magnet": {
                return props.getmagnetRelease() == 1;
            }
            case "storm": {
                return props.getstormRelease() == 1;
            }
            case "ice": {
                return props.geticeRelease() == 1;
            }
            case "explosion": {
                return props.getexplosionRelease() == 1;
            }
            case "steel": {
                return props.getsteelRelease() == 1;
            }
            case "crystal": {
                return props.getcrystalRelease() == 1;
            }
            case "dust": {
                return props.getdustRelease() == 1;
            }
            case "shikotsumyaku": {
                return props.getshikotsumyaku() == 1;
            }
            case "byakugan": {
                return props.getbyakugan() == 1;
            }
            case "tenseigan": {
                return props.gettenseigan() == 1;
            }
            case "ketsuryugan": {
                return props.getKetsuryugan() == 1;
            }
            case "jougan": {
                return props.getJouganActive();
            }
            case "sharingan": {
                return props.getSharinganActive() >= 1;
            }
            case "mangekyou": {
                return props.getSharinganActive() >= 2;
            }
            case "rinnegan": {
                return props.getSharinganActive() >= 3;
            }
        }
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack stack) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        ExtendedPlayer props = ExtendedPlayer.get(player);
        int req = this.getChakraRequirement(props);
        if (props.getCurrentChakra() < req) {
            if (!player.field_70170_p.field_72995_K) {
                this.sendMessage(player, "You need " + req + " Chakra to use this");
            }
            return true;
        }
        return false;
    }

    private String formatDescription(String description, int wordsPerLine) {
        String[] words = description.split("\\s+");
        StringBuilder formatted = new StringBuilder();
        int count = 0;
        for (String word : words) {
            formatted.append(word).append(" ");
            if (++count != wordsPerLine) continue;
            formatted.append("\n");
            count = 0;
        }
        if (formatted.length() > 0 && formatted.charAt(formatted.length() - 1) == ' ') {
            formatted.deleteCharAt(formatted.length() - 1);
        }
        return formatted.toString().trim();
    }

    public String formatRequiredRelease(String release) {
        if (release == null || release.isEmpty()) {
            return "";
        }
        String[] andReleases = release.split("\\+");
        StringBuilder formattedRelease = new StringBuilder();
        for (int i = 0; i < andReleases.length; ++i) {
            String[] orReleases = andReleases[i].split("-");
            for (int j = 0; j < orReleases.length; ++j) {
                formattedRelease.append(orReleases[j].trim());
                if (j >= orReleases.length - 1) continue;
                formattedRelease.append(" or ");
            }
            if (i >= andReleases.length - 1) continue;
            formattedRelease.append(" and ");
        }
        return formattedRelease.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
            itemStack.field_77990_d.func_74768_a("JutsuXP", 0);
            itemStack.field_77990_d.func_74768_a("JutsuLevel", 1);
            itemStack.field_77990_d.func_74778_a("OwnerUUID", player.func_110124_au().toString());
        }
        this.readFromNBT(itemStack.field_77990_d);
        if (this.isJutsuBanned()) {
            list.add(EnumChatFormatting.RED + "" + EnumChatFormatting.BOLD + "This jutsu has been banned on this server");
            return;
        }
        if (Keyboard.isKeyDown((int)42)) {
            List<Map.Entry<String, Double>> sortedScalings = this.getSortedScalings();
            if (!sortedScalings.isEmpty()) {
                list.add(EnumChatFormatting.YELLOW + "" + EnumChatFormatting.BOLD + "Scaling Attributes:");
                for (Map.Entry<String, Double> scaling : sortedScalings) {
                    String attribute = scaling.getKey();
                    DecimalFormat df = new DecimalFormat("#.#####");
                    double value = scaling.getValue();
                    String pretty = df.format(value);
                    list.add(EnumChatFormatting.AQUA + attribute + ": " + EnumChatFormatting.GREEN + pretty);
                }
                list.add("");
                list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "How much damage this jutsu gains ");
                list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "per Skill Point invested in that skill");
            } else {
                list.add(EnumChatFormatting.RED + "This jutsu doesn't scale with any stats");
            }
        } else {
            int cooldown;
            double modeDamageMultiplier;
            int modeBoostPercent;
            double healingBaseValue;
            int roundedBaseHealing;
            double baseDamageValue;
            int roundedBaseDamage;
            ExtendedPlayer props = ExtendedPlayer.get(player);
            int jutsuLevel = itemStack.field_77990_d.func_74762_e("JutsuLevel");
            int currentXP = itemStack.field_77990_d.func_74762_e("JutsuXP");
            int xpForNextLevel = this.getXpForNextLevel(jutsuLevel);
            if (this.enableMastery) {
                if (jutsuLevel >= 100) {
                    list.add(EnumChatFormatting.GOLD + "" + EnumChatFormatting.BOLD + "Mastery Max");
                } else {
                    list.add(EnumChatFormatting.GOLD + "" + EnumChatFormatting.BOLD + "Mastery Level " + jutsuLevel);
                    int initialBarLength = 60;
                    String formattedCurrentXP = this.formatXPValue(currentXP);
                    String formattedMaxXP = this.formatXPValue(xpForNextLevel);
                    String xpText = EnumChatFormatting.LIGHT_PURPLE + formattedCurrentXP + EnumChatFormatting.RESET + "/" + EnumChatFormatting.LIGHT_PURPLE + formattedMaxXP + EnumChatFormatting.RESET;
                    int textLength = xpText.length();
                    int barLength = initialBarLength - 2 * textLength;
                    int filledLength = (int)((double)currentXP / (double)xpForNextLevel * (double)barLength);
                    int halfBarLength = barLength / 2;
                    StringBuilder xpBar = new StringBuilder(EnumChatFormatting.DARK_PURPLE + "[");
                    for (int i = 0; i < barLength; ++i) {
                        if (i == halfBarLength) {
                            xpBar.append(EnumChatFormatting.RESET).append(xpText).append(EnumChatFormatting.DARK_PURPLE);
                            continue;
                        }
                        if (i < filledLength) {
                            xpBar.append(EnumChatFormatting.LIGHT_PURPLE).append("|");
                            continue;
                        }
                        xpBar.append(EnumChatFormatting.DARK_PURPLE).append("|");
                    }
                    xpBar.append(EnumChatFormatting.DARK_PURPLE).append("]");
                    list.add(xpBar.toString());
                }
                list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.STRIKETHROUGH + "--------------------");
            }
            if ((roundedBaseDamage = (int)Math.round(baseDamageValue = this.getDamage(props, itemStack))) > 0 && !this.healJutsu() && !this.pureDebuffJutsu()) {
                list.add(EnumChatFormatting.RED + "" + EnumChatFormatting.BOLD + "Damage: " + EnumChatFormatting.RESET + EnumChatFormatting.RED + roundedBaseDamage);
            }
            if ((roundedBaseHealing = (int)Math.round(healingBaseValue = this.getHealing(props, itemStack))) > 0 && this.healJutsu()) {
                list.add(EnumChatFormatting.RED + "" + EnumChatFormatting.BOLD + "Heal: " + EnumChatFormatting.RESET + EnumChatFormatting.RED + roundedBaseHealing);
            }
            if ((modeBoostPercent = (int)(((modeDamageMultiplier = ModeMultiplierHandler.getModeMultiplier(props)) - 1.0) * 100.0)) > 0 && !this.pureDebuffJutsu() && !this.healJutsu()) {
                list.add(EnumChatFormatting.GREEN + "" + EnumChatFormatting.BOLD + "Mode Damage Boost: " + EnumChatFormatting.RESET + EnumChatFormatting.GREEN + "+" + modeBoostPercent + "%");
            }
            if (modeBoostPercent > 0 && this.healJutsu()) {
                list.add(EnumChatFormatting.GREEN + "" + EnumChatFormatting.BOLD + "Mode Healing Boost: " + EnumChatFormatting.RESET + EnumChatFormatting.GREEN + "+" + modeBoostPercent + "%");
            }
            if (this.getChakraRequirement(props) > 0) {
                list.add(EnumChatFormatting.BLUE + "" + EnumChatFormatting.BOLD + "Chakra Cost: " + EnumChatFormatting.RESET + EnumChatFormatting.BLUE + this.getChakraRequirement(props));
            }
            if (this.getSenjutsuChakraRequirement(props) > 0) {
                list.add(EnumChatFormatting.DARK_GREEN + "" + EnumChatFormatting.BOLD + "Senjutsu Chakra Cost: " + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GREEN + this.getSenjutsuChakraRequirement(props));
            }
            if (itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b("cooldown") && (cooldown = itemStack.field_77990_d.func_74762_e("cooldown")) > 0) {
                int seconds = (int)Math.ceil((double)cooldown / 20.0);
                list.add(EnumChatFormatting.WHITE + "" + EnumChatFormatting.BOLD + "Cooldown: " + EnumChatFormatting.RESET + EnumChatFormatting.WHITE + seconds + " seconds");
            }
            if (this.requiredRelease != null && !this.requiredRelease.isEmpty()) {
                String formattedRelease = this.formatRequiredRelease(this.requiredRelease);
                list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.BOLD + "Required Release: " + EnumChatFormatting.RESET + EnumChatFormatting.DARK_PURPLE + formattedRelease);
            }
            if (itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b("OwnerUUID")) {
                String ownerUUID = itemStack.field_77990_d.func_74779_i("OwnerUUID");
                try {
                    EntityPlayer owner = player.field_70170_p.func_152378_a(UUID.fromString(ownerUUID));
                    if (owner != null) {
                        list.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.BOLD + "Owner: " + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + owner.getDisplayName());
                    } else {
                        list.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.BOLD + "Owner: " + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + "Unknown");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.style != null && !this.style.isEmpty()) {
                String formattedStyle = this.formatDescription(this.style, 5).replace("\n", " ");
                list.add(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Style: " + EnumChatFormatting.RESET + EnumChatFormatting.AQUA + formattedStyle);
            }
            if (this.description != null && !this.description.isEmpty()) {
                list.add("");
                String formattedDescription = this.formatDescription(this.description, 5);
                for (String line : formattedDescription.split("\n")) {
                    list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + line);
                }
            }
            if (!this.utilityJutsu()) {
                list.add("");
                list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "Press Left Shift for more information");
            }
        }
    }

    private List<Map.Entry<String, Double>> getSortedScalings() {
        LinkedHashMap<String, Double> scalings = new LinkedHashMap<String, Double>();
        scalings.put("Ninjutsu", this.ninScaling);
        scalings.put("Taijutsu", this.taiScaling);
        scalings.put("Genjutsu", this.genScaling);
        scalings.put("Kenjutsu", this.kenScaling);
        scalings.put("Shurikenjutsu", this.shurikenScaling);
        scalings.put("Summoning", this.summonScaling);
        scalings.put("Kinjutsu", this.kinScaling);
        scalings.put("Senjutsu", this.senScaling);
        scalings.put("Medical", this.medScaling);
        ArrayList<Map.Entry<String, Double>> sortedScalings = new ArrayList<Map.Entry<String, Double>>(scalings.entrySet());
        sortedScalings.removeIf(entry -> (Double)entry.getValue() <= 0.0);
        sortedScalings.sort((entry1, entry2) -> Double.compare((Double)entry2.getValue(), (Double)entry1.getValue()));
        return sortedScalings;
    }

    private String formatXPValue(int xpValue) {
        if (xpValue >= 1000000) {
            return String.format("%.1fM", (double)xpValue / 1000000.0);
        }
        if (xpValue >= 1000) {
            return String.format("%.1fK", (double)xpValue / 1000.0);
        }
        return String.valueOf(xpValue);
    }

    public boolean isJutsuBanned() {
        return this.jutsuBanned;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.epic;
    }

    public void sendMessage(EntityPlayer player, String message) {
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + message));
    }

    protected boolean summonJutsu() {
        return false;
    }

    protected boolean healJutsu() {
        return false;
    }

    protected boolean modeJutsu() {
        return false;
    }

    protected boolean pureDebuffJutsu() {
        return false;
    }

    protected boolean excludeFromConfig() {
        return false;
    }

    protected boolean utilityJutsu() {
        return false;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.ninScaling = compound.func_74769_h("ninScaling");
        this.taiScaling = compound.func_74769_h("taiScaling");
        this.genScaling = compound.func_74769_h("genScaling");
        this.kenScaling = compound.func_74769_h("kenScaling");
        this.shurikenScaling = compound.func_74769_h("shurikenScaling");
        this.summonScaling = compound.func_74769_h("summonScaling");
        this.kinScaling = compound.func_74769_h("kinScaling");
        this.senScaling = compound.func_74769_h("senScaling");
        this.medScaling = compound.func_74769_h("medScaling");
        this.baseDamage = compound.func_74769_h("baseDamage");
        this.chakraBaseCost = compound.func_74762_e("chakraBaseCost");
        this.chakraCostScaling = compound.func_74769_h("chakraCostScaling");
        this.senBaseCost = compound.func_74762_e("senBaseCost");
        this.senCostScaling = compound.func_74769_h("senCostScaling");
        this.damageCap = compound.func_74769_h("damageCap");
        this.description = compound.func_74779_i("description");
        this.style = compound.func_74779_i("style");
        this.requiredRelease = compound.func_74779_i("requiredRelease");
        this.cooldown = compound.func_74762_e("cooldown");
        this.receivedXPPerUse = compound.func_74762_e("receivedXPPerUse");
        this.convertedXP = compound.func_74762_e("convertedXP");
        this.convertedJP = compound.func_74762_e("convertedJP");
        this.cloneLifetime = compound.func_74762_e("cloneLifetime");
        this.effectDuration = compound.func_74762_e("effectDuration");
        this.healAmount = compound.func_74762_e("healAmount");
        this.enableMastery = compound.func_74767_n("enableMastery");
        this.jutsuBanned = compound.func_74767_n("jutsuBanned");
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74780_a("ninScaling", this.ninScaling);
        compound.func_74780_a("taiScaling", this.taiScaling);
        compound.func_74780_a("genScaling", this.genScaling);
        compound.func_74780_a("kenScaling", this.kenScaling);
        compound.func_74780_a("shurikenScaling", this.shurikenScaling);
        compound.func_74780_a("summonScaling", this.summonScaling);
        compound.func_74780_a("kinScaling", this.kinScaling);
        compound.func_74780_a("senScaling", this.senScaling);
        compound.func_74780_a("medScaling", this.medScaling);
        compound.func_74780_a("baseDamage", this.baseDamage);
        compound.func_74768_a("chakraBaseCost", this.chakraBaseCost);
        compound.func_74780_a("chakraCostScaling", this.chakraCostScaling);
        compound.func_74768_a("senBaseCost", this.senBaseCost);
        compound.func_74780_a("senCostScaling", this.senCostScaling);
        compound.func_74780_a("damageCap", this.damageCap);
        compound.func_74778_a("description", this.description);
        compound.func_74778_a("style", this.style);
        compound.func_74778_a("requiredRelease", this.requiredRelease);
        compound.func_74768_a("cooldown", this.cooldown);
        compound.func_74768_a("receivedXPPerUse", this.receivedXPPerUse);
        compound.func_74768_a("convertedXP", this.convertedXP);
        compound.func_74768_a("convertedJP", this.convertedJP);
        compound.func_74768_a("cloneLifetime", this.cloneLifetime);
        compound.func_74768_a("effectDuration", this.effectDuration);
        compound.func_74768_a("healAmount", this.healAmount);
        compound.func_74757_a("enableMastery", this.enableMastery);
        compound.func_74757_a("jutsuBanned", this.jutsuBanned);
    }
}

