/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.GameMenu.Wiki;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.config.Configuration;

public class WikiFileGenerator {
    private static final String CONFIG_PATH = "config/NarutoDestination/Wiki/";

    public static void generateDefaultWikiFiles() {
        WikiFileGenerator.createWikiFile("WikiMainPage.cfg", WikiFileGenerator.getMainPageDefaults());
    }

    private static void createWikiFile(String fileName, DefaultConfigSupplier defaults) {
        File file = new File(CONFIG_PATH + fileName);
        if (!file.exists()) {
            try {
                Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                Configuration config = new Configuration(file);
                defaults.supplyDefaults(config);
                config.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static DefaultConfigSupplier getMainPageDefaults() {
        return config -> {
            config.get("general", "Identifier", "main");
            config.get("button.tipsandtricks", "Label", "Tips and Tricks");
            config.get("button.tipsandtricks", "Target", "WikiTips.cfg");
            config.get("button.tipsandtricks", "Alignment", "CENTER");
            config.get("button.staff", "Label", "Staff Team");
            config.get("button.staff", "Target", "WikiStaff.cfg");
            config.get("button.staff", "Alignment", "CENTER");
            config.get("subsection.0", "Title", "Welcome");
            config.get("subsection.0", "Content", "Welcome to the Naruto Destination Wiki!");
            config.get("subsection.0", "TitleAlignment", "CENTER");
            config.get("subsection.0", "ContentAlignment", "CENTER");
        };
    }

    @FunctionalInterface
    private static interface DefaultConfigSupplier {
        public void supplyDefaults(Configuration var1);
    }
}

