/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Jutsu;

import java.util.ArrayList;
import java.util.List;
import narutodestination.Mathioks.FinalUtilities.MathHelper3D;
import narutodestination.Mathioks.Jutsu.JutsuLogic;
import narutodestination.Mathioks.Jutsu.RayMarcher;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class BlockWall {
    private static final List<BlockWall> walls = new ArrayList<BlockWall>();
    private final int height;
    private final int width;
    private final int widthBlocksPerTick;
    private final int heightBlocksPerTick;
    private final int ticksPerGrowth;
    private final World world;
    private final Block block;
    int counter;
    final Vec3 pos;
    final Vec3 wallHeightDir;
    final Vec3 wallWidthDir;

    public static void tickAll() {
        walls.removeIf(wall -> !wall.tick());
    }

    public static void createWall(int height, int width, int widthBlocksPerTick, int heightBlocksPerTick, int ticksPerGrowth, World world, Block block, EntityPlayer player) {
        Vec3 lookDir = MathHelper3D.vecFromPitchAndYaw(player.field_70125_A, player.field_70177_z);
        Vec3 wallWidthDir = MathHelper3D.vecFromPitchAndYaw(0.0, player.field_70177_z + 90.0f);
        Vec3 wallHeightDir = lookDir.func_72431_c(wallWidthDir).func_72432_b();
        Vec3 pos = Vec3.func_72443_a((double)(player.field_70165_t + lookDir.field_72450_a * 3.0), (double)(player.field_70163_u + lookDir.field_72448_b * 3.0 + (double)player.func_70047_e()), (double)(player.field_70161_v + lookDir.field_72449_c * 3.0));
        BlockWall blockWall = new BlockWall(height, width, widthBlocksPerTick, heightBlocksPerTick, ticksPerGrowth, world, block, pos, wallWidthDir, wallHeightDir);
        walls.add(blockWall);
    }

    private BlockWall(int height, int width, int widthBlocksPerTick, int heightBlocksPerTick, int ticksPerGrowth, World world, Block block, Vec3 pos, Vec3 wallWidthDir, Vec3 wallHeightDir) {
        this.height = height;
        this.width = width;
        this.widthBlocksPerTick = widthBlocksPerTick;
        this.heightBlocksPerTick = heightBlocksPerTick;
        this.ticksPerGrowth = ticksPerGrowth;
        this.world = world;
        this.block = block;
        this.counter = -1;
        this.pos = pos;
        this.wallWidthDir = wallWidthDir;
        this.wallHeightDir = wallHeightDir;
    }

    public boolean tick() {
        if (this.counter > (this.width / this.widthBlocksPerTick + 1) * this.ticksPerGrowth && this.counter > (this.height / this.heightBlocksPerTick + 1) * this.ticksPerGrowth) {
            return false;
        }
        if (++this.counter % this.ticksPerGrowth != 0) {
            return true;
        }
        int currentStep = this.counter / this.ticksPerGrowth;
        int factor = Math.min(this.width, currentStep * this.widthBlocksPerTick);
        Vec3 adjustedWallWidthDir = Vec3.func_72443_a((double)(this.wallWidthDir.field_72450_a * (double)factor), (double)(this.wallWidthDir.field_72448_b * (double)factor), (double)(this.wallWidthDir.field_72449_c * (double)factor));
        Vec3 adjustedWallWidthDirTimes2 = Vec3.func_72443_a((double)(adjustedWallWidthDir.field_72450_a * 2.0), (double)(adjustedWallWidthDir.field_72448_b * 2.0), (double)(adjustedWallWidthDir.field_72449_c * 2.0));
        for (int i = -currentStep; i <= currentStep; ++i) {
            Vec3 upperPos = this.pos.func_72441_c(this.wallHeightDir.field_72450_a * (double)i, this.wallHeightDir.field_72448_b * (double)i, this.wallHeightDir.field_72449_c * (double)i);
            Vec3 lowerPos = this.pos.func_72441_c(-this.wallHeightDir.field_72450_a * (double)i, -this.wallHeightDir.field_72448_b * (double)i, -this.wallHeightDir.field_72449_c * (double)i);
            List<Vec3> blocksToReplace = RayMarcher.rayMarchBlocks(upperPos.func_72441_c(-adjustedWallWidthDir.field_72450_a, -adjustedWallWidthDir.field_72448_b, -adjustedWallWidthDir.field_72449_c), adjustedWallWidthDirTimes2);
            blocksToReplace.addAll(RayMarcher.rayMarchBlocks(lowerPos.func_72441_c(-adjustedWallWidthDir.field_72450_a, -adjustedWallWidthDir.field_72448_b, -adjustedWallWidthDir.field_72449_c), adjustedWallWidthDirTimes2));
            for (Vec3 pos : blocksToReplace) {
                Block currentBlock = this.world.func_147439_a((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
                if (currentBlock != Blocks.field_150350_a) continue;
                JutsuLogic.setBlockWithoutReplacing(this.world, (int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c, this.block, 0, 2);
            }
        }
        return true;
    }
}

