/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Jutsu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class RayMarcher {
    public static List<Vec3> rayMarchBlocks(Vec3 startingPos, Vec3 direction) {
        ArrayList<Vec3> blocks = new ArrayList<Vec3>();
        Vec3 currentBlock = Vec3.func_72443_a((double)Math.floor(startingPos.field_72450_a), (double)Math.floor(startingPos.field_72448_b), (double)Math.floor(startingPos.field_72449_c));
        Vec3 lastBlock = Vec3.func_72443_a((double)Math.floor(startingPos.field_72450_a + direction.field_72450_a), (double)Math.floor(startingPos.field_72448_b + direction.field_72448_b), (double)Math.floor(startingPos.field_72449_c + direction.field_72449_c));
        double stepX = direction.field_72450_a >= 0.0 ? 1.0 : -1.0;
        double stepY = direction.field_72448_b >= 0.0 ? 1.0 : -1.0;
        double stepZ = direction.field_72449_c >= 0.0 ? 1.0 : -1.0;
        double next_voxel_boundary_x = currentBlock.field_72450_a + Math.max(stepX, 0.0);
        double next_voxel_boundary_y = currentBlock.field_72448_b + Math.max(stepY, 0.0);
        double next_voxel_boundary_z = currentBlock.field_72449_c + Math.max(stepZ, 0.0);
        double tMaxX = direction.field_72450_a != 0.0 ? (next_voxel_boundary_x - startingPos.field_72450_a) / direction.field_72450_a : Double.MAX_VALUE;
        double tMaxY = direction.field_72448_b != 0.0 ? (next_voxel_boundary_y - startingPos.field_72448_b) / direction.field_72448_b : Double.MAX_VALUE;
        double tMaxZ = direction.field_72449_c != 0.0 ? (next_voxel_boundary_z - startingPos.field_72449_c) / direction.field_72449_c : Double.MAX_VALUE;
        double tDeltaX = direction.field_72450_a != 0.0 ? 1.0 / direction.field_72450_a * stepX : Double.MAX_VALUE;
        double tDeltaY = direction.field_72448_b != 0.0 ? 1.0 / direction.field_72448_b * stepY : Double.MAX_VALUE;
        double tDeltaZ = direction.field_72449_c != 0.0 ? 1.0 / direction.field_72449_c * stepZ : Double.MAX_VALUE;
        blocks.add(currentBlock);
        int counter = 0;
        while (currentBlock.func_72436_e(lastBlock) > 1.0E-4 && (double)(++counter) < direction.func_72433_c() * 3.0) {
            if (tMaxX < tMaxY) {
                if (tMaxX < tMaxZ) {
                    currentBlock = currentBlock.func_72441_c(stepX, 0.0, 0.0);
                    tMaxX += tDeltaX;
                } else {
                    currentBlock = currentBlock.func_72441_c(0.0, 0.0, stepZ);
                    tMaxZ += tDeltaZ;
                }
            } else if (tMaxY < tMaxZ) {
                currentBlock = currentBlock.func_72441_c(0.0, stepY, 0.0);
                tMaxY += tDeltaY;
            } else {
                currentBlock = currentBlock.func_72441_c(0.0, 0.0, stepZ);
                tMaxZ += tDeltaZ;
            }
            blocks.add(currentBlock);
        }
        return blocks;
    }

    public static MovingObjectPosition rayMarchBlocks(Vec3 startingPos, Vec3 direction, World world) {
        block5: {
            double min;
            Vec3 hitPos;
            int z;
            int y;
            int x = (int)Math.floor(startingPos.field_72450_a);
            MovingObjectPosition movingObjectPosition = RayMarcher.testBlock(world, x, y = (int)Math.floor(startingPos.field_72448_b), z = (int)Math.floor(startingPos.field_72449_c), startingPos);
            if (movingObjectPosition != null) {
                return movingObjectPosition;
            }
            int stepX = direction.field_72450_a >= 0.0 ? 1 : -1;
            int stepY = direction.field_72448_b >= 0.0 ? 1 : -1;
            int stepZ = direction.field_72449_c >= 0.0 ? 1 : -1;
            double next_voxel_boundary_x = x + Math.max(stepX, 0);
            double next_voxel_boundary_y = y + Math.max(stepY, 0);
            double next_voxel_boundary_z = z + Math.max(stepZ, 0);
            double tMaxX = direction.field_72450_a != 0.0 ? (next_voxel_boundary_x - startingPos.field_72450_a) / direction.field_72450_a : Double.MAX_VALUE;
            double tMaxY = direction.field_72448_b != 0.0 ? (next_voxel_boundary_y - startingPos.field_72448_b) / direction.field_72448_b : Double.MAX_VALUE;
            double tMaxZ = direction.field_72449_c != 0.0 ? (next_voxel_boundary_z - startingPos.field_72449_c) / direction.field_72449_c : Double.MAX_VALUE;
            double tDeltaX = direction.field_72450_a != 0.0 ? 1.0 / direction.field_72450_a * (double)stepX : Double.MAX_VALUE;
            double tDeltaY = direction.field_72448_b != 0.0 ? 1.0 / direction.field_72448_b * (double)stepY : Double.MAX_VALUE;
            double tDeltaZ = direction.field_72449_c != 0.0 ? 1.0 / direction.field_72449_c * (double)stepZ : Double.MAX_VALUE;
            do {
                double d;
                min = Math.min(tMaxX, Math.min(tMaxY, tMaxZ));
                if (!(d < 1.0)) break block5;
                if (tMaxX < tMaxY) {
                    if (tMaxX < tMaxZ) {
                        x += stepX;
                        tMaxX += tDeltaX;
                        continue;
                    }
                    z += stepZ;
                    tMaxZ += tDeltaZ;
                    continue;
                }
                if (tMaxY < tMaxZ) {
                    y += stepY;
                    tMaxY += tDeltaY;
                    continue;
                }
                z += stepZ;
                tMaxZ += tDeltaZ;
            } while ((movingObjectPosition = RayMarcher.testBlock(world, x, y, z, hitPos = Vec3.func_72443_a((double)(min * direction.field_72450_a), (double)(min * direction.field_72448_b), (double)(min * direction.field_72449_c)).func_72441_c(startingPos.field_72450_a, startingPos.field_72448_b, startingPos.field_72449_c))) == null);
            return movingObjectPosition;
        }
        return null;
    }

    private static MovingObjectPosition testBlock(World world, int x, int y, int z, Vec3 currentEndPos) {
        int metadata = world.func_72805_g(x, y, z);
        Block block = world.func_147439_a(x, y, z);
        AxisAlignedBB axisAlignedBB = block.func_149668_a(world, x, y, z);
        if (axisAlignedBB != null && block.func_149678_a(metadata, false) && RayMarcher.insideOrTouching(axisAlignedBB, currentEndPos)) {
            int side = RayMarcher.hitSide(x, y, z, currentEndPos);
            return new MovingObjectPosition(x, y, z, side, currentEndPos);
        }
        return null;
    }

    private static int hitSide(int x, int y, int z, Vec3 currentEndPos) {
        double xDiff = Math.abs((double)x - currentEndPos.field_72450_a);
        double yDiff = Math.abs((double)y - currentEndPos.field_72448_b);
        double zDiff = Math.abs((double)z - currentEndPos.field_72449_c);
        double epsilon = 1.0E-6;
        if (yDiff > 0.999999) {
            return 1;
        }
        if (yDiff < 1.0E-6) {
            return 0;
        }
        if (xDiff > 0.999999) {
            return 2;
        }
        if (xDiff < 1.0E-6) {
            return 3;
        }
        if (zDiff > 0.999999) {
            return 5;
        }
        if (zDiff < 1.0E-6) {
            return 4;
        }
        return -1;
    }

    private static boolean insideOrTouching(AxisAlignedBB axisAlignedBB, Vec3 vec3) {
        return axisAlignedBB.field_72340_a <= vec3.field_72450_a && axisAlignedBB.field_72336_d >= vec3.field_72450_a && axisAlignedBB.field_72338_b <= vec3.field_72448_b && axisAlignedBB.field_72337_e >= vec3.field_72448_b && axisAlignedBB.field_72339_c <= vec3.field_72449_c && axisAlignedBB.field_72334_f >= vec3.field_72449_c;
    }
}

