/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.NPC.ConfigurableMobs;

import java.util.ArrayList;
import java.util.List;
import narutodestination.Mathioks.NPC.ConfigurableMobs.JutsuAttack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NinjaMobConfig {
    private double health = 20.0;
    private double meleeDamage = 2.0;
    private double movementSpeed = 0.4;
    private double followRange = 50.0;
    private int experienceValue = 5;
    private boolean canUseRangedAttacks = true;
    private boolean canUseMeleeAttacks = true;
    private float rangedAttackRange = 15.0f;
    private int rangedAttackCooldown = 600;
    private float leapStrength = 0.4f;
    private List<WeaponChoice> possibleWeapons = new ArrayList<WeaponChoice>();
    private List<ArmorChoice> armor = new ArrayList<ArmorChoice>();
    private List<JutsuAttack> jutsuAttacks = new ArrayList<JutsuAttack>();
    private List<DropEntry> drops = new ArrayList<DropEntry>();
    private int skinVariants = 1;
    private String customName = null;
    private boolean attackPlayers = true;
    private boolean attackTameables = false;
    private boolean attackMobs = false;

    public double getHealth() {
        return this.health;
    }

    public double getMeleeDamage() {
        return this.meleeDamage;
    }

    public double getMovementSpeed() {
        return this.movementSpeed;
    }

    public double getFollowRange() {
        return this.followRange;
    }

    public int getExperienceValue() {
        return this.experienceValue;
    }

    public boolean canUseRangedAttacks() {
        return this.canUseRangedAttacks;
    }

    public boolean canUseMeleeAttacks() {
        return this.canUseMeleeAttacks;
    }

    public float getRangedAttackRange() {
        return this.rangedAttackRange;
    }

    public int getRangedAttackCooldown() {
        return this.rangedAttackCooldown;
    }

    public float getLeapStrength() {
        return this.leapStrength;
    }

    public List<WeaponChoice> getPossibleWeapons() {
        return this.possibleWeapons;
    }

    public List<JutsuAttack> getJutsuAttacks() {
        return this.jutsuAttacks;
    }

    public List<DropEntry> getDrops() {
        return this.drops;
    }

    public int getSkinVariants() {
        return this.skinVariants;
    }

    public String getCustomName() {
        return this.customName;
    }

    public boolean shouldAttackPlayers() {
        return this.attackPlayers;
    }

    public boolean shouldAttackTameables() {
        return this.attackTameables;
    }

    public boolean shouldAttackMobs() {
        return this.attackMobs;
    }

    public static class DropEntry {
        public final Item item;
        public final float chance;
        public final int minAmount;
        public final int maxAmount;

        public DropEntry(Item item, float chance, int minAmount, int maxAmount) {
            this.item = item;
            this.chance = chance;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }
    }

    public static class ArmorChoice {
        public final int slot;
        public final ItemStack itemStack;

        public ArmorChoice(int slot, ItemStack itemStack) {
            this.slot = slot;
            this.itemStack = itemStack;
        }
    }

    public static class WeaponChoice {
        public final ItemStack itemStack;
        public final int weight;

        public WeaponChoice(Item item, int weight) {
            this(new ItemStack(item), weight);
        }

        public WeaponChoice(ItemStack itemStack, int weight) {
            this.itemStack = itemStack;
            this.weight = weight;
        }
    }

    public static class Builder {
        private NinjaMobConfig config = new NinjaMobConfig();

        public Builder health(double health) {
            this.config.health = health;
            return this;
        }

        public Builder meleeDamage(double damage) {
            this.config.meleeDamage = damage;
            return this;
        }

        public Builder movementSpeed(double speed) {
            this.config.movementSpeed = speed;
            return this;
        }

        public Builder followRange(double range) {
            this.config.followRange = range;
            return this;
        }

        public Builder experienceValue(int xp) {
            this.config.experienceValue = xp;
            return this;
        }

        public Builder rangedAttackRange(float range) {
            this.config.rangedAttackRange = range;
            return this;
        }

        public Builder rangedCooldown(int ticks) {
            this.config.rangedAttackCooldown = ticks;
            return this;
        }

        public Builder leapStrength(float strength) {
            this.config.leapStrength = strength;
            return this;
        }

        public Builder addWeapon(Item item, int weight) {
            this.config.possibleWeapons.add(new WeaponChoice(item, weight));
            return this;
        }

        public Builder addWeapon(ItemStack itemStack, int weight) {
            this.config.possibleWeapons.add(new WeaponChoice(itemStack, weight));
            return this;
        }

        public Builder addJutsu(JutsuAttack jutsu) {
            this.config.jutsuAttacks.add(jutsu);
            return this;
        }

        public Builder addDrop(Item item, float chance, int minAmount, int maxAmount) {
            this.config.drops.add(new DropEntry(item, chance, minAmount, maxAmount));
            return this;
        }

        public Builder skinVariants(int variants) {
            this.config.skinVariants = variants;
            return this;
        }

        public Builder customName(String name) {
            this.config.customName = name;
            return this;
        }

        public Builder attackPlayers(boolean attack) {
            this.config.attackPlayers = attack;
            return this;
        }

        public Builder attackTameables(boolean attack) {
            this.config.attackTameables = attack;
            return this;
        }

        public Builder attackMobs(boolean attack) {
            this.config.attackMobs = attack;
            return this;
        }

        public Builder disableRanged() {
            this.config.canUseRangedAttacks = false;
            return this;
        }

        public Builder disableMelee() {
            this.config.canUseMeleeAttacks = false;
            return this;
        }

        public NinjaMobConfig build() {
            return this.config;
        }
    }
}

