/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.TransformationsRealPackage;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import narutodestination.Mathioks.AbstractMessage;
import narutodestination.Mathioks.Config.GeneralConfig;
import narutodestination.Mathioks.ExtendedPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class SyncHealthCapMessage
extends AbstractMessage<SyncHealthCapMessage> {
    private int data;

    public SyncHealthCapMessage() {
    }

    public SyncHealthCapMessage(EntityPlayer player) {
        this.data = ExtendedPlayer.get(player).getHealthCap();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.data = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.data);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            return;
        }
        ExtendedPlayer props = ExtendedPlayer.get(player);
        int maxAllowedHealthCap = 1500 + GeneralConfig.maxOtsutsukiHealthBonus;
        if (this.data > maxAllowedHealthCap) {
            System.out.println(player.getDisplayName() + " attempted to set health cap to " + this.data + " (max allowed: " + maxAllowedHealthCap + ")");
            props.setHealthCap(1000, side);
            if (props.getHealthTBCap() > 500) {
                props.setHealthTBCap(500, side);
            }
            if (props.getHealthOtsuCap() > GeneralConfig.maxOtsutsukiHealthBonus) {
                props.setHealthOtsuCap(GeneralConfig.maxOtsutsukiHealthBonus, side);
            }
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Your health cap has been adjusted to the maximum allowed value."));
        }
    }
}

