/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Commands;

import java.util.ArrayList;
import java.util.List;
import narutodestination.Mathioks.AddedItems;
import narutodestination.Mathioks.ExtendedPlayer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class CommandLearner
extends CommandBase {
    private static final String[] ALL_RELEASES_AND_CLANS = new String[]{"Fire", "Water", "Wind", "Earth", "Lightning", "Yin", "Yang", "YinYang", "Wood", "Lava", "Scorch", "Boil", "Magnet", "Storm", "Ice", "Explosion", "Steel", "Crystal", "Dust", "Uzumaki", "Sharingan", "Byakugan", "Nara", "Aburame", "Inuzuka", "Sarutobi", "Yamanaka", "Kurama", "Tsuchigumo", "Iburi", "Fuma", "Chinoike", "Rinnegan", "MangekyouSharingan", "Medical", "Taijutsu", "EightGates", "Kenjutsu", "RinneganUnlocker", "TailedBeast", "Snake"};

    public String func_71517_b() {
        return "learner";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/learner <release/all/known> <player>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length != 2) {
            throw new WrongUsageException("Incorrect number of arguments. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandLearner.func_82359_c((ICommandSender)sender, (String)args[1]);
        ExtendedPlayer props = ExtendedPlayer.get((EntityPlayer)player);
        switch (args[0].toLowerCase()) {
            case "all": {
                this.giveAllSkillLearners(player);
                break;
            }
            case "known": {
                this.giveKnownSkillLearners(player, props);
                break;
            }
            default: {
                this.giveSpecificSkillLearner(player, args[0]);
            }
        }
    }

    private void giveAllSkillLearners(EntityPlayerMP player) {
        for (String releaseOrClan : ALL_RELEASES_AND_CLANS) {
            ItemStack skillLearner = this.getSkillLearnerForRelease(releaseOrClan);
            if (skillLearner == null) continue;
            player.field_71071_by.func_70441_a(skillLearner);
        }
    }

    private void giveKnownSkillLearners(EntityPlayerMP player, ExtendedPlayer props) {
        ItemStack skillLearner;
        List<String> knownReleases = props.getKnownReleases(props);
        List<String> knownClans = props.getKnownClans();
        for (String release : knownReleases) {
            skillLearner = this.getSkillLearnerForRelease(release);
            if (skillLearner == null) continue;
            player.field_71071_by.func_70441_a(skillLearner);
        }
        for (String clan : knownClans) {
            skillLearner = this.getSkillLearnerForRelease(clan);
            if (skillLearner == null) continue;
            player.field_71071_by.func_70441_a(skillLearner);
        }
    }

    private void giveSpecificSkillLearner(EntityPlayerMP player, String release) {
        ItemStack skillLearner = this.getSkillLearnerForRelease(release);
        if (skillLearner == null) {
            throw new WrongUsageException("Release or clan '" + release + "' not found.", new Object[0]);
        }
        player.field_71071_by.func_70441_a(skillLearner);
    }

    private ItemStack getSkillLearnerForRelease(String release) {
        switch (release.toLowerCase()) {
            case "fire": {
                return new ItemStack(AddedItems.SkillLearnerFireRelease);
            }
            case "water": {
                return new ItemStack(AddedItems.SkillLearnerWaterRelease);
            }
            case "wind": {
                return new ItemStack(AddedItems.SkillLearnerWindRelease);
            }
            case "earth": {
                return new ItemStack(AddedItems.SkillLearnerEarthRelease);
            }
            case "lightning": {
                return new ItemStack(AddedItems.SkillLearnerLightningRelease);
            }
            case "yin": {
                return new ItemStack(AddedItems.SkillLearnerYinRelease);
            }
            case "yang": {
                return new ItemStack(AddedItems.SkillLearnerYangRelease);
            }
            case "yinyang": {
                return new ItemStack(AddedItems.SkillLearnerYinYangRelease);
            }
            case "wood": {
                return new ItemStack(AddedItems.SkillLearnerWoodRelease);
            }
            case "lava": {
                return new ItemStack(AddedItems.SkillLearnerLavaRelease);
            }
            case "scorch": {
                return new ItemStack(AddedItems.SkillLearnerScorchRelease);
            }
            case "boil": {
                return new ItemStack(AddedItems.SkillLearnerBoilRelease);
            }
            case "magnet": {
                return new ItemStack(AddedItems.SkillLearnerMagnetRelease);
            }
            case "storm": {
                return new ItemStack(AddedItems.SkillLearnerStormRelease);
            }
            case "ice": {
                return new ItemStack(AddedItems.SkillLearnerIceRelease);
            }
            case "explosion": {
                return new ItemStack(AddedItems.SkillLearnerExplosionRelease);
            }
            case "steel": {
                return new ItemStack(AddedItems.SkillLearnerSteelRelease);
            }
            case "crystal": {
                return new ItemStack(AddedItems.SkillLearnerCrystalRelease);
            }
            case "dust": {
                return new ItemStack(AddedItems.SkillLearnerDustRelease);
            }
            case "rinnegan": {
                return new ItemStack(AddedItems.SkillLearnerRinnegan);
            }
            case "sharingan": {
                return new ItemStack(AddedItems.SkillLearnerSharingan);
            }
            case "mangekyousharingan": {
                return new ItemStack(AddedItems.SkillLearnerMangekyouKagutsuchi);
            }
            case "byakugan": {
                return new ItemStack(AddedItems.SkillLearnerByakugan);
            }
            case "uzumaki": {
                return new ItemStack(AddedItems.SkillLearnerUzumaki);
            }
            case "aburame": {
                return new ItemStack(AddedItems.SkillLearnerAburame);
            }
            case "iburi": {
                return new ItemStack(AddedItems.SkillLearnerIburi);
            }
            case "inuzuka": {
                return new ItemStack(AddedItems.SkillLearnerInuzuka);
            }
            case "kurama": {
                return new ItemStack(AddedItems.SkillLearnerKurama);
            }
            case "tsuchigumo": {
                return new ItemStack(AddedItems.SkillLearnerTsuchigumo);
            }
            case "nara": {
                return new ItemStack(AddedItems.SkillLearnerNara);
            }
            case "sarutobi": {
                return new ItemStack(AddedItems.SkillLearnerSarutobi);
            }
            case "fuma": {
                return new ItemStack(AddedItems.SkillLearnerFuma);
            }
            case "yamanaka": {
                return new ItemStack(AddedItems.SkillLearnerYamanaka);
            }
            case "chinoike": {
                return new ItemStack(AddedItems.SkillLearnerKetsuryugan);
            }
            case "medical": {
                return new ItemStack(AddedItems.SkillLearnerMedical);
            }
            case "taijutsu": {
                return new ItemStack(AddedItems.SkillLearnerTaijutsu);
            }
            case "eightgates": {
                return new ItemStack(AddedItems.SkillLearnerEightGates);
            }
            case "kenjutsu": {
                return new ItemStack(AddedItems.SkillLearnerKenjutsu);
            }
            case "rinneganunlocker": {
                return new ItemStack(AddedItems.RinneganUnlocker);
            }
            case "tailedbeast": {
                return new ItemStack(AddedItems.SkillLearnerTailedBeasts);
            }
            case "snake": {
                return new ItemStack(AddedItems.SkillLearnerSnakes);
            }
        }
        return null;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            options.add("all");
            options.add("known");
            for (String releaseOrClan : ALL_RELEASES_AND_CLANS) {
                options.add(releaseOrClan.toLowerCase());
            }
            return CommandLearner.func_71530_a((String[])args, (String[])options.toArray(new String[0]));
        }
        if (args.length == 2) {
            return CommandLearner.func_71530_a((String[])args, (String[])this.getPlayers());
        }
        return null;
    }

    public String[] getPlayers() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }
}

