/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Commands;

import java.util.List;
import java.util.function.IntConsumer;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncJutsuPointsMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncResetPointsMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncSkillPointsMessage;
import narutodestination.Mathioks.PacketDispatcher;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class CommandPoints
extends CommandBase {
    public String func_71517_b() {
        return "points";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/points <skill/jutsu/reset> <give/set/take> <AMOUNT> [PLAYER]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        int amount;
        if (args.length < 3 || args.length > 4) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String type = args[0].toLowerCase();
        String action = args[1].toLowerCase();
        try {
            amount = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException(args[2] + " is not a number. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = args.length == 4 ? CommandPoints.func_82359_c((ICommandSender)sender, (String)args[3]) : CommandPoints.func_71521_c((ICommandSender)sender);
        ExtendedPlayer props = ExtendedPlayer.get((EntityPlayer)player);
        switch (type) {
            case "skill": {
                this.applyPoints(action, amount, props.getSkillPoints(), props::setSkillPoints);
                PacketDispatcher.sendTo(new SyncSkillPointsMessage((EntityPlayer)player), player);
                break;
            }
            case "jutsu": {
                this.applyPoints(action, amount, props.getJutsuPoints(), props::setJutsuPoints);
                PacketDispatcher.sendTo(new SyncJutsuPointsMessage((EntityPlayer)player), player);
                break;
            }
            case "reset": {
                this.applyPoints(action, amount, props.getResetPoints(), props::setResetPoints);
                PacketDispatcher.sendTo(new SyncResetPointsMessage((EntityPlayer)player), player);
                break;
            }
            default: {
                throw new WrongUsageException("Invalid type: use skill, jutsu, or reset.", new Object[0]);
            }
        }
    }

    private void applyPoints(String action, int amount, int current, IntConsumer setter) {
        switch (action) {
            case "give": {
                setter.accept(current + amount);
                break;
            }
            case "set": {
                setter.accept(amount);
                break;
            }
            case "take": {
                setter.accept(Math.max(0, current - amount));
                break;
            }
            default: {
                throw new WrongUsageException("Invalid action: use give, set, or take.", new Object[0]);
            }
        }
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandPoints.func_71530_a((String[])args, (String[])new String[]{"skill", "jutsu", "reset"});
        }
        if (args.length == 2) {
            return CommandPoints.func_71530_a((String[])args, (String[])new String[]{"give", "set", "take"});
        }
        if (args.length == 4) {
            return CommandPoints.func_71530_a((String[])args, (String[])this.getPlayers());
        }
        return null;
    }

    public String[] getPlayers() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }
}

