/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Commands;

import com.mojang.authlib.GameProfile;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import narutodestination.Mathioks.ExtendedPlayer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandRank
extends CommandBase {
    private static final String[] SCOPES = new String[]{"online", "alltime"};
    private static final Map<String, StatInfo> STAT_MAP = new LinkedHashMap<String, StatInfo>();

    private static void addStat(String id, String nbt, String nice, EnumChatFormatting c) {
        STAT_MAP.put(id, new StatInfo(id, nbt, nice, c));
    }

    public String func_71517_b() {
        return "rank";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender s) {
        return "/rank [online|alltime] [stat] [player]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        block47: {
            boolean allTime = false;
            StatInfo stat = STAT_MAP.get("sp");
            String highlight = sender.func_70005_c_();
            int idx = 0;
            if (idx < args.length && this.isScope(args[idx])) {
                allTime = "alltime".equalsIgnoreCase(args[idx]);
                ++idx;
            }
            if (idx < args.length && STAT_MAP.containsKey(args[idx].toLowerCase())) {
                stat = STAT_MAP.get(args[idx].toLowerCase());
                ++idx;
            }
            if (idx < args.length) {
                highlight = args[idx];
            }
            if (idx + 1 < args.length) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            ExtendedPlayer.saveAll();
            this.prettyHeader(sender, (allTime ? "All-Time" : "Online") + " Top 10 \u2013 " + stat.niceName);
            try (PreparedStatement preparedStatement = ExtendedPlayer.getConnection().prepareStatement("SELECT " + stat.nbtKey + ", player_name from player_data" + (allTime ? "" : this.getWhereClauseWithAllOnline(this.getAllPlayerNames())) + " ORDER BY " + stat.nbtKey + " DESC LIMIT 10");){
                ResultSet rs = preparedStatement.executeQuery();
                boolean highlighted = false;
                int rank = 1;
                while (rs.next()) {
                    int value = rs.getInt(1);
                    String name = rs.getString(2);
                    if (name.equals(highlight)) {
                        highlighted = true;
                        sender.func_145747_a((IChatComponent)this.makeLine(rank, name, value, true, stat));
                    } else {
                        sender.func_145747_a((IChatComponent)this.makeLine(rank, name, value, false, stat));
                    }
                    ++rank;
                }
                if (highlighted) break block47;
                try (PreparedStatement statement = ExtendedPlayer.getConnection().prepareStatement("SELECT " + stat.nbtKey + ", player_name from player_data WHERE player_name = ?");){
                    statement.setString(1, highlight);
                    rs = statement.executeQuery();
                    if (rs.next()) {
                        int value = rs.getInt(1);
                        String name = rs.getString(2);
                        try (PreparedStatement statement2 = ExtendedPlayer.getConnection().prepareStatement("SELECT COUNT(*) + 1 FROM player_data WHERE " + stat.nbtKey + " > ?");){
                            statement2.setInt(1, value);
                            rs = statement2.executeQuery();
                            rank = rs.getInt(1);
                            sender.func_145747_a((IChatComponent)this.makeLine(rank, name, value, true, stat));
                            break block47;
                        }
                    }
                    if (!highlight.equals("Server")) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText("Could not determine the rank for " + highlight));
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                sender.func_145747_a((IChatComponent)new ChatComponentText("Error while reading ranks"));
            }
        }
    }

    String getWhereClauseWithAllOnline(String[] usernames) {
        StringBuilder builder = new StringBuilder();
        builder.append(" WHERE player_name IN (");
        int i = 0;
        for (String user : usernames) {
            ++i;
            builder.append("'");
            builder.append(user);
            builder.append("'");
            if (i == usernames.length) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandRank.func_71530_a((String[])args, (String[])CommandRank.concat(SCOPES, STAT_MAP.keySet()));
        }
        if (args.length == 2) {
            if (this.isScope(args[0])) {
                return CommandRank.func_71530_a((String[])args, (String[])new String[]{String.valueOf(STAT_MAP.keySet())});
            }
            return CommandRank.func_71530_a((String[])args, (String[])this.getAllPlayerNames());
        }
        if (args.length == 3) {
            return CommandRank.func_71530_a((String[])args, (String[])this.getAllPlayerNames());
        }
        return null;
    }

    private String[] getAllPlayerNames() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }

    private boolean isScope(String s) {
        return "online".equalsIgnoreCase(s) || "alltime".equalsIgnoreCase(s);
    }

    private static String[] concat(String[] arr, Collection<String> col) {
        String[] out = new String[arr.length + col.size()];
        System.arraycopy(arr, 0, out, 0, arr.length);
        int i = arr.length;
        for (String s : col) {
            out[i++] = s;
        }
        return out;
    }

    private String resolveName(String uuidTxt, MinecraftServer server) {
        try {
            UUID uuid = UUID.fromString(uuidTxt);
            GameProfile gp = CommandRank.lookupProfile(server, uuid);
            if (gp != null && gp.getName() != null && !gp.getName().isEmpty()) {
                return gp.getName();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uuidTxt;
    }

    private static GameProfile lookupProfile(MinecraftServer srv, UUID uuid) {
        PlayerProfileCache cache = srv.func_152358_ax();
        return cache.func_152652_a(uuid);
    }

    private void prettyHeader(ICommandSender snd, String title) {
        String line = EnumChatFormatting.DARK_GRAY + "\u2500\u2500\u2500\u2500\u2500 " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + title + EnumChatFormatting.DARK_GRAY + " \u2500\u2500\u2500\u2500\u2500";
        snd.func_145747_a((IChatComponent)new ChatComponentText(line));
    }

    private ChatComponentText makeLine(int rank, String name, int value, boolean hi, StatInfo stat) {
        EnumChatFormatting rankCol;
        EnumChatFormatting nameCol = hi ? EnumChatFormatting.AQUA : EnumChatFormatting.WHITE;
        switch (rank) {
            case 1: {
                rankCol = EnumChatFormatting.GOLD;
                break;
            }
            case 2: {
                rankCol = EnumChatFormatting.YELLOW;
                break;
            }
            case 3: {
                rankCol = EnumChatFormatting.RED;
                break;
            }
            default: {
                rankCol = EnumChatFormatting.GRAY;
            }
        }
        String num = new DecimalFormat("#,###").format(value);
        String txt = (hi ? EnumChatFormatting.BOLD.toString() : "") + rankCol + "#" + rank + " " + nameCol + name + EnumChatFormatting.DARK_GRAY + " \u25b8 " + stat.color + num;
        return new ChatComponentText(txt);
    }

    static {
        CommandRank.addStat("sp", "total_stats", "Skill Points", EnumChatFormatting.GREEN);
        CommandRank.addStat("nin", "ninjutsu", "Ninjutsu", EnumChatFormatting.AQUA);
        CommandRank.addStat("tai", "taijutsu", "Taijutsu", EnumChatFormatting.RED);
        CommandRank.addStat("gen", "genjutsu", "Genjutsu", EnumChatFormatting.DARK_PURPLE);
        CommandRank.addStat("ken", "kenjutsu", "Kenjutsu", EnumChatFormatting.BLUE);
        CommandRank.addStat("shuriken", "shurikenjutsu", "Shuriken", EnumChatFormatting.YELLOW);
        CommandRank.addStat("summoning", "summoning", "Summoning", EnumChatFormatting.DARK_GREEN);
        CommandRank.addStat("kin", "kinjutsu", "Kinjutsu", EnumChatFormatting.GOLD);
        CommandRank.addStat("sen", "senjutsu", "Senjutsu", EnumChatFormatting.DARK_AQUA);
    }

    private static class StatInfo {
        final String id;
        final String nbtKey;
        final String niceName;
        final EnumChatFormatting color;

        StatInfo(String i, String n, String nice, EnumChatFormatting c) {
            this.id = i;
            this.nbtKey = n;
            this.niceName = nice;
            this.color = c;
        }
    }
}

