/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Config;

import java.io.File;
import java.util.Random;
import net.minecraftforge.common.config.Configuration;

public class GeneralConfig {
    public static Configuration configuration;
    private static final Random random;
    private static String intelligencePerWMConfig;
    private static int intelligencePerWMStatic;
    public static int maxOtsutsukiHealthBonus;
    public static double otsutsukiSpawnChance;
    public static double chakraChargeSpeedMultiplier;
    public static double senChakraChargeSpeedMultiplier;
    public static boolean allowJutsusDuringChakraCharge;
    public static boolean debuffDuringChakraCharge;
    public static boolean holdChristmasEvent;
    public static boolean holdEasterEvent;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        }
        try {
            configuration.load();
            GeneralConfig.loadConfiguration();
        }
        catch (Exception e) {
            System.err.println("Error loading GeneralConfig!");
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static void reload(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        } else {
            configuration.load();
        }
        GeneralConfig.loadConfiguration();
    }

    private static void loadConfiguration() {
        intelligencePerWMConfig = configuration.get("general", "IntelligencePerWM", "1", "Determines how much intelligence is gained per WM. Can be a static value (e.g., 2) or a range (e.g., 1-3).").getString();
        maxOtsutsukiHealthBonus = configuration.get("general", "MaxOtsutsukiHealthBonus", 500, "Maximum HP bonus from Otsutsuki DNA (+50 per implant, default max 500)").getInt();
        otsutsukiSpawnChance = configuration.get("general", "OtsutsukiSpawnChance", 5.0, "Chance in % that a new player spawns as Otsutsuki (default: 5.0).").getDouble();
        chakraChargeSpeedMultiplier = configuration.get("Chakra", "ChakraChargeSpeedMultiplier", 1.0, "Set the multiplier for the active charge speed of Chakra (default: 1.00).").getDouble();
        senChakraChargeSpeedMultiplier = configuration.get("Chakra", "SenChakraChargeSpeedMultiplier", 1.0, "Set the multiplier for the active charge speed of Sen Chakra (default: 1.00).").getDouble();
        allowJutsusDuringChakraCharge = configuration.get("Chakra", "AllowJutsusDuringChakraCharge", true, "Set to false to prohibit players from using jutsus while charging chakra (default: true).").getBoolean();
        debuffDuringChakraCharge = configuration.get("Chakra", "DebuffDuringChakraCharge", true, "Set to false to remove the slowness effect while charging chakra (default: true).").getBoolean();
        holdChristmasEvent = configuration.get("Events", "HoldChristmasEvent", true, "Set to false to stop Christmas Gifts from dropping during December and to deactivate them (default: true).").getBoolean();
        holdEasterEvent = configuration.get("Events", "HoldEasterEvent", true, "Set to false to stop Easter Eggs from dropping during April and to deactivate them (default: true).").getBoolean();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static int getIntelligencePerWM() {
        String[] range;
        if (intelligencePerWMConfig.contains("-") && (range = intelligencePerWMConfig.split("-")).length == 2) {
            try {
                int min = Integer.parseInt(range[0].trim());
                int max = Integer.parseInt(range[1].trim());
                if (min > max) {
                    throw new IllegalArgumentException("Invalid range: min > max");
                }
                return random.nextInt(max - min + 1) + min;
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid number format in IntelligencePerWM range: " + intelligencePerWMConfig);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid IntelligencePerWM range: " + intelligencePerWMConfig + ". " + e.getMessage());
            }
        }
        try {
            intelligencePerWMStatic = Integer.parseInt(intelligencePerWMConfig.trim());
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid IntelligencePerWM static value: " + intelligencePerWMConfig);
        }
        return intelligencePerWMStatic;
    }

    public static void reload() {
        if (configuration != null) {
            configuration.load();
            GeneralConfig.loadConfiguration();
        }
    }

    static {
        random = new Random();
        intelligencePerWMStatic = 1;
        maxOtsutsukiHealthBonus = 500;
        otsutsukiSpawnChance = 1.0;
        chakraChargeSpeedMultiplier = 1.0;
        senChakraChargeSpeedMultiplier = 1.0;
        allowJutsusDuringChakraCharge = true;
        debuffDuringChakraCharge = true;
        holdChristmasEvent = true;
        holdEasterEvent = true;
    }
}

