/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks;

import java.util.Random;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncEightGatesStageMessage;
import narutodestination.Mathioks.PacketDispatcher;
import narutodestination.Mathioks.packets.DisableEightGatesMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class EightGatesDeactivation {
    private static final Random random = new Random();

    public static void deactivateEightGates(EntityPlayer player, ExtendedPlayer props, int gateLevel, boolean isVoluntary) {
        if (gateLevel <= 0) {
            return;
        }
        props.setEightGatesStage(0);
        if (player.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new DisableEightGatesMessage(isVoluntary));
            return;
        }
        PacketDispatcher.sendTo(new SyncEightGatesStageMessage(player), (EntityPlayerMP)player);
        switch (gateLevel) {
            case 1: {
                EightGatesDeactivation.applyFirstGateConsequences(player, isVoluntary);
                break;
            }
            case 2: {
                EightGatesDeactivation.applySecondGateConsequences(player, isVoluntary);
                break;
            }
            case 3: {
                EightGatesDeactivation.applyThirdGateConsequences(player, isVoluntary);
                break;
            }
            case 4: {
                EightGatesDeactivation.applyFourthGateConsequences(player, isVoluntary);
                break;
            }
            case 5: {
                EightGatesDeactivation.applyFifthGateConsequences(player, isVoluntary);
                break;
            }
            case 6: {
                EightGatesDeactivation.applySixthGateConsequences(player, isVoluntary);
                break;
            }
            case 7: {
                EightGatesDeactivation.applySeventhGateConsequences(player, isVoluntary);
                break;
            }
            case 8: {
                EightGatesDeactivation.applyEighthGateConsequences(player, isVoluntary);
                break;
            }
        }
        String deactivationType = isVoluntary ? "closed" : "forcibly closed";
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Eight Gates: " + EightGatesDeactivation.getGateName(gateLevel) + " " + deactivationType + "!"));
        System.out.println("Eight Gates deactivated for " + player.func_70005_c_() + " - Gate Level: " + gateLevel + " (" + EightGatesDeactivation.getGateName(gateLevel) + "), Voluntary: " + isVoluntary);
    }

    private static void applyFirstGateConsequences(EntityPlayer player, boolean isVoluntary) {
        player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 0));
        player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 0));
        if (!isVoluntary) {
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 60, 0));
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "You feel slightly drained from using the First Gate."));
    }

    private static void applySecondGateConsequences(EntityPlayer player, boolean isVoluntary) {
        player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 400, 0));
        player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 300, 1));
        player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 200, 0));
        float currentHealth = player.func_110143_aJ();
        player.func_70606_j(Math.max(1.0f, currentHealth - 2.0f));
        if (!isVoluntary) {
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 0));
            player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 200, 1));
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Your body aches from the strain of the Second Gate."));
    }

    private static void applyThirdGateConsequences(EntityPlayer player, boolean isVoluntary) {
        player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 600, 1));
        player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 500, 1));
        player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 400, 1));
        player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0));
        float currentHealth = player.func_110143_aJ();
        player.func_70606_j(Math.max(1.0f, currentHealth - 4.0f));
        if (!isVoluntary) {
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 1));
            player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 400, 2));
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Your muscles scream in protest as the Third Gate closes!"));
    }

    private static void applyFourthGateConsequences(EntityPlayer player, boolean isVoluntary) {
        player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 800, 2));
        player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 700, 2));
        player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 600, 2));
        player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 0));
        player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 300, 1));
        float currentHealth = player.func_110143_aJ();
        player.func_70606_j(Math.max(1.0f, currentHealth - 6.0f));
        if (!isVoluntary) {
            player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 100, 0));
            player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 600, 3));
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Intense pain courses through your body as the Fourth Gate snaps shut!"));
    }

    private static void applyFifthGateConsequences(EntityPlayer player, boolean isVoluntary) {
        player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 1000, 3));
        player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 900, 3));
        player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 800, 3));
        player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 400, 0));
        player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 500, 2));
        player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 200, 1));
        float currentHealth = player.func_110143_aJ();
        player.func_70606_j(Math.max(1.0f, currentHealth - 8.0f));
        if (!isVoluntary) {
            player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 300, 1));
            player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 800, 4));
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "Your body convulses as the Fifth Gate's power abandons you!"));
    }

    private static void applySixthGateConsequences(EntityPlayer player, boolean isVoluntary) {
        player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 1200, 4));
        player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 1100, 4));
        player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 1000, 4));
        player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 600, 0));
        player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 700, 3));
        player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 400, 2));
        player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 500, 2));
        float currentHealth = player.func_110143_aJ();
        player.func_70606_j(Math.max(1.0f, currentHealth - 12.0f));
        if (!isVoluntary) {
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 10));
            player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 200, 250));
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "Your vision blurs as your body begins to shut down from the Sixth Gate's toll!"));
    }

    private static void applySeventhGateConsequences(EntityPlayer player, boolean isVoluntary) {
        player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 1500, 5));
        player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 1400, 5));
        player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 1300, 5));
        player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 800, 0));
        player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 900, 4));
        player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 600, 3));
        player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 700, 3));
        player.func_70606_j(1.0f);
        if (random.nextInt(100) < (isVoluntary ? 30 : 60)) {
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 400, 15));
            player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 400, 0));
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 400, 5));
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "You briefly lose consciousness from the overwhelming strain!"));
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "Your body teeters on the brink of collapse as the Seventh Gate's power fades!"));
    }

    private static void applyEighthGateConsequences(EntityPlayer player, boolean isVoluntary) {
        int deathChance;
        int n = deathChance = isVoluntary ? 75 : 95;
        if (random.nextInt(100) < deathChance) {
            player.field_70172_ad = 1;
            player.func_70097_a(DamageSource.field_76377_j, 1.0E7f);
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "" + EnumChatFormatting.BOLD + "The Gate of Death claims its price... your life force has been completely drained."));
            System.out.println("Player " + player.func_70005_c_() + " died from Eighth Gate consequences (Death chance: " + deathChance + "%)");
        } else {
            player.func_70606_j(1.0f);
            player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 2400, 10));
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 2400, 10));
            player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 2400, 10));
            player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 1200, 0));
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 1500, 10));
            player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 1000, 5));
            player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 1200, 5));
            player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 2000, 10));
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 800, 20));
            player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 800, 250));
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "" + EnumChatFormatting.BOLD + "You barely survive the Gate of Death's toll, but your body is completely broken!"));
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + "You have cheated death... this time."));
            System.out.println("Player " + player.func_70005_c_() + " survived Eighth Gate consequences with extreme debuffs (Death chance was: " + deathChance + "%)");
        }
    }

    private static String getGateName(int gateLevel) {
        switch (gateLevel) {
            case 1: {
                return "Gate of Opening";
            }
            case 2: {
                return "Gate of Healing";
            }
            case 3: {
                return "Gate of Life";
            }
            case 4: {
                return "Gate of Pain";
            }
            case 5: {
                return "Gate of Limit";
            }
            case 6: {
                return "Gate of View";
            }
            case 7: {
                return "Gate of Wonder";
            }
            case 8: {
                return "Gate of Death";
            }
        }
        return "Unknown Gate";
    }

    public static void voluntaryDeactivation(EntityPlayer player, ExtendedPlayer props) {
        int currentGate = props.getEightGatesStage();
        if (currentGate > 0) {
            EightGatesDeactivation.deactivateEightGates(player, props, currentGate, true);
        }
    }

    public static void forcedDeactivation(EntityPlayer player, ExtendedPlayer props) {
        int currentGate = props.getEightGatesStage();
        if (currentGate > 0) {
            EightGatesDeactivation.deactivateEightGates(player, props, currentGate, false);
        }
    }
}

