/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.ExtraFunctions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class WikiPageData {
    private static final HashMap<String, WikiPageData> WIKI_PAGES = new HashMap();
    private static final String CONFIG_PATH = "config/NarutoDestination/Wiki/";
    public static final int MAX_IDENT_LENGTH = 50;
    public static final int MAX_HEADER_LENGTH = 255;
    public static final int MAX_CONTENT_LENGTH = 20000;
    public static final int MAX_BUTTON_LENGTH = 5000;
    private final List<ButtonData> buttonDataList = new ArrayList<ButtonData>();
    private final List<SubSection> subSections = new ArrayList<SubSection>();
    private String header;
    private String identifier;

    public static void addWikiPage(String name, WikiPageData wikiPage) {
        System.out.println("[WIKI] Registered wiki page with identifier: " + name);
        WIKI_PAGES.put(name.toLowerCase(), wikiPage);
    }

    public static void clearPages() {
        System.out.println("[WIKI] Clearing wiki pages");
        WIKI_PAGES.clear();
    }

    public static WikiPageData getWikiPageWithName(String name) {
        return WIKI_PAGES.get(name.toLowerCase());
    }

    public static Collection<WikiPageData> getAllPages() {
        return WIKI_PAGES.values();
    }

    public static void loadPagesFromConfigs() {
        WikiPageData.clearPages();
        File dir = new File(CONFIG_PATH);
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            for (File configFile : directoryListing) {
                try {
                    WikiPageData pageData = WikiPageData.loadWikiPageFromConfig(configFile);
                    if (!WikiPageData.checkWikiPageDataValid(pageData)) {
                        System.out.println("[WIKI] Wiki config: " + configFile.getAbsolutePath() + " is not valid");
                        continue;
                    }
                    WIKI_PAGES.put(pageData.identifier, pageData);
                    System.out.println("[WIKI] Wiki config: " + configFile.getAbsoluteFile() + " loaded successfully with identifier " + pageData.identifier);
                }
                catch (Exception e) {
                    System.out.println("[WIKI] Failed to load wiki config: " + configFile.getAbsolutePath());
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    public static WikiPageData loadWikiPageFromConfig(File file) {
        ConfigCategory subsectionCategory;
        Configuration config = new Configuration(file);
        config.load();
        WikiPageData pageData = new WikiPageData();
        pageData.header = config.get("general", "Header", "Wiki Page").getString();
        pageData.identifier = config.get("general", "Identifier", "").getString();
        ConfigCategory buttonCategory = config.getCategory("button");
        if (buttonCategory != null) {
            for (ConfigCategory subCategory : buttonCategory.getChildren()) {
                String label = subCategory.get("Label").getString();
                String target = subCategory.get("Target").getString();
                String alignment = subCategory.get("Alignment").getString();
                pageData.buttonDataList.add(new ButtonData(label, target, Alignment.valueOf(alignment.toUpperCase())));
            }
        }
        if ((subsectionCategory = config.getCategory("subsection")) != null) {
            for (ConfigCategory subCategory : subsectionCategory.getChildren()) {
                String title = subCategory.get("Title").getString();
                String content = subCategory.get("Content").getString();
                String titleAlignment = subCategory.get("TitleAlignment").getString();
                String contentAlignment = subCategory.get("ContentAlignment").getString();
                pageData.subSections.add(new SubSection(title, content, Alignment.valueOf(titleAlignment.toUpperCase()), Alignment.valueOf(contentAlignment.toUpperCase())));
            }
        }
        return pageData;
    }

    public static boolean checkWikiPageDataValid(WikiPageData pageData) {
        if (!pageData.identifier.matches("[a-zA-Z0-9_]+")) {
            System.out.println("[WIKI] Identifier is not valid. Only letters, numbers and underscores allowed");
            return false;
        }
        if (pageData.identifier.length() > 50) {
            System.out.println("[WIKI] Identifier is longer than max limit of 50");
            return false;
        }
        if (pageData.header.length() > 255) {
            System.out.println("[WIKI] Header is longer than max limit of 255");
            return false;
        }
        int subSectionLengths = 0;
        for (SubSection subsection : pageData.subSections) {
            subSectionLengths += subsection.title.length();
            subSectionLengths += subsection.content.length();
        }
        if (subSectionLengths > 20000) {
            System.out.println("[WIKI] Content is longer than max limit of 50");
            return false;
        }
        int buttonsLengths = 0;
        for (ButtonData buttonData : pageData.buttonDataList) {
            buttonsLengths += buttonData.label.length();
            buttonsLengths += buttonData.target.length();
        }
        if (buttonsLengths > 5000) {
            System.out.println("[WIKI] Button content is longer than max limit of 5000");
            return false;
        }
        return true;
    }

    public List<ButtonData> getButtonDataList() {
        return this.buttonDataList;
    }

    public List<SubSection> getSubSections() {
        return this.subSections;
    }

    public String getHeader() {
        return this.header;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public static class ButtonData {
        public final String label;
        public final String target;
        public final Alignment alignment;

        ButtonData(String label, String target, Alignment alignment) {
            this.label = label;
            this.target = target;
            this.alignment = alignment;
        }
    }

    public static class SubSection {
        public final String title;
        public final String content;
        public final Alignment titleAlignment;
        public final Alignment contentAlignment;

        SubSection(String title, String content, Alignment titleAlignment, Alignment contentAlignment) {
            this.title = title;
            this.content = content;
            this.titleAlignment = titleAlignment;
            this.contentAlignment = contentAlignment;
        }
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

