/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.GameMenu.Wiki;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URI;
import java.util.List;
import narutodestination.Mathioks.ExtraFunctions.WikiPageData;
import narutodestination.Mathioks.GameMenu.CustomEscMenu;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WikiGuiPage
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("tm:textures/menu/background.jpg");
    private static final int defaultButtonSpacing = 30;
    private int scrollOffset = 0;
    private int maxScroll;
    private int nextButtonId = 1;
    private final WikiPageData pageData;

    public WikiGuiPage(WikiPageData pageData) {
        this.pageData = pageData;
    }

    public void func_73866_w_() {
        int mainPageButtonY;
        int mainPageButtonX;
        int mainPageButtonHeight;
        int mainPageButtonWidth;
        this.field_146292_n.clear();
        if (!"Wiki Page".equalsIgnoreCase(this.pageData.getHeader())) {
            mainPageButtonWidth = 80;
            mainPageButtonHeight = 20;
            mainPageButtonX = this.field_146294_l - mainPageButtonWidth - 10;
            mainPageButtonY = 10;
            this.field_146292_n.add(new GuiButton(0, mainPageButtonX, mainPageButtonY, mainPageButtonWidth, mainPageButtonHeight, "Main Page"));
        } else {
            mainPageButtonWidth = 80;
            mainPageButtonHeight = 20;
            mainPageButtonX = this.field_146294_l - mainPageButtonWidth - 10;
            mainPageButtonY = 10;
            this.field_146292_n.add(new GuiButton(0, mainPageButtonX, mainPageButtonY, mainPageButtonWidth, mainPageButtonHeight, "Exit"));
        }
        int posX = this.field_146294_l / 2 - 100;
        for (WikiPageData.ButtonData data : this.pageData.getButtonDataList()) {
            GuiButton button = data.target.startsWith("http") ? new UrlButton(this.nextButtonId++, data.label, data.target) : new PageButton(this.nextButtonId++, data.label, data.target);
            button.field_146128_h = posX;
            this.field_146292_n.add(button);
        }
        this.maxScroll = 0;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            this.scrollOffset -= delta / 10;
            this.scrollOffset = Math.max(0, Math.min(this.maxScroll, this.scrollOffset));
        }
    }

    private int calculateSubsectionsHeight() {
        int currentY = 80;
        currentY += 60;
        for (WikiPageData.SubSection section : this.pageData.getSubSections()) {
            currentY += 20;
            for (String line : this.wrapText(section.content, this.field_146294_l - 40)) {
                currentY += 15;
            }
            currentY += 25;
        }
        return currentY;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && !"Wiki Page".equalsIgnoreCase(this.pageData.getHeader())) {
            this.field_146297_k.func_147108_a((GuiScreen)new WikiGuiPage(WikiPageData.getWikiPageWithName("main")));
        } else if (button.field_146127_k == 0 && "Wiki Page".equalsIgnoreCase(this.pageData.getHeader())) {
            this.field_146297_k.func_147108_a((GuiScreen)new CustomEscMenu());
        } else {
            int id = 1;
            for (WikiPageData.ButtonData data : this.pageData.getButtonDataList()) {
                if (id == button.field_146127_k) {
                    if (button instanceof UrlButton) {
                        this.openUrl(data.target);
                    } else {
                        WikiPageData otherPage = WikiPageData.getWikiPageWithName(data.target);
                        if (otherPage == null) {
                            System.out.println("Button pointing to not existing target");
                        } else {
                            this.field_146297_k.func_147108_a((GuiScreen)new WikiGuiPage(otherPage));
                        }
                    }
                    return;
                }
                ++id;
            }
        }
    }

    private void openUrl(String url) {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Object object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            clazz.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(background);
        for (int x = 0; x < this.field_146294_l; x += 16) {
            for (int y = 0; y < this.field_146295_m; y += 16) {
                this.func_73729_b(x, y, 0, 0, 16, 16);
            }
        }
        int currentY = 30 - this.scrollOffset;
        this.drawScaledCenteredString(this.pageData.getHeader(), this.field_146294_l / 2, currentY, 2.0f, 0xFF0000);
        currentY += 60;
        for (WikiPageData.SubSection section : this.pageData.getSubSections()) {
            int titleX;
            switch (section.titleAlignment) {
                case LEFT: {
                    titleX = 20;
                    break;
                }
                case RIGHT: {
                    titleX = this.field_146294_l - 20;
                    break;
                }
                default: {
                    titleX = this.field_146294_l / 2;
                }
            }
            this.drawScaledString(section.title, titleX, currentY, 1.3f, 16766720, section.titleAlignment);
            currentY += 20;
            for (String line : this.wrapText(section.content, this.field_146294_l - 40)) {
                this.drawString(line, currentY, section.contentAlignment);
                currentY += 15;
            }
            currentY += 25;
        }
        for (WikiPageData.SubSection obj : this.field_146292_n) {
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (button.field_146127_k == 0) continue;
            button.field_146129_i = currentY;
            currentY += 30;
        }
        this.maxScroll = Math.max(0, currentY + this.scrollOffset - this.field_146295_m + 20);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawScaledString(String text, int baseX, int y, float scale, int color, WikiPageData.Alignment alignment) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)baseX, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        int textWidth = this.field_146289_q.func_78256_a(text);
        int offsetX = 0;
        if (alignment == WikiPageData.Alignment.LEFT) {
            offsetX = 0;
        } else if (alignment == WikiPageData.Alignment.CENTER) {
            offsetX = -textWidth / 2;
        } else if (alignment == WikiPageData.Alignment.RIGHT) {
            offsetX = -textWidth;
        }
        this.field_146289_q.func_78276_b(text, offsetX, 0, color);
        GL11.glPopMatrix();
    }

    private void drawScaledCenteredString(String text, int x, int y, float scale, int color) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        int scaledX = -this.field_146289_q.func_78256_a(text) / 2;
        this.field_146289_q.func_78276_b(text, scaledX, 0, color);
        GL11.glPopMatrix();
    }

    private void drawString(String text, int y, WikiPageData.Alignment alignment) {
        int x = alignment == WikiPageData.Alignment.LEFT ? 20 : (alignment == WikiPageData.Alignment.RIGHT ? this.field_146294_l - this.field_146289_q.func_78256_a(text) - 20 : this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2);
        this.field_146289_q.func_78276_b(text, x, y, 0xFFFFFF);
    }

    private List<String> wrapText(String text, int maxWidth) {
        return this.field_146289_q.func_78271_c(text, maxWidth);
    }

    private static class UrlButton
    extends GuiButton {
        final String url;

        UrlButton(int id, String label, String url) {
            super(id, 0, 0, 200, 20, label);
            this.url = url;
        }
    }

    private static class PageButton
    extends GuiButton {
        final String target;

        PageButton(int id, String label, String target) {
            super(id, 0, 0, 200, 20, label);
            this.target = target;
        }
    }
}

