/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.NPC.ConfigurableMobs;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import narutodestination.Mathioks.AddedItems;
import narutodestination.Mathioks.NPC.ConfigurableMobs.JutsuAttack;
import narutodestination.Mathioks.NPC.ConfigurableMobs.NinjaMobConfig;
import narutodestination.Mathioks.NPC.EntityNinja;
import narutodestination.Mathioks.item.ShurikenEntity;
import narutodestination.Mathioks.item.ShurikenSmallEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class ConfigurableNinjaMob
extends EntityNinja
implements IRangedAttackMob {
    protected final NinjaMobConfig config;
    protected final EntityAIArrowAttack aiArrowAttack;
    protected final List<EntityAIAttackOnCollide> aiAttackTasks = new ArrayList<EntityAIAttackOnCollide>();
    protected int jutsuTimer = 0;
    protected final Random field_70146_Z = new Random();

    public ConfigurableNinjaMob(World world, NinjaMobConfig config) {
        super(world);
        this.config = config;
        this.field_70728_aV = config.getExperienceValue();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (config.shouldAttackPlayers()) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        }
        if (config.shouldAttackTameables()) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityTameable.class, 0, true));
        }
        if (config.shouldAttackMobs()) {
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true));
        }
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, config.getLeapStrength()));
        this.aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.25, 20, 60, config.getRangedAttackRange());
        if (config.shouldAttackPlayers()) {
            EntityAIAttackOnCollide attackPlayer = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2, false);
            this.aiAttackTasks.add(attackPlayer);
        }
        if (config.shouldAttackTameables()) {
            EntityAIAttackOnCollide attackTameable = new EntityAIAttackOnCollide((EntityCreature)this, EntityTameable.class, 1.2, false);
            this.aiAttackTasks.add(attackTameable);
        }
        if (config.shouldAttackMobs()) {
            EntityAIAttackOnCollide attackMob = new EntityAIAttackOnCollide((EntityCreature)this, EntityMob.class, 1.2, false);
            this.aiAttackTasks.add(attackMob);
        }
        this.equipRandomWeapon();
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
        this.func_70105_a(0.6f, 1.8f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
        if (this.config.getSkinVariants() > 0) {
            this.setTameSkin(this.field_70170_p.field_73012_v.nextInt(this.config.getSkinVariants()));
        }
    }

    protected boolean func_70650_aV() {
        return true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.config.getFollowRange());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.config.getHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.config.getMeleeDamage());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.config.getMovementSpeed());
    }

    protected void equipRandomWeapon() {
        List<NinjaMobConfig.WeaponChoice> weapons = this.config.getPossibleWeapons();
        if (weapons.isEmpty()) {
            return;
        }
        int totalWeight = 0;
        for (NinjaMobConfig.WeaponChoice weapon : weapons) {
            totalWeight += weapon.weight;
        }
        int random = this.field_70146_Z.nextInt(totalWeight);
        int currentWeight = 0;
        for (NinjaMobConfig.WeaponChoice weapon : weapons) {
            if (random >= (currentWeight += weapon.weight)) continue;
            this.func_70062_b(0, weapon.itemStack.func_77946_l());
            break;
        }
    }

    public void setCombatTask() {
        boolean isRangedWeapon;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        for (EntityAIAttackOnCollide attackTask : this.aiAttackTasks) {
            this.field_70714_bg.func_85156_a((EntityAIBase)attackTask);
        }
        ItemStack itemstack = this.func_70694_bm();
        boolean bl = isRangedWeapon = itemstack != null && (itemstack.func_77973_b() == Items.field_151031_f || itemstack.func_77973_b() == AddedItems.ShurikenItem || itemstack.func_77973_b() == AddedItems.ShurikenSmallItem);
        if (isRangedWeapon && this.config.canUseRangedAttacks()) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        } else if (this.config.canUseMeleeAttacks()) {
            int taskId = 4;
            for (EntityAIAttackOnCollide attackTask : this.aiAttackTasks) {
                this.field_70714_bg.func_75776_a(taskId++, (EntityAIBase)attackTask);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.jutsuTimer > 0) {
            --this.jutsuTimer;
        }
        if (this.config.getCustomName() != null && !this.func_94056_bM()) {
            this.func_94058_c(this.config.getCustomName());
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("CatType", this.getTameSkin());
        tag.func_74768_a("JutsuTimer", this.jutsuTimer);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setTameSkin(tag.func_74762_e("CatType"));
        this.jutsuTimer = tag.func_74762_e("JutsuTimer");
    }

    public int getTameSkin() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setTameSkin(int skin) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)skin));
    }

    protected float func_70647_i() {
        return 0.7f;
    }

    protected String func_70621_aR() {
        return "";
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity target) {
        boolean hit;
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (target instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
        }
        if (this.jutsuTimer == 0 && !this.config.getJutsuAttacks().isEmpty()) {
            this.executeRandomJutsu(target);
        }
        if ((hit = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) && knockback > 0) {
            target.func_70024_g(-Math.sin((double)this.field_70177_z * Math.PI / 180.0) * (double)knockback * 0.5, 0.1, Math.cos((double)this.field_70177_z * Math.PI / 180.0) * (double)knockback * 0.5);
            this.field_70159_w *= 0.6;
            this.field_70179_y *= 0.6;
        }
        return hit;
    }

    protected void executeRandomJutsu(Entity target) {
        List<JutsuAttack> jutsuList = this.config.getJutsuAttacks();
        if (jutsuList.isEmpty()) {
            return;
        }
        int totalWeight = 0;
        for (JutsuAttack jutsu : jutsuList) {
            totalWeight += jutsu.getWeight();
        }
        int random = this.field_70146_Z.nextInt(totalWeight);
        int currentWeight = 0;
        for (JutsuAttack jutsu : jutsuList) {
            if (random >= (currentWeight += jutsu.getWeight())) continue;
            jutsu.execute(this.field_70170_p, (EntityLivingBase)this, target);
            this.jutsuTimer = jutsu.getCooldown();
            break;
        }
    }

    public void func_82196_d(EntityLivingBase target, float damage) {
        ItemStack weapon = this.func_70694_bm();
        if (weapon != null) {
            if (weapon.func_77973_b() == Items.field_151031_f) {
                this.shootArrow(target, damage);
            } else if (weapon.func_77973_b() == AddedItems.ShurikenItem) {
                this.shootShuriken(target, damage);
            } else if (weapon.func_77973_b() == AddedItems.ShurikenSmallItem) {
                this.shootSmallShuriken(target, damage);
            }
        }
        if (this.jutsuTimer == 0 && !this.config.getJutsuAttacks().isEmpty()) {
            this.executeRandomJutsu((Entity)target);
        }
    }

    protected void shootArrow(EntityLivingBase target, float damage) {
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.6f, (float)(14 - this.field_70170_p.field_73013_u.func_151525_a() * 4));
        this.applyEnchantments(arrow, damage);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    protected void shootShuriken(EntityLivingBase target, float damage) {
        ShurikenEntity shuriken = new ShurikenEntity(this.field_70170_p, (EntityLivingBase)this, target, 2.0f, 14 - this.field_70170_p.field_73013_u.func_151525_a() * 4);
        this.applyEnchantments(shuriken, damage);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)shuriken);
    }

    protected void shootSmallShuriken(EntityLivingBase target, float damage) {
        ShurikenSmallEntity shuriken = new ShurikenSmallEntity(this.field_70170_p, (EntityLivingBase)this, target, 2.0f, 14 - this.field_70170_p.field_73013_u.func_151525_a() * 4);
        this.applyEnchantments(shuriken, damage);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)shuriken);
    }

    protected void applyEnchantments(EntityArrow projectile, float baseDamage) {
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        projectile.func_70239_b((double)(baseDamage * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
        if (power > 0) {
            projectile.func_70239_b(projectile.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            projectile.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm()) > 0) {
            projectile.func_70015_d(10);
        }
    }

    protected void applyEnchantments(ShurikenEntity projectile, float baseDamage) {
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        projectile.func_70239_b((double)(baseDamage * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
        if (power > 0) {
            projectile.func_70239_b(projectile.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            projectile.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm()) > 0) {
            projectile.func_70015_d(10);
        }
    }

    protected void applyEnchantments(ShurikenSmallEntity projectile, float baseDamage) {
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        projectile.func_70239_b((double)(baseDamage * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
        if (power > 0) {
            projectile.func_70239_b(projectile.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            projectile.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm()) > 0) {
            projectile.func_70015_d(10);
        }
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        super.func_70628_a(recentlyHit, lootingLevel);
        for (NinjaMobConfig.DropEntry drop : this.config.getDrops()) {
            if (!(this.field_70146_Z.nextFloat() < drop.chance)) continue;
            int amount = drop.minAmount + this.field_70146_Z.nextInt(drop.maxAmount - drop.minAmount + 1);
            this.func_145779_a(drop.item, amount);
        }
    }

    protected void func_70069_a(float distance) {
    }
}

