/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.SkillLearners;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import narutodestination.Mathioks.Config.LearnerConfig;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncByakuganSizeMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncChakraExperienceMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncJutsuPointsMessage;
import narutodestination.Mathioks.ExtraFunctions.SynctenseiganMessage;
import narutodestination.Mathioks.Final.JutsuItem;
import narutodestination.Mathioks.PacketDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class BaseSkillLearner
extends Item {
    private static long lastConfigReload = System.currentTimeMillis();
    public static final Set<Class<? extends BaseSkillLearner>> REGISTERED_LEARNERS = new HashSet<Class<? extends BaseSkillLearner>>();
    protected List<Object> progression;

    protected static void register(Class<? extends BaseSkillLearner> clazz) {
        REGISTERED_LEARNERS.add(clazz);
    }

    public BaseSkillLearner() {
        this.func_77656_e(30);
        this.field_77777_bU = 1;
        this.progression = new ArrayList<Object>();
        lastConfigReload = System.currentTimeMillis();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && this.isOwner(stack, player)) {
            if (stack.field_77990_d.func_74767_n("IsMastered")) {
                ExtendedPlayer props = ExtendedPlayer.get(player);
                props.setChakraExperience(props.getChakraExperience() + 10);
                PacketDispatcher.sendTo(new SyncChakraExperienceMessage(player), (EntityPlayerMP)player);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + "This skill learner is now complete and will be removed."));
                --stack.field_77994_a;
                return stack;
            }
            this.handleLearning(stack, player);
        } else if (!this.isOwner(stack, player)) {
            player.func_146105_b((IChatComponent)new ChatComponentText("You are not the owner of this item"));
        }
        return stack;
    }

    public boolean isOwner(ItemStack stack, EntityPlayer player) {
        return stack.field_77990_d != null && stack.field_77990_d.func_74779_i("OwnerUUID").equals(player.func_110124_au().toString());
    }

    private void handleLearning(ItemStack stack, EntityPlayer player) {
        ExtendedPlayer props = ExtendedPlayer.get(player);
        Object nextItem = this.getNextProgression(stack);
        if (nextItem == null) {
            return;
        }
        int completedCount = stack.field_77990_d.func_74762_e("CompletedCount");
        if (player.field_71075_bZ.field_75098_d) {
            if (nextItem instanceof Jutsu) {
                Jutsu jutsu = (Jutsu)nextItem;
                if (jutsu.canLearn(player) && this.hasInventorySpace(player)) {
                    player.field_71071_by.func_70441_a(new ItemStack(jutsu.jutsuItem));
                    player.func_146105_b((IChatComponent)new ChatComponentText("[Creative] You Learned: " + jutsu.description));
                    this.updateProgression(stack, completedCount + 1, player);
                } else if (!jutsu.canLearn(player)) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You do not meet the requirements to learn " + jutsu.description + "."));
                }
            } else if (nextItem instanceof Mode) {
                Mode mode = (Mode)nextItem;
                if (mode.canLearn(player)) {
                    mode.unlock(player);
                    player.func_146105_b((IChatComponent)new ChatComponentText("[Creative] You unlocked: " + mode.description));
                    this.updateProgression(stack, completedCount + 1, player);
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You do not meet the requirements to unlock " + mode.description + "."));
                }
            }
        } else if (nextItem instanceof Jutsu) {
            this.learnJutsu(stack, player, props, (Jutsu)nextItem, completedCount);
        } else if (nextItem instanceof Mode) {
            this.learnMode(stack, player, props, (Mode)nextItem, completedCount);
        }
    }

    private Object getNextProgression(ItemStack stack) {
        List<Object> filteredProgression;
        int completedCount = stack.field_77990_d.func_74762_e("CompletedCount");
        if (completedCount < (filteredProgression = this.getFilteredProgression()).size()) {
            return filteredProgression.get(completedCount);
        }
        return null;
    }

    private List<Object> getFilteredProgression() {
        ArrayList<Object> filtered = new ArrayList<Object>();
        for (Object progressionItem : this.progression) {
            if (progressionItem instanceof Jutsu) {
                Jutsu jutsu = (Jutsu)progressionItem;
                if (jutsu.jutsuItem instanceof JutsuItem && ((JutsuItem)jutsu.jutsuItem).isJutsuBanned() || !LearnerConfig.isProgressionEnabled(((Object)((Object)this)).getClass(), jutsu.description)) {
                    continue;
                }
            } else if (progressionItem instanceof Mode) {
                Mode mode = (Mode)progressionItem;
                if (!LearnerConfig.isProgressionEnabled(((Object)((Object)this)).getClass(), mode.description)) continue;
            }
            filtered.add(progressionItem);
        }
        return filtered;
    }

    public void learnJutsu(ItemStack stack, EntityPlayer player, ExtendedPlayer props, Jutsu jutsu, int level) {
        if (jutsu.canLearn(player)) {
            int configuredCost = LearnerConfig.getProgressionCost(((Object)((Object)this)).getClass(), jutsu.description, jutsu.jpCost);
            if (props.getJutsuPoints() >= configuredCost && this.hasInventorySpace(player)) {
                player.field_71071_by.func_70441_a(new ItemStack(jutsu.jutsuItem));
                player.func_146105_b((IChatComponent)new ChatComponentText("You Learned: " + jutsu.description));
                props.setJutsuPoints(props.getJutsuPoints() - configuredCost);
                PacketDispatcher.sendTo(new SyncJutsuPointsMessage(player), (EntityPlayerMP)player);
                this.updateProgression(stack, level + 1, player);
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText("You do not have enough Jutsu Points for " + jutsu.description + ". Required: " + configuredCost + " JP"));
            }
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You do not meet the requirements to learn " + jutsu.description + "."));
        }
    }

    public void learnMode(ItemStack stack, EntityPlayer player, ExtendedPlayer props, Mode mode, int level) {
        if (mode.canLearn(player)) {
            int configuredCost = LearnerConfig.getProgressionCost(((Object)((Object)this)).getClass(), mode.description, mode.jpCost);
            if (props.getJutsuPoints() >= configuredCost) {
                mode.unlock(player);
                player.func_146105_b((IChatComponent)new ChatComponentText("You unlocked: " + mode.description));
                props.setJutsuPoints(props.getJutsuPoints() - configuredCost);
                PacketDispatcher.sendTo(new SyncJutsuPointsMessage(player), (EntityPlayerMP)player);
                this.updateProgression(stack, level + 1, player);
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText("You do not have enough Jutsu Points for " + mode.description + ". Required: " + configuredCost + " JP"));
            }
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You do not meet the requirements to unlock " + mode.description + "."));
        }
    }

    private void updateProgression(ItemStack stack, int nextLevel, EntityPlayer player) {
        stack.field_77990_d.func_74768_a("CompletedCount", nextLevel);
        List<Object> filteredProgression = this.getFilteredProgression();
        if (nextLevel >= filteredProgression.size()) {
            player.func_146105_b((IChatComponent)new ChatComponentText("You have mastered this skill learner!"));
            stack.field_77990_d.func_74757_a("IsMastered", true);
        }
    }

    private boolean hasInventorySpace(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            return true;
        }
        player.func_146105_b((IChatComponent)new ChatComponentText("You need free space in your inventory"));
        return false;
    }

    private void syncModeChanges(EntityPlayer player) {
        PacketDispatcher.sendTo(new SyncByakuganSizeMessage(player), (EntityPlayerMP)player);
        PacketDispatcher.sendTo(new SynctenseiganMessage(player), (EntityPlayerMP)player);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        this.initializeItem(stack, player);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("OwnerUUID")) {
                this.initializeItem(itemStack, player);
                if (!world.field_72995_K) {
                    this.writeToNBT(itemStack.field_77990_d);
                    itemStack.field_77990_d.func_74772_a("lastConfigReload", lastConfigReload);
                }
            } else if (!world.field_72995_K && itemStack.field_77990_d.func_74763_f("lastConfigReload") < lastConfigReload) {
                this.writeToNBT(itemStack.field_77990_d);
                itemStack.field_77990_d.func_74772_a("lastConfigReload", lastConfigReload);
            }
            if (!world.field_72995_K) {
                List<Object> filteredProgression = this.getFilteredProgression();
                int maxDamage = filteredProgression.size();
                if (this.func_77612_l() != maxDamage) {
                    this.func_77656_e(maxDamage);
                }
                if (itemStack.field_77990_d != null) {
                    int completedCount = itemStack.field_77990_d.func_74762_e("CompletedCount");
                    if (completedCount > filteredProgression.size()) {
                        completedCount = filteredProgression.size();
                        itemStack.field_77990_d.func_74768_a("CompletedCount", completedCount);
                        if (completedCount >= filteredProgression.size() && !itemStack.field_77990_d.func_74767_n("IsMastered")) {
                            itemStack.field_77990_d.func_74757_a("IsMastered", true);
                        }
                    }
                    if (itemStack.func_77960_j() != completedCount) {
                        itemStack.func_77964_b(completedCount);
                    }
                }
            }
        }
    }

    protected void initializeItem(ItemStack stack, EntityPlayer player) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("CompletedCount", 0);
        }
        if (!stack.field_77990_d.func_74764_b("OwnerUUID")) {
            stack.field_77990_d.func_74778_a("OwnerUUID", player.func_110124_au().toString());
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList progressionList = new NBTTagList();
        for (Object progressionItem : this.progression) {
            NBTTagCompound progressionTag = new NBTTagCompound();
            if (progressionItem instanceof Jutsu) {
                Jutsu jutsu = (Jutsu)progressionItem;
                progressionTag.func_74778_a("type", "Jutsu");
                progressionTag.func_74778_a("description", jutsu.description);
                progressionTag.func_74768_a("defaultCost", jutsu.jpCost);
                progressionTag.func_74768_a("cost", LearnerConfig.getProgressionCost(((Object)((Object)this)).getClass(), jutsu.description, jutsu.jpCost));
                progressionTag.func_74757_a("enabled", LearnerConfig.isProgressionEnabled(((Object)((Object)this)).getClass(), jutsu.description));
                progressionTag.func_74757_a("banned", jutsu.jutsuItem instanceof JutsuItem && ((JutsuItem)jutsu.jutsuItem).isJutsuBanned());
            } else if (progressionItem instanceof Mode) {
                Mode mode = (Mode)progressionItem;
                progressionTag.func_74778_a("type", "Mode");
                progressionTag.func_74778_a("description", mode.description);
                progressionTag.func_74768_a("defaultCost", mode.jpCost);
                progressionTag.func_74768_a("cost", LearnerConfig.getProgressionCost(((Object)((Object)this)).getClass(), mode.description, mode.jpCost));
                progressionTag.func_74757_a("enabled", LearnerConfig.isProgressionEnabled(((Object)((Object)this)).getClass(), mode.description));
                progressionTag.func_74757_a("banned", false);
            }
            progressionList.func_74742_a((NBTBase)progressionTag);
        }
        compound.func_74782_a("ProgressionData", (NBTBase)progressionList);
        int enabledCount = 0;
        for (int i = 0; i < progressionList.func_74745_c(); ++i) {
            NBTTagCompound tag = progressionList.func_150305_b(i);
            if (!tag.func_74767_n("enabled") || tag.func_74767_n("banned")) continue;
            ++enabledCount;
        }
        compound.func_74768_a("EnabledProgressionCount", enabledCount);
    }

    public void readFromNBT(NBTTagCompound compound) {
    }

    public static void forceConfigReload() {
        lastConfigReload = System.currentTimeMillis();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        NBTTagCompound progressionTag;
        int i;
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("CompletedCount", 0);
            stack.field_77990_d.func_74778_a("OwnerUUID", "");
        }
        this.readFromNBT(stack.field_77990_d);
        int completedCount = stack.field_77990_d.func_74762_e("CompletedCount");
        if (stack.field_77990_d.func_74767_n("IsMastered")) {
            list.add(EnumChatFormatting.GOLD + "Next: +10 XP");
        } else {
            NBTTagList progressionList = stack.field_77990_d.func_150295_c("ProgressionData", 10);
            if (progressionList != null && progressionList.func_74745_c() > 0) {
                int enabledIndex = 0;
                boolean foundNext = false;
                for (i = 0; i < progressionList.func_74745_c(); ++i) {
                    progressionTag = progressionList.func_150305_b(i);
                    boolean enabled = progressionTag.func_74767_n("enabled");
                    boolean banned = progressionTag.func_74767_n("banned");
                    if (!enabled || banned) continue;
                    if (enabledIndex == completedCount) {
                        String type = progressionTag.func_74779_i("type");
                        String description = progressionTag.func_74779_i("description");
                        int cost = progressionTag.func_74762_e("cost");
                        list.add(EnumChatFormatting.GOLD + (type.equals("Jutsu") ? "Learn: " : "Unlock: ") + description);
                        list.add(EnumChatFormatting.DARK_RED + "Cost: " + cost + " JP");
                        foundNext = true;
                        break;
                    }
                    ++enabledIndex;
                }
                if (!foundNext) {
                    list.add(EnumChatFormatting.GRAY + "No more progressions available");
                }
            } else {
                int configuredCost;
                Object nextProgression = this.getNextProgression(stack);
                if (nextProgression instanceof Jutsu) {
                    Jutsu jutsu = (Jutsu)nextProgression;
                    configuredCost = LearnerConfig.getProgressionCost(((Object)((Object)this)).getClass(), jutsu.description, jutsu.jpCost);
                    list.add(EnumChatFormatting.GOLD + "Learn: " + jutsu.description);
                    list.add(EnumChatFormatting.DARK_RED + "Cost: " + configuredCost + " JP");
                } else if (nextProgression instanceof Mode) {
                    Mode mode = (Mode)nextProgression;
                    configuredCost = LearnerConfig.getProgressionCost(((Object)((Object)this)).getClass(), mode.description, mode.jpCost);
                    list.add(EnumChatFormatting.GOLD + "Unlock: " + mode.description);
                    list.add(EnumChatFormatting.DARK_RED + "Cost: " + configuredCost + " JP");
                }
            }
        }
        if (flag && stack.field_77990_d.func_74764_b("EnabledProgressionCount")) {
            int enabledCount = stack.field_77990_d.func_74762_e("EnabledProgressionCount");
            list.add(EnumChatFormatting.DARK_GRAY + "Progress: " + completedCount + "/" + enabledCount);
            NBTTagList progressionList = stack.field_77990_d.func_150295_c("ProgressionData", 10);
            if (progressionList != null) {
                int disabledCount = 0;
                for (i = 0; i < progressionList.func_74745_c(); ++i) {
                    progressionTag = progressionList.func_150305_b(i);
                    if (progressionTag.func_74767_n("enabled") && !progressionTag.func_74767_n("banned")) continue;
                    ++disabledCount;
                }
                if (disabledCount > 0) {
                    list.add(EnumChatFormatting.RED + "" + disabledCount + " progressions disabled");
                }
            }
        }
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("OwnerUUID")) {
            String ownerUUID = stack.field_77990_d.func_74779_i("OwnerUUID");
            try {
                EntityPlayer owner = player.field_70170_p.func_152378_a(UUID.fromString(ownerUUID));
                if (owner != null) {
                    list.add(EnumChatFormatting.GRAY + "Owner: " + owner.getDisplayName());
                } else {
                    list.add(EnumChatFormatting.GRAY + "Owner: Unknown");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("EnabledProgressionCount")) {
            int completedCount = stack.field_77990_d.func_74762_e("CompletedCount");
            int enabledCount = stack.field_77990_d.func_74762_e("EnabledProgressionCount");
            if (enabledCount <= 0) {
                return 1.0;
            }
            return 1.0 - (double)completedCount / (double)enabledCount;
        }
        return super.getDurabilityForDisplay(stack);
    }

    protected class Mode {
        final Consumer<EntityPlayer> modeUnlockAction;
        final int jpCost;
        final String description;
        final Predicate<EntityPlayer> requirement;

        Mode(Consumer<EntityPlayer> modeUnlockAction, int jpCost, String description) {
            this(modeUnlockAction, jpCost, description, null);
        }

        Mode(Consumer<EntityPlayer> modeUnlockAction, int jpCost, String description, Predicate<EntityPlayer> requirement) {
            this.modeUnlockAction = modeUnlockAction;
            this.jpCost = jpCost;
            this.description = description;
            this.requirement = requirement;
        }

        boolean canLearn(EntityPlayer player) {
            return this.requirement == null || this.requirement.test(player);
        }

        void unlock(EntityPlayer player) {
            this.modeUnlockAction.accept(player);
            BaseSkillLearner.this.syncModeChanges(player);
        }
    }

    protected class Jutsu {
        final Item jutsuItem;
        final int jpCost;
        final String description;
        final Predicate<EntityPlayer> requirement;

        Jutsu(Item jutsuItem, int jpCost, String description) {
            this(jutsuItem, jpCost, description, null);
        }

        Jutsu(Item jutsuItem, int jpCost, String description, Predicate<EntityPlayer> requirement) {
            this.jutsuItem = jutsuItem;
            this.jpCost = jpCost;
            this.description = description;
            this.requirement = requirement;
        }

        boolean canLearn(EntityPlayer player) {
            return this.requirement == null || this.requirement.test(player);
        }
    }
}

