/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Weapons;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import narutodestination.Mathioks.CreativeTabLoader;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ModeMultiplierHandler;
import narutodestination.Mathioks.item.NarutoMaterial;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public abstract class NarutoSword
extends ItemSword {
    protected double baseDamage;
    protected double medicalScaling;
    protected double kenScaling;
    protected double ninScaling;
    protected double taiScaling;
    protected double genScaling;
    protected double shurikenScaling;
    protected double summonScaling;
    protected double kinScaling;
    protected double senScaling;
    protected int requiredKenjutsu;
    protected int requiredShurikenjutsu;
    protected String description;
    protected int durability;
    public boolean enableMastery;
    protected int receivedXPPerUse;
    public int convertedXP;
    public int convertedJP;
    protected long lastConfigReload = 0L;
    protected double damageCap;
    public boolean soulbound;
    public static Configuration configuration;

    public NarutoSword() {
        super(NarutoMaterial.NARUTO_MATERIAL);
        this.func_77664_n();
        this.func_77625_d(1);
        this.func_77656_e(this.durability);
        this.func_77637_a(CreativeTabLoader.tabTools);
        this.func_77655_b(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void loadConfig() {
        String CONFIG_NAME = ((Object)((Object)this)).getClass().getSimpleName().toLowerCase();
        this.baseDamage = configuration.get(CONFIG_NAME, "A BaseDamage", 10.0).getDouble();
        this.kenScaling = configuration.get(CONFIG_NAME, "B KenScaling", 0.1).getDouble();
        this.shurikenScaling = configuration.get(CONFIG_NAME, "C ShurikenScaling", 0.0).getDouble();
        this.ninScaling = configuration.get(CONFIG_NAME, "D NinScaling", 0.0).getDouble();
        this.taiScaling = configuration.get(CONFIG_NAME, "E TaiScaling", 0.0).getDouble();
        this.genScaling = configuration.get(CONFIG_NAME, "F GenScaling", 0.0).getDouble();
        this.summonScaling = configuration.get(CONFIG_NAME, "G SummonScaling", 0.0).getDouble();
        this.kinScaling = configuration.get(CONFIG_NAME, "H KinScaling", 0.0).getDouble();
        this.senScaling = configuration.get(CONFIG_NAME, "I SenScaling", 0.0).getDouble();
        this.medicalScaling = configuration.get(CONFIG_NAME, "J MedicalScaling", 0.0).getDouble();
        this.requiredKenjutsu = configuration.get(CONFIG_NAME, "K RequiredKenjutsu", 5).getInt();
        this.requiredShurikenjutsu = configuration.get(CONFIG_NAME, "L RequiredShurikenjutsu", 0).getInt();
        this.description = configuration.get(CONFIG_NAME, "M Description", "").getString();
        this.durability = configuration.get(CONFIG_NAME, "N Durability", 10000).getInt();
        this.damageCap = configuration.get(CONFIG_NAME, "O DamageCap", -1.0).getDouble();
        this.enableMastery = configuration.get(CONFIG_NAME, "P EnableMastery", true).getBoolean(true);
        this.receivedXPPerUse = configuration.get(CONFIG_NAME, "Q XPPerUse", 1).getInt();
        this.convertedXP = configuration.get(CONFIG_NAME, "R XP Per Convert", 1).getInt();
        this.convertedJP = configuration.get(CONFIG_NAME, "S JP Per Convert", 1).getInt();
        this.soulbound = configuration.get(CONFIG_NAME, "T Soulbound", false).getBoolean(false);
        ConfigCategory removedCategory = configuration.getCategory(CONFIG_NAME);
        configuration.removeCategory(removedCategory);
        configuration.get(CONFIG_NAME, "A BaseDamage", 10.0).set(this.baseDamage);
        configuration.get(CONFIG_NAME, "B KenScaling", 0.1).set(this.kenScaling);
        configuration.get(CONFIG_NAME, "C ShurikenScaling", 0.0).set(this.shurikenScaling);
        configuration.get(CONFIG_NAME, "D NinScaling", 0.0).set(this.ninScaling);
        configuration.get(CONFIG_NAME, "E TaiScaling", 0.0).set(this.taiScaling);
        configuration.get(CONFIG_NAME, "F GenScaling", 0.0).set(this.genScaling);
        configuration.get(CONFIG_NAME, "G SummonScaling", 0.0).set(this.summonScaling);
        configuration.get(CONFIG_NAME, "H KinScaling", 0.0).set(this.kinScaling);
        configuration.get(CONFIG_NAME, "I SenScaling", 0.0).set(this.senScaling);
        configuration.get(CONFIG_NAME, "J MedicalScaling", 0.0).set(this.medicalScaling);
        configuration.get(CONFIG_NAME, "K RequiredKenjutsu", 5).set(this.requiredKenjutsu);
        configuration.get(CONFIG_NAME, "L RequiredShurikenjutsu", 0).set(this.requiredShurikenjutsu);
        configuration.get(CONFIG_NAME, "M Description", "").set(this.description);
        configuration.get(CONFIG_NAME, "N Durability", 10000).set(this.durability);
        configuration.get(CONFIG_NAME, "O DamageCap", 10000).set(this.damageCap);
        configuration.get(CONFIG_NAME, "P EnableMastery", true).set(this.enableMastery);
        configuration.get(CONFIG_NAME, "Q XPPerUse", 1).set(this.receivedXPPerUse);
        configuration.get(CONFIG_NAME, "R XP Per Convert", 1).set(this.convertedXP);
        configuration.get(CONFIG_NAME, "S JP Per Convert", 1).set(this.convertedJP);
        configuration.get(CONFIG_NAME, "T Soulbound", 1).set(this.soulbound);
        NarutoSword.configuration.get((String)CONFIG_NAME, (String)"A BaseDamage", (String)"").comment = LanguageRegistry.instance().getStringLocalization(this.func_77658_a() + ".name");
        this.func_77656_e(this.durability);
        if (configuration.hasChanged()) {
            configuration.save();
        }
        this.lastConfigReload = System.currentTimeMillis();
    }

    protected void initializeItem(ItemStack stack, EntityPlayer player) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (this.enableMastery && !stack.field_77990_d.func_74764_b("SwordXP")) {
            stack.field_77990_d.func_74768_a("SwordXP", 0);
            stack.field_77990_d.func_74768_a("SwordLevel", 1);
        }
        if (this.soulbound && !stack.field_77990_d.func_74764_b("OwnerUUID")) {
            stack.field_77990_d.func_74778_a("OwnerUUID", player.func_110124_au().toString());
        }
    }

    public double getDamage(ExtendedPlayer props, ItemStack stack) {
        int swordLevel = 0;
        if (stack != null) {
            swordLevel = this.getSwordLevel(stack);
        }
        double baseDamageTotal = this.baseDamage + (double)props.getNinjutsu() * this.ninScaling + (double)props.getTaijutsu() * this.taiScaling + (double)props.getGenjutsu() * this.genScaling + (double)props.getKenjutsu() * this.kenScaling + (double)props.getShurikenJutsu() * this.shurikenScaling + (double)props.getSummoning() * this.summonScaling + (double)props.getKinjutsu() * this.kinScaling + (double)props.getMedical() * this.medicalScaling + (double)props.getSenjutsu() * this.senScaling;
        double damageBonus = 1.0 + (double)swordLevel * 0.005;
        double modeDamageMultiplier = ModeMultiplierHandler.getModeMultiplier(props);
        double finalDamage = baseDamageTotal * damageBonus * modeDamageMultiplier;
        if (this.damageCap > 0.0 && finalDamage > this.damageCap) {
            return this.damageCap;
        }
        return finalDamage;
    }

    private String formatClassName(String className) {
        StringBuilder formatted = new StringBuilder();
        for (int i = 0; i < className.length(); ++i) {
            char c = className.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                formatted.append(' ');
            }
            formatted.append(c);
        }
        return formatted.toString();
    }

    private String formatDescription(String description, int wordsPerLine) {
        String[] words = description.split("\\s+");
        StringBuilder formatted = new StringBuilder();
        int count = 0;
        for (String word : words) {
            formatted.append(word).append(" ");
            if (++count != wordsPerLine) continue;
            formatted.append("\n");
            count = 0;
        }
        if (formatted.length() > 0 && formatted.charAt(formatted.length() - 1) == ' ') {
            formatted.deleteCharAt(formatted.length() - 1);
        }
        return formatted.toString().trim();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            ExtendedPlayer props = ExtendedPlayer.get(player);
            if (props.getKenjutsu() < this.requiredKenjutsu) {
                this.sendMessage(player, "You need " + this.requiredKenjutsu + " Kenjutsu to use this weapon effectively.");
                return true;
            }
            if (props.getShurikenJutsu() < this.requiredShurikenjutsu) {
                this.sendMessage(player, "You need " + this.requiredShurikenjutsu + " Shurikenjutsu to use this weapon effectively.");
                return true;
            }
            double damage = this.getDamage(props, stack);
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)damage);
            if (this.enableMastery) {
                this.addSwordXP(stack, player);
            }
        }
        return true;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("SwordXP")) {
                this.initializeItem(itemStack, player);
                if (!world.field_72995_K) {
                    this.writeToNBT(itemStack.field_77990_d);
                    itemStack.field_77990_d.func_74772_a("lastConfigReload", this.lastConfigReload);
                }
            } else if (!world.field_72995_K && itemStack.field_77990_d.func_74763_f("lastConfigReload") < this.lastConfigReload) {
                this.writeToNBT(itemStack.field_77990_d);
                itemStack.field_77990_d.func_74772_a("lastConfigReload", this.lastConfigReload);
            }
            if (this.enableMastery) {
                int currentXP;
                int xpForNextLevel;
                int currentLevel = itemStack.field_77990_d.func_74762_e("SwordLevel");
                for (currentXP = itemStack.field_77990_d.func_74762_e("SwordXP"); currentLevel < 100 && currentXP >= (xpForNextLevel = this.getXpForNextLevel(currentLevel)); currentXP -= xpForNextLevel) {
                    itemStack.field_77990_d.func_74768_a("SwordLevel", ++currentLevel);
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Sword leveled up to " + currentLevel + "!"));
                }
                itemStack.field_77990_d.func_74768_a("SwordXP", currentXP);
            }
        }
    }

    public void addSwordXP(ItemStack itemStack, EntityPlayer player) {
        if (!this.enableMastery || !this.isOwner(itemStack, player)) {
            return;
        }
        int currentLevel = itemStack.field_77990_d.func_74762_e("SwordLevel");
        if (currentLevel >= 100) {
            return;
        }
        int currentXP = itemStack.field_77990_d.func_74762_e("SwordXP");
        int xpForNextLevel = this.getXpForNextLevel(currentLevel);
        if ((currentXP += this.receivedXPPerUse) >= xpForNextLevel) {
            currentXP -= xpForNextLevel;
            itemStack.field_77990_d.func_74768_a("SwordLevel", ++currentLevel);
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Sword leveled up to " + currentLevel + "!"));
        }
        itemStack.field_77990_d.func_74768_a("SwordXP", currentXP);
    }

    private int getXpForNextLevel(int currentLevel) {
        return (int)(100.0 * Math.pow(1.05, currentLevel - 1));
    }

    public int getSwordLevel(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return stack.field_77990_d.func_74762_e("SwordLevel");
        }
        return 1;
    }

    public boolean isOwner(ItemStack stack, EntityPlayer player) {
        if (this.soulbound && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("OwnerUUID")) {
            String ownerUUID = stack.field_77990_d.func_74779_i("OwnerUUID");
            return ownerUUID.equals(player.func_110124_au().toString());
        }
        if (!this.soulbound) {
            return true;
        }
        return player.field_71075_bZ.field_75098_d;
    }

    private String formatXPValue(int xpValue) {
        if (xpValue >= 1000000) {
            return String.format("%.1fM", (double)xpValue / 1000000.0);
        }
        if (xpValue >= 1000) {
            return String.format("%.1fK", (double)xpValue / 1000.0);
        }
        return String.valueOf(xpValue);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean advanced) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        this.readFromNBT(itemStack.field_77990_d);
        ExtendedPlayer props = ExtendedPlayer.get(player);
        int swordLevel = itemStack.field_77990_d.func_74762_e("SwordLevel");
        int currentXP = itemStack.field_77990_d.func_74762_e("SwordXP");
        int xpForNextLevel = this.getXpForNextLevel(swordLevel);
        if (this.enableMastery) {
            if (swordLevel >= 100) {
                list.add(EnumChatFormatting.GOLD + "" + EnumChatFormatting.BOLD + "Mastery Max");
            } else {
                list.add(EnumChatFormatting.GOLD + "" + EnumChatFormatting.BOLD + "Mastery Level " + swordLevel);
                int initialBarLength = 60;
                String formattedCurrentXP = this.formatXPValue(currentXP);
                String formattedMaxXP = this.formatXPValue(xpForNextLevel);
                String xpText = EnumChatFormatting.LIGHT_PURPLE + formattedCurrentXP + EnumChatFormatting.RESET + "/" + EnumChatFormatting.LIGHT_PURPLE + formattedMaxXP + EnumChatFormatting.RESET;
                int textLength = xpText.length();
                int barLength = initialBarLength - 2 * textLength;
                int filledLength = (int)((double)currentXP / (double)xpForNextLevel * (double)barLength);
                int halfBarLength = barLength / 2;
                StringBuilder xpBar = new StringBuilder(EnumChatFormatting.DARK_PURPLE + "[");
                for (int i = 0; i < barLength; ++i) {
                    if (i == halfBarLength) {
                        xpBar.append(EnumChatFormatting.RESET).append(xpText).append(EnumChatFormatting.DARK_PURPLE);
                        continue;
                    }
                    if (i < filledLength) {
                        xpBar.append(EnumChatFormatting.LIGHT_PURPLE).append("|");
                        continue;
                    }
                    xpBar.append(EnumChatFormatting.DARK_PURPLE).append("|");
                }
                xpBar.append(EnumChatFormatting.DARK_PURPLE).append("]");
                list.add(xpBar.toString());
            }
            list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.STRIKETHROUGH + "--------------------");
        }
        double baseDamageValue = this.getDamage(props, itemStack);
        int roundedBaseDamage = (int)Math.round(baseDamageValue);
        list.add(EnumChatFormatting.DARK_RED + "Damage: " + roundedBaseDamage);
        double modeDamageMultiplier = ModeMultiplierHandler.getModeMultiplier(props);
        int modeBoostPercent = (int)((modeDamageMultiplier - 1.0) * 100.0);
        if (modeBoostPercent > 0) {
            list.add(EnumChatFormatting.GREEN + "Active Mode Damage Boost: +" + modeBoostPercent + "%");
        }
        if (this.requiredKenjutsu > 0) {
            list.add(EnumChatFormatting.BLUE + "Required Kenjutsu: " + this.requiredKenjutsu);
        }
        if (this.requiredShurikenjutsu > 0) {
            list.add(EnumChatFormatting.DARK_PURPLE + "Required Shurikenjutsu: " + this.requiredShurikenjutsu);
        }
        if (this.soulbound && itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b("OwnerUUID")) {
            String ownerUUID = itemStack.field_77990_d.func_74779_i("OwnerUUID");
            try {
                EntityPlayer owner = player.field_70170_p.func_152378_a(UUID.fromString(ownerUUID));
                if (owner != null) {
                    list.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.BOLD + "Owner: " + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + owner.getDisplayName());
                } else {
                    list.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.BOLD + "Owner: " + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + "Unknown");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.description != null && !this.description.isEmpty()) {
            String formattedDescription = this.formatDescription(this.description, 5);
            for (String line : formattedDescription.split("\n")) {
                list.add(EnumChatFormatting.AQUA + line);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconReg) {
        this.field_77791_bV = iconReg.func_94245_a("tm:swords/" + this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1));
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        EntityPlayer player;
        ExtendedPlayer props;
        if (entityLiving instanceof EntityPlayer && (props = ExtendedPlayer.get(player = (EntityPlayer)entityLiving)).getKenjutsu() < this.requiredKenjutsu) {
            this.sendMessage(player, "You don't have enough Kenjutsu to use this weapon effectively!");
            return true;
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    protected void sendMessage(EntityPlayer player, String message) {
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.epic;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74780_a("baseDamage", this.baseDamage);
        compound.func_74780_a("medicalScaling", this.medicalScaling);
        compound.func_74780_a("kenScaling", this.kenScaling);
        compound.func_74780_a("ninScaling", this.ninScaling);
        compound.func_74780_a("taiScaling", this.taiScaling);
        compound.func_74780_a("genScaling", this.genScaling);
        compound.func_74780_a("shurikenScaling", this.shurikenScaling);
        compound.func_74780_a("summonScaling", this.summonScaling);
        compound.func_74780_a("kinScaling", this.kinScaling);
        compound.func_74780_a("senScaling", this.senScaling);
        compound.func_74780_a("damageCap", this.damageCap);
        compound.func_74768_a("requiredKenjutsu", this.requiredKenjutsu);
        compound.func_74768_a("requiredShurikenjutsu", this.requiredShurikenjutsu);
        compound.func_74778_a("description", this.description);
        compound.func_74768_a("receivedXPPerUse", this.receivedXPPerUse);
        compound.func_74768_a("convertedXP", this.convertedXP);
        compound.func_74768_a("convertedJP", this.convertedJP);
        compound.func_74757_a("enableMastery", this.enableMastery);
        compound.func_74757_a("soulbound", this.soulbound);
        compound.func_74768_a("durability", this.durability);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.baseDamage = compound.func_74769_h("baseDamage");
        this.medicalScaling = compound.func_74769_h("medicalScaling");
        this.kenScaling = compound.func_74769_h("kenScaling");
        this.ninScaling = compound.func_74769_h("ninScaling");
        this.taiScaling = compound.func_74769_h("taiScaling");
        this.genScaling = compound.func_74769_h("genScaling");
        this.shurikenScaling = compound.func_74769_h("shurikenScaling");
        this.summonScaling = compound.func_74769_h("summonScaling");
        this.kinScaling = compound.func_74769_h("kinScaling");
        this.senScaling = compound.func_74769_h("senScaling");
        this.damageCap = compound.func_74769_h("damageCap");
        this.requiredKenjutsu = compound.func_74762_e("requiredKenjutsu");
        this.requiredShurikenjutsu = compound.func_74762_e("requiredShurikenjutsu");
        this.description = compound.func_74779_i("description");
        this.receivedXPPerUse = compound.func_74762_e("receivedXPPerUse");
        this.convertedXP = compound.func_74762_e("convertedXP");
        this.convertedJP = compound.func_74762_e("convertedJP");
        this.enableMastery = compound.func_74767_n("enableMastery");
        this.soulbound = compound.func_74767_n("soulbound");
        this.durability = compound.func_74762_e("durability");
    }
}

