/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.bonemealtweaker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mod.acgaming.bonemealtweaker.config.json.BlockConfig;
import mod.acgaming.bonemealtweaker.config.json.SpawnBlock;
import mod.acgaming.bonemealtweaker.gen.BTWorldGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="bonemealtweaker", name="Bonemeal Tweaker", version="1.2.0", acceptedMinecraftVersions="[1.12.2]")
public class BonemealTweaker {
    public static final String MOD_ID = "bonemealtweaker";
    public static final String NAME = "Bonemeal Tweaker";
    public static final String VERSION = "1.2.0";
    public static final String ACCEPTED_VERSIONS = "[1.12.2]";
    public static final Logger LOGGER = LogManager.getLogger((String)"Bonemeal Tweaker");
    public static final Map<ResourceLocation, List<BlockConfig>> BLOCK_CONFIGS = new Object2ObjectOpenHashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FLOWER_ENTRY = "flowerEntry";
    private static File configDir;

    public static boolean applyBlockPlacement(World world, BlockPos pos, IBlockState state, EntityPlayer placer, ItemStack stack, boolean isBonemeal) {
        if (world.field_72995_K) {
            return false;
        }
        ResourceLocation blockRL = state.func_177230_c().getRegistryName();
        List<BlockConfig> configs = BLOCK_CONFIGS.get(blockRL);
        if (configs == null) {
            LOGGER.debug("No configs found for block: {}", (Object)blockRL);
            return false;
        }
        Biome biome = world.func_180494_b(pos);
        ResourceLocation biomeName = biome.getRegistryName();
        int dimension = world.field_73011_w.getDimension();
        IBlockState targetState = world.func_180495_p(pos.func_177984_a());
        for (BlockConfig config : configs) {
            if (isBonemeal && !config.getApplyMode().isBonemeal() || !isBonemeal && !config.getApplyMode().isSurface()) continue;
            if (!config.getBiomes().isEmpty()) {
                if (biomeName == null) {
                    LOGGER.debug("Biome at {} has no valid registry name", (Object)pos);
                    continue;
                }
                String biomeNameStr = biomeName.toString();
                if (!config.getBiomes().contains(biomeNameStr)) {
                    LOGGER.debug("Biome '{}' at {} is not in allowed biomes list: {}", (Object)biomeNameStr, (Object)pos, config.getBiomes());
                    continue;
                }
            }
            if (!config.getDimensions().isEmpty() && !config.getDimensions().contains(dimension)) {
                LOGGER.debug("Dimension {} is not in allowed dimensions list: {}", (Object)dimension, config.getDimensions());
                continue;
            }
            if (!(config.getReplaceBlock() != null ? targetState.func_177230_c().getRegistryName().equals((Object)config.getReplaceBlock()) : world.func_175623_d(pos.func_177984_a()))) {
                LOGGER.debug("Target block {} at {} does not match replaceBlock: {}", (Object)targetState.func_177230_c().getRegistryName(), (Object)pos.func_177984_a(), (Object)config.getReplaceBlock());
                continue;
            }
            Random rand = world.field_73012_v;
            BlockPos blockpos = pos.func_177984_a();
            block1: for (int i = 0; i < config.getIterations(); ++i) {
                BlockPos blockpos1 = blockpos;
                int j = 0;
                while (true) {
                    if (j >= i / 16) {
                        IBlockState currentState = world.func_180495_p(blockpos1);
                        if (!(config.getReplaceBlock() == null ? world.func_175623_d(blockpos1) : currentState.func_177230_c().getRegistryName().equals((Object)config.getReplaceBlock()))) continue block1;
                        IBlockState spawnState = config.getRandomBlockState(rand);
                        if (FLOWER_ENTRY.equals(config.getSpawnBlocks().stream().filter(b -> b.getBlockState() == spawnState).map(SpawnBlock::getBlock).findFirst().orElse(null))) {
                            IBlockState oldState = world.func_180495_p(blockpos1);
                            biome.plantFlower(world, rand, blockpos1);
                            IBlockState newState = world.func_180495_p(blockpos1);
                            if (newState == oldState) continue block1;
                            world.func_184138_a(blockpos1, oldState, newState, 3);
                            continue block1;
                        }
                        if (spawnState == null || !spawnState.func_177230_c().func_176196_c(world, blockpos1)) continue block1;
                        world.func_180501_a(blockpos1, spawnState, 3);
                        spawnState.func_177230_c().func_180633_a(world, blockpos1, spawnState, (EntityLivingBase)placer, stack);
                        world.func_184138_a(blockpos1, world.func_180495_p(blockpos1), spawnState, 3);
                        world.func_184138_a(blockpos1.func_177984_a(), world.func_180495_p(blockpos1.func_177984_a()), spawnState, 3);
                        continue block1;
                    }
                    if (world.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != state.func_177230_c() || world.func_180495_p(blockpos1).func_185915_l()) continue block1;
                    ++j;
                }
            }
            return true;
        }
        LOGGER.debug("No matching config found for block: {}, biome: {}, dimension: {}, replaceBlock: {}", (Object)blockRL, (Object)biomeName, (Object)dimension, (Object)targetState.func_177230_c().getRegistryName());
        return false;
    }

    public static void loadConfigs() {
        BLOCK_CONFIGS.clear();
        File[] configFiles = configDir.listFiles((dir, name) -> name.endsWith(".json"));
        if (configFiles == null) {
            return;
        }
        for (File file : configFiles) {
            try {
                BlockConfig.ApplyMode applyMode;
                String json = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                JsonObject config = (JsonObject)GSON.fromJson(json, JsonObject.class);
                String blockName = config.get("block").getAsString();
                ResourceLocation blockRL = new ResourceLocation(blockName);
                ResourceLocation replaceBlock = config.has("replaceBlock") ? new ResourceLocation(config.get("replaceBlock").getAsString()) : null;
                int iterations = config.get("iterations").getAsInt();
                String applyModeStr = config.has("applyMode") ? config.get("applyMode").getAsString().toUpperCase() : "BONEMEAL";
                try {
                    applyMode = BlockConfig.ApplyMode.valueOf(applyModeStr);
                }
                catch (IllegalArgumentException e2) {
                    LOGGER.error("Invalid applyMode '{}' in config {}, defaulting to BONEMEAL", (Object)applyModeStr, (Object)file.getName());
                    applyMode = BlockConfig.ApplyMode.BONEMEAL;
                }
                int genDensity = applyMode == BlockConfig.ApplyMode.BONEMEAL ? 0 : config.get("genDensity").getAsInt();
                ArrayList<String> biomes = new ArrayList<String>();
                config.get("biomes").getAsJsonArray().forEach(e -> biomes.add(e.getAsString()));
                ArrayList<Integer> dimensions = new ArrayList<Integer>();
                config.get("dimensions").getAsJsonArray().forEach(e -> dimensions.add(e.getAsInt()));
                ArrayList<SpawnBlock> spawnBlocks = new ArrayList<SpawnBlock>();
                config.get("spawnBlocks").getAsJsonArray().forEach(e -> {
                    JsonObject obj = e.getAsJsonObject();
                    String block = obj.get("block").getAsString();
                    int weight = obj.get("weight").getAsInt();
                    spawnBlocks.add(new SpawnBlock(block, weight));
                });
                BLOCK_CONFIGS.computeIfAbsent(blockRL, k -> new ArrayList()).add(new BlockConfig(replaceBlock, iterations, applyMode, genDensity, biomes, dimensions, spawnBlocks));
            }
            catch (JsonParseException | IOException e3) {
                LOGGER.error("Failed to load config: {}", (Object)file.getName(), (Object)e3);
            }
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDir = new File(event.getModConfigurationDirectory(), MOD_ID);
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        BonemealTweaker.loadConfigs();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BTWorldGenerator(), (int)100);
    }
}

