/*
 * Decompiled with CFR 0.152.
 */
package org.karlssonsmp.ghost;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0017H\u0007J)\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001c\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J1\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001c\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\"J5\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00192\u000e\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001cH\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/karlssonsmp/ghost/Ghost;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "messages", "Lorg/bukkit/configuration/file/FileConfiguration;", "playerOriginalData", "", "Lorg/bukkit/entity/Player;", "Lkotlin/Pair;", "Lorg/bukkit/Location;", "Lorg/bukkit/GameMode;", "spectatingMap", "onEnable", "", "onDisable", "onPlayerQuit", "event", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "getMessage", "", "key", "replacements", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "applyColorCodes", "input", "sendMessage", "player", "(Lorg/bukkit/entity/Player;Ljava/lang/String;[Ljava/lang/String;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "reloadMessagesConfig", "Ghost"})
@SourceDebugExtension(value={"SMAP\nGhost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ghost.kt\norg/karlssonsmp/ghost/Ghost\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,242:1\n13402#2,2:243\n*S KotlinDebug\n*F\n+ 1 Ghost.kt\norg/karlssonsmp/ghost/Ghost\n*L\n97#1:243,2\n*E\n"})
public final class Ghost
extends JavaPlugin
implements Listener {
    private FileConfiguration messages;
    @NotNull
    private final Map<Player, Pair<Location, GameMode>> playerOriginalData = new LinkedHashMap();
    @NotNull
    private final Map<Player, Player> spectatingMap = new LinkedHashMap();

    public void onEnable() {
        File messagesFile;
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        File langFolder = new File(this.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!(messagesFile = new File(langFolder, "messages.yml")).exists()) {
            this.saveResource("lang/messages.yml", false);
        }
        this.messages = (FileConfiguration)YamlConfiguration.loadConfiguration((File)messagesFile);
        this.getLogger().info("Ghost Plugin Enabled");
        this.getLogger().info("Plugin created by karlsson1000");
    }

    public void onDisable() {
        this.getLogger().info("Ghost Plugin Disabled");
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (player2.getGameMode() != GameMode.SPECTATOR) {
            this.playerOriginalData.put(player2, new Pair<Location, GameMode>(player2.getLocation(), player2.getGameMode()));
        }
        if (this.spectatingMap.containsValue(player2)) {
            for (Map.Entry<Player, Player> entry : this.spectatingMap.entrySet()) {
                Player spectator = entry.getKey();
                Player target = entry.getValue();
                if (!Intrinsics.areEqual(target, player2)) continue;
                Pair<Location, GameMode> originalData = this.playerOriginalData.get(spectator);
                if (originalData != null) {
                    spectator.teleport(originalData.getFirst());
                    spectator.setGameMode(originalData.getSecond());
                    this.sendMessage(spectator, "spectate-mode-deactivated", new String[0]);
                }
                this.playerOriginalData.remove(spectator);
                this.spectatingMap.remove(spectator);
                break;
            }
        }
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Pair<Location, GameMode> originalData = this.playerOriginalData.get(player2);
        if (originalData != null) {
            player2.teleport(originalData.getFirst());
            player2.setGameMode(originalData.getSecond());
            if (originalData.getSecond() == GameMode.SPECTATOR) {
                this.sendMessage(player2, "spectate-mode-deactivated", new String[0]);
            }
            this.playerOriginalData.remove(player2);
        }
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
    }

    private final String getMessage(String key, String ... replacements) {
        String message = null;
        FileConfiguration fileConfiguration = this.messages;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("messages");
            fileConfiguration = null;
        }
        String string = fileConfiguration.getString(key);
        if (string == null) {
            return "Message not found for key: " + key;
        }
        message = string;
        String[] $this$forEach$iv = replacements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String replacement = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            message = StringsKt.replace$default(message, "{player}", replacement, false, 4, null);
        }
        return "\u00a78\u00a7l\u0262\u029c\u1d0f\u0455\u1d1b \u00a7r" + this.applyColorCodes(message);
    }

    private final String applyColorCodes(String input) {
        return StringsKt.replace$default(input, "&", "\u00a7", false, 4, null);
    }

    private final void sendMessage(Player player, String key, String ... replacements) {
        String message = this.getMessage(key, Arrays.copyOf(replacements, replacements.length));
        player.sendMessage(message);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (StringsKt.equals(command.getName(), "spectate", true) && sender instanceof Player) {
            CommandSender player = sender;
            if (!player.hasPermission("spectate.use")) {
                this.sendMessage((Player)player, "no-permission", new String[0]);
                return true;
            }
            if (args.length == 0) {
                if (((Player)player).getGameMode() == GameMode.SPECTATOR) {
                    Pair<Location, GameMode> originalData = this.playerOriginalData.get(player);
                    if (originalData != null) {
                        ((Player)player).teleport(originalData.getFirst());
                        ((Player)player).setGameMode(originalData.getSecond());
                        this.sendMessage((Player)player, "spectate-mode-deactivated", new String[0]);
                        this.playerOriginalData.remove(player);
                    }
                    this.spectatingMap.remove(player);
                    return true;
                }
                this.sendMessage((Player)player, "not-spectating-anyone", new String[0]);
                return true;
            }
            Player targetPlayer = this.getServer().getPlayer(args[0]);
            if (targetPlayer != null) {
                if (Intrinsics.areEqual(player, targetPlayer)) {
                    this.sendMessage((Player)player, "cannot-spectate-yourself", new String[0]);
                    return true;
                }
                if (((Player)player).getGameMode() == GameMode.SPECTATOR && Intrinsics.areEqual(((Player)player).getSpectatorTarget(), targetPlayer)) {
                    Pair<Location, GameMode> originalData = this.playerOriginalData.get(player);
                    if (originalData != null) {
                        ((Player)player).teleport(originalData.getFirst());
                        ((Player)player).setGameMode(originalData.getSecond());
                        this.sendMessage((Player)player, "spectate-mode-deactivated", new String[0]);
                        this.playerOriginalData.remove(player);
                    }
                    this.spectatingMap.remove(player);
                    return true;
                }
                if (((Player)player).getGameMode() == GameMode.SPECTATOR) {
                    Pair<Location, GameMode> originalData = this.playerOriginalData.get(player);
                    if (originalData != null) {
                        ((Player)player).teleport(originalData.getFirst());
                        ((Player)player).setGameMode(originalData.getSecond());
                        this.sendMessage((Player)player, "spectate-mode-deactivated", new String[0]);
                        this.playerOriginalData.remove(player);
                    }
                    this.spectatingMap.remove(player);
                }
                this.playerOriginalData.put((Player)player, new Pair<Location, GameMode>(((Player)player).getLocation(), ((Player)player).getGameMode()));
                ((Player)player).setGameMode(GameMode.SPECTATOR);
                ((Player)player).teleport(targetPlayer.getLocation());
                String[] stringArray = new String[]{targetPlayer.getName()};
                this.sendMessage((Player)player, "spectate-mode-activated", stringArray);
                new BukkitRunnable(player, targetPlayer){
                    final /* synthetic */ CommandSender $player;
                    final /* synthetic */ Player $targetPlayer;
                    {
                        this.$player = $player;
                        this.$targetPlayer = $targetPlayer;
                    }

                    public void run() {
                        if (((Player)this.$player).getGameMode() == GameMode.SPECTATOR) {
                            Location location = this.$targetPlayer.getLocation();
                            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                            Location targetLoc = location;
                            Vector vector = this.$targetPlayer.getLocation().getDirection();
                            Intrinsics.checkNotNullExpressionValue(vector, "getDirection(...)");
                            Vector direction = vector;
                            Vector vector2 = direction.multiply(-1).setY(0).normalize().multiply(2);
                            Intrinsics.checkNotNullExpressionValue(vector2, "multiply(...)");
                            Vector offset = vector2;
                            if (((Player)this.$player).getLocation().distance(targetLoc) > 0.5) {
                                ((Player)this.$player).teleport(targetLoc.add(offset));
                            }
                            ((Player)this.$player).getLocation().setY(targetLoc.getY() + 1.5);
                            ((Player)this.$player).getLocation().setYaw(this.$targetPlayer.getLocation().getYaw());
                            ((Player)this.$player).getLocation().setPitch(this.$targetPlayer.getLocation().getPitch());
                        } else {
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)this, 0L, 1L);
                ((Player)player).setSpectatorTarget((Entity)targetPlayer);
                this.spectatingMap.put((Player)player, targetPlayer);
            } else {
                String[] stringArray = new String[]{args[0]};
                this.sendMessage((Player)player, "player-not-found", stringArray);
            }
            return true;
        }
        if (StringsKt.equals(command.getName(), "ghost", true)) {
            if (args.length == 0) {
                sender.sendMessage("\u00a78\u00a7l\u0262\u029c\u1d0f\u0455\u1d1b \u00a7r\u00a77Plugin created by \u00a7akarlsson1000.");
                sender.sendMessage("\u00a77Use /ghost reload to reload the plugin configuration.");
                return true;
            }
            if (args.length == 1 && StringsKt.equals(args[0], "reload", true) && sender.hasPermission("ghost.reload")) {
                this.reloadMessagesConfig();
                this.sendMessage((Player)sender, "config-reloaded", new String[0]);
                return true;
            }
            if (args.length == 1 && StringsKt.equals(args[0], "reload", true) && !sender.hasPermission("ghost.reload")) {
                sender.sendMessage("\u00a7cYou do not have permission to reload the plugin.");
                return true;
            }
        }
        return false;
    }

    private final void reloadMessagesConfig() {
        File langFolder = new File(this.getDataFolder(), "lang");
        File messagesFile = new File(langFolder, "messages.yml");
        if (messagesFile.exists()) {
            this.messages = (FileConfiguration)YamlConfiguration.loadConfiguration((File)messagesFile);
            this.getLogger().info("Messages configuration reloaded");
        } else {
            this.getLogger().warning("Messages file not found!");
        }
    }
}

