/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwaurora;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.bridges.Bridges;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.door.Doors;
import fr.samlegamer.addonslib.fences.Fences;
import fr.samlegamer.addonslib.furnitures.Furnitures;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.path.Paths;
import fr.samlegamer.addonslib.roofs.Roofs;
import fr.samlegamer.addonslib.stairs.Stairs;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.trapdoor.Trapdoors;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.addonslib.windows.Windows;
import fr.samlegamer.mcwaurora.MappingsFix;
import fr.samlegamer.mcwaurora.Recipes;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mcwaurora")
public class McwAurora
extends McwMod {
    public static final String MODID = "mcwaurora";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> WOOD_ENHANCED_MUSH = Arrays.asList("brown_mushroom", "red_mushroom");
    public static final List<String> WOOD_BAYOU = Arrays.asList("cypress");
    public static final List<String> WOOD_ABUNDANCE = Arrays.asList("jacaranda", "redbud");
    private static final DeferredRegister<Block> block = Registration.blocks((String)"mcwaurora");
    private static final DeferredRegister<Item> item = Registration.items((String)"mcwaurora");
    public static final ItemGroup MCWAURORA_TAB = new ItemGroup("mcwaurora.tab"){

        @Nonnull
        public ItemStack func_78016_d() {
            NewIconRandom.NewProperties prop = new NewIconRandom.NewProperties(Finder.findBlock((String)McwAurora.MODID, (String)(McwAurora.randomNaming() + "_roof")), Finder.findBlock((String)McwAurora.MODID, (String)(McwAurora.randomNaming() + "_picket_fence")), Finder.findBlock((String)McwAurora.MODID, (String)(McwAurora.randomNaming() + "_wardrobe")), Finder.findBlock((String)McwAurora.MODID, (String)(McwAurora.randomNaming() + "_log_bridge_middle")), Finder.findBlock((String)McwAurora.MODID, (String)(McwAurora.randomNaming() + "_pane_window")), Finder.findBlock((String)McwAurora.MODID, (String)(McwAurora.randomNaming() + "_modern_door")), Finder.findBlock((String)McwAurora.MODID, (String)(McwAurora.randomNaming() + "_mystic_trapdoor")), Finder.findBlock((String)McwAurora.MODID, (String)(McwAurora.randomNaming() + "_planks_path")), Finder.findBlock((String)McwAurora.MODID, (String)(McwAurora.randomNaming() + "_skyline_stairs")));
            prop.addType(NewIconRandom.BlockType.BRIDGES).addType(NewIconRandom.BlockType.ROOFS).addType(NewIconRandom.BlockType.FENCES).addType(NewIconRandom.BlockType.FURNITURES).addType(NewIconRandom.BlockType.STAIRS).addType(NewIconRandom.BlockType.PATHS).addType(NewIconRandom.BlockType.WINDOWS).addType(NewIconRandom.BlockType.DOORS).addType(NewIconRandom.BlockType.TRAPDOORS);
            Block icon = prop.buildIcon(new NewIconRandom.BlockType[]{NewIconRandom.BlockType.BRIDGES, NewIconRandom.BlockType.ROOFS, NewIconRandom.BlockType.FENCES, NewIconRandom.BlockType.FURNITURES, NewIconRandom.BlockType.STAIRS, NewIconRandom.BlockType.PATHS, NewIconRandom.BlockType.WINDOWS, NewIconRandom.BlockType.DOORS, NewIconRandom.BlockType.TRAPDOORS});
            return new ItemStack((IItemProvider)icon);
        }
    };

    public McwAurora() {
        LOGGER.info("Macaw's Aurora Mod Loading...");
        Registration.init(block, item);
        AbstractBlock.Properties wood = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).harvestTool(ToolType.AXE).func_200948_a(0.5f, 2.5f).func_200947_a(SoundType.field_185848_a);
        AbstractBlock.Properties leaves = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196642_W).harvestTool(ToolType.HOE);
        Bridges.setRegistrationWoodModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues", (AbstractBlock.Properties)wood);
        Bridges.setRegistrationWoodModLoaded(WOOD_ENHANCED_MUSH, block, item, (ItemGroup)MCWAURORA_TAB, (String)"enhanced_mushrooms", (AbstractBlock.Properties)wood);
        Bridges.setRegistrationWoodModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance", (AbstractBlock.Properties)wood);
        Roofs.setRegistrationWoodModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues", (AbstractBlock.Properties)wood);
        Roofs.setRegistrationWoodModLoaded(WOOD_ENHANCED_MUSH, block, item, (ItemGroup)MCWAURORA_TAB, (String)"enhanced_mushrooms", (AbstractBlock.Properties)wood);
        Roofs.setRegistrationWoodModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance", (AbstractBlock.Properties)wood);
        Fences.setRegistrationWoodModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues", (AbstractBlock.Properties)wood);
        Fences.setRegistrationWoodModLoaded(WOOD_ENHANCED_MUSH, block, item, (ItemGroup)MCWAURORA_TAB, (String)"enhanced_mushrooms", (AbstractBlock.Properties)wood);
        Fences.setRegistrationWoodModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance", (AbstractBlock.Properties)wood);
        Fences.setRegistrationHedgesModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues", (AbstractBlock.Properties)leaves);
        Fences.setRegistrationHedgesModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance", (AbstractBlock.Properties)leaves);
        Furnitures.setRegistrationWoodModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues");
        Furnitures.setRegistrationWoodModLoaded(WOOD_ENHANCED_MUSH, block, item, (ItemGroup)MCWAURORA_TAB, (String)"enhanced_mushrooms");
        Furnitures.setRegistrationWoodModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance");
        Stairs.setRegistrationWoodModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues", (AbstractBlock.Properties)wood);
        Stairs.setRegistrationWoodModLoaded(WOOD_ENHANCED_MUSH, block, item, (ItemGroup)MCWAURORA_TAB, (String)"enhanced_mushrooms", (AbstractBlock.Properties)wood);
        Stairs.setRegistrationWoodModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance", (AbstractBlock.Properties)wood);
        Paths.setRegistrationWoodModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues");
        Paths.setRegistrationWoodModLoaded(WOOD_ENHANCED_MUSH, block, item, (ItemGroup)MCWAURORA_TAB, (String)"enhanced_mushrooms");
        Paths.setRegistrationWoodModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance");
        Trapdoors.setRegistrationWoodModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues");
        Trapdoors.setRegistrationWoodModLoaded(WOOD_ENHANCED_MUSH, block, item, (ItemGroup)MCWAURORA_TAB, (String)"enhanced_mushrooms");
        Trapdoors.setRegistrationWoodModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance");
        Doors.setRegistrationWoodModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues");
        Doors.setRegistrationWoodModLoaded(WOOD_ENHANCED_MUSH, block, item, (ItemGroup)MCWAURORA_TAB, (String)"enhanced_mushrooms");
        Doors.setRegistrationWoodModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance");
        Windows.setRegistrationWoodModLoaded(WOOD_BAYOU, block, item, (ItemGroup)MCWAURORA_TAB, (String)"bayou_blues");
        Windows.setRegistrationWoodModLoaded(WOOD_ENHANCED_MUSH, block, item, (ItemGroup)MCWAURORA_TAB, (String)"enhanced_mushrooms");
        Windows.setRegistrationWoodModLoaded(WOOD_ABUNDANCE, block, item, (ItemGroup)MCWAURORA_TAB, (String)"abundance");
        this.bus().addListener(this::clientSetup);
        this.bus().addListener(this::commonSetup);
        this.bus().addListener(this::dataSetup);
        MinecraftForge.EVENT_BUS.register(MappingsFix.class);
        LOGGER.info("Macaw's Aurora Mod Finish !");
    }

    public void commonSetup(FMLCommonSetupEvent fmlCommonSetupEvent) {
        fmlCommonSetupEvent.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, WOOD_ENHANCED_MUSH);
            McwLootTables.addBlockAllWood((String)MODID, WOOD_BAYOU);
            McwLootTables.addBlockAllWood((String)MODID, WOOD_ABUNDANCE);
            McwLootTables.addBlockHedges((String)MODID, WOOD_BAYOU);
            McwLootTables.addBlockHedges((String)MODID, WOOD_ABUNDANCE);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(generator, MODID, existingFileHelper){

                protected void func_200432_c() {
                    this.addAllMcwTags(McwAurora.MODID, WOOD_ENHANCED_MUSH);
                    this.addAllMcwTags(McwAurora.MODID, WOOD_BAYOU, WOOD_BAYOU);
                    this.addAllMcwTags(McwAurora.MODID, WOOD_ABUNDANCE, WOOD_ABUNDANCE);
                }
            };
            generator.func_200390_a((IDataProvider)mcwBlockTags);
            generator.func_200390_a((IDataProvider)new McwItemTags(generator, (BlockTagsProvider)mcwBlockTags, MODID, existingFileHelper){

                protected void func_200432_c() {
                    this.addAllMcwTags(McwAurora.MODID, WOOD_ENHANCED_MUSH);
                    this.addAllMcwTags(McwAurora.MODID, WOOD_BAYOU, WOOD_BAYOU);
                    this.addAllMcwTags(McwAurora.MODID, WOOD_ABUNDANCE, WOOD_ABUNDANCE);
                }
            });
            generator.func_200390_a((IDataProvider)new Recipes(generator));
        }
    }

    public void clientSetup(FMLClientSetupEvent e) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)e, (String)MODID, WOOD_BAYOU, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllWood((FMLClientSetupEvent)e, (String)MODID, WOOD_ENHANCED_MUSH, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllWood((FMLClientSetupEvent)e, (String)MODID, WOOD_ABUNDANCE, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)e, (String)MODID, WOOD_BAYOU);
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)e, (String)MODID, WOOD_ABUNDANCE);
    }

    private static String randomNaming() {
        Random rand = new Random();
        if (ModList.get().isLoaded("bayou_blues") && ModList.get().isLoaded("enhanced_mushrooms") && ModList.get().isLoaded("abundance")) {
            int i = rand.nextInt(3);
            switch (i) {
                case 0: {
                    return "cypress";
                }
                case 1: {
                    return "brown_mushroom";
                }
                case 2: {
                    return "jacaranda";
                }
            }
            return "red_mushroom";
        }
        if (ModList.get().isLoaded("bayou_blues")) {
            return "cypress";
        }
        if (ModList.get().isLoaded("enhanced_mushrooms")) {
            return "brown_mushroom";
        }
        if (ModList.get().isLoaded("abundance")) {
            return "jacaranda";
        }
        return "brown_mushroom";
    }
}

