/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwaurora;

import fr.addonslib.api.data.ModType;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.registry.McwRegistry;
import fr.samlegamer.addonslib.tab.APICreativeTab;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.util.McwCommon;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.mcwaurora.Recipes;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="mcwaurora")
public class McwAurora
extends McwMod {
    public static final String MODID = "mcwaurora";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> WOOD_ENHANCED_MUSH = List.of("mushroom");
    public static final List<String> WOOD_NOMANSLAND = List.of("maple", "pine", "walnut", "willow");
    public static final List<String> LEAVE_NOMANSLAND = List.of("maple", "pine", "walnut", "willow", "autumnal_oak", "frosted", "pale_cherry", "yellow_birch", "red_maple");
    private static final DeferredRegister.Blocks block = Registration.blocks((String)"mcwaurora");
    private static final DeferredRegister.Items item = Registration.items((String)"mcwaurora");
    public static final DeferredRegister<CreativeModeTab> ct = Registration.creativeModeTab((String)"mcwaurora");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MCWAURORA_TAB = ct.register("tab", () -> CreativeModeTab.builder().icon(McwAurora::getIcon).title((Component)Component.translatable((String)"mcwaurora.tab")).build());

    public McwAurora(IEventBus modBus) {
        super(modBus);
        LOGGER.info("Macaw's Aurora Mod Loading...");
        Registration.init((IEventBus)modBus, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, ct);
        List<String> leaveClassic = List.of("maple", "pine", "walnut", "willow", "autumnal_oak", "frosted", "yellow_birch", "red_maple");
        Map leaveSoundCherry = McwRegistry.makeDefaultFromList(List.of("pale_cherry"), (SoundType)SoundType.CHERRY_LEAVES);
        McwRegistry.setRegistriesWood(WOOD_ENHANCED_MUSH, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (ModType[])Registration.getAllModTypeWood());
        McwRegistry.setRegistriesWood(WOOD_NOMANSLAND, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (ModType[])Registration.getAllModTypeWood());
        McwRegistry.setRegistriesLeave(leaveClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        McwRegistry.setRegistriesLeave((Map)leaveSoundCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        modBus.addListener(this::addToFurnitureStorage);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::dataSetup);
        modBus.addListener(this::tabSetup);
        LOGGER.info("Macaw's Aurora Mod Finish !");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOOD_ENHANCED_MUSH, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOOD_NOMANSLAND, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, LEAVE_NOMANSLAND);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, WOOD_ENHANCED_MUSH);
            McwLootTables.addBlockAllWood((String)MODID, WOOD_NOMANSLAND);
            McwLootTables.addBlockHedges((String)MODID, LEAVE_NOMANSLAND);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture registries = gatherDataEvent.getLookupProvider();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(this, output, registries, MODID, existingFileHelper){

                protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider provider) {
                    this.addAllMcwTagsWood(McwAurora.MODID, WOOD_ENHANCED_MUSH, Registration.getAllModTypeWood());
                    this.addAllMcwTagsWood(McwAurora.MODID, WOOD_NOMANSLAND, Registration.getAllModTypeWood());
                    this.addAllMcwTagsLeave(McwAurora.MODID, LEAVE_NOMANSLAND);
                }
            };
            generator.addProvider(true, (DataProvider)new Recipes(output, registries));
            generator.addProvider(true, (DataProvider)mcwBlockTags);
            generator.addProvider(true, (DataProvider)new McwItemTags(this, output, registries, mcwBlockTags.contentsGetter(), MODID, existingFileHelper){

                protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider provider) {
                    this.addAllMcwTagsWood(McwAurora.MODID, WOOD_ENHANCED_MUSH, Registration.getAllModTypeWood());
                    this.addAllMcwTagsWood(McwAurora.MODID, WOOD_NOMANSLAND, Registration.getAllModTypeWood());
                    this.addAllMcwTagsLeave(McwAurora.MODID, LEAVE_NOMANSLAND);
                }
            });
        }
    }

    public void tabSetup(BuildCreativeModeTabContentsEvent event) {
        ModList modList = ModList.get();
        if (modList.isLoaded("enhanced_mushrooms")) {
            APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, WOOD_ENHANCED_MUSH, (CreativeModeTab)((CreativeModeTab)MCWAURORA_TAB.get()), (ModType[])Registration.getAllModTypeWood());
        }
        if (modList.isLoaded("nomansland")) {
            APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, WOOD_NOMANSLAND, (CreativeModeTab)((CreativeModeTab)MCWAURORA_TAB.get()), (ModType[])Registration.getAllModTypeWood());
            APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, LEAVE_NOMANSLAND, (CreativeModeTab)((CreativeModeTab)MCWAURORA_TAB.get()));
        }
    }

    public void addToFurnitureStorage(BlockEntityTypeAddBlocksEvent event) {
        McwCommon.addCompatibleBlocksToFurnitureStorage((BlockEntityTypeAddBlocksEvent)event, (String)MODID, WOOD_ENHANCED_MUSH);
        McwCommon.addCompatibleBlocksToFurnitureStorage((BlockEntityTypeAddBlocksEvent)event, (String)MODID, WOOD_NOMANSLAND);
    }

    private static ItemStack getIcon() {
        NewIconRandom.NewProperties prop = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)(McwAurora.randomNaming() + "_roof")), Finder.findBlock((String)MODID, (String)(McwAurora.randomNaming() + "_picket_fence")), Finder.findBlock((String)MODID, (String)(McwAurora.randomNaming() + "_wardrobe")), Finder.findBlock((String)MODID, (String)(McwAurora.randomNaming() + "_log_bridge_middle")), Finder.findBlock((String)MODID, (String)(McwAurora.randomNaming() + "_pane_window")), Finder.findBlock((String)MODID, (String)(McwAurora.randomNaming() + "_modern_door")), Finder.findBlock((String)MODID, (String)(McwAurora.randomNaming() + "_mystic_trapdoor")), Finder.findBlock((String)MODID, (String)(McwAurora.randomNaming() + "_planks_path")), Finder.findBlock((String)MODID, (String)(McwAurora.randomNaming() + "_skyline_stairs")));
        prop.addType(ModType.BRIDGES).addType(ModType.ROOFS).addType(ModType.FENCES).addType(ModType.FURNITURES).addType(ModType.STAIRS).addType(ModType.PATHS).addType(ModType.WINDOWS).addType(ModType.DOORS).addType(ModType.TRAPDOORS);
        Block icon = prop.buildIcon(new ModType[]{ModType.BRIDGES, ModType.ROOFS, ModType.FENCES, ModType.FURNITURES, ModType.STAIRS, ModType.PATHS, ModType.WINDOWS, ModType.DOORS, ModType.TRAPDOORS});
        return new ItemStack((ItemLike)icon);
    }

    private static String randomNaming() {
        Random rand = new Random();
        if (ModList.get().isLoaded("nomansland") && ModList.get().isLoaded("enhanced_mushrooms")) {
            int i = rand.nextInt(2);
            switch (i) {
                case 0: {
                    return "walnut";
                }
                case 1: {
                    return "mushroom";
                }
            }
            return "mushroom";
        }
        if (ModList.get().isLoaded("enhanced_mushrooms")) {
            return "mushroom";
        }
        if (ModList.get().isLoaded("nomansland")) {
            return "walnut";
        }
        return "mushroom";
    }
}

