/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.client.BalmClientRegistrars;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.ModKeyMappings;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.blay09.mods.clienttweaks.tweak.AdditionalVolumeSlider;
import net.blay09.mods.clienttweaks.tweak.AutoClimbLadder;
import net.blay09.mods.clienttweaks.tweak.ClearRecipeBookSearch;
import net.blay09.mods.clienttweaks.tweak.DisableLogStripping;
import net.blay09.mods.clienttweaks.tweak.DoNotUseLastMending;
import net.blay09.mods.clienttweaks.tweak.DoNotUseLastTorch;
import net.blay09.mods.clienttweaks.tweak.HideOffhandItem;
import net.blay09.mods.clienttweaks.tweak.HideOwnEffectParticles;
import net.blay09.mods.clienttweaks.tweak.HideShieldUnlessHoldingWeapon;
import net.blay09.mods.clienttweaks.tweak.NoOffhandFireworksWithElytra;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchAtAll;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithBlock;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithEmptyHand;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithFood;
import net.blay09.mods.clienttweaks.tweak.NoOffhandUseWithFood;
import net.blay09.mods.clienttweaks.tweak.OffhandTorchWithToolOnly;
import net.blay09.mods.clienttweaks.tweak.PreventAccidentalMining;
import net.blay09.mods.clienttweaks.tweak.StepAssistIsAnnoying;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundSource;

public class ClientTweaks {
    public static final String MOD_ID = "clienttweaks";
    private static final Map<String, AbstractClientTweak> tweaks = new HashMap<String, AbstractClientTweak>();

    public static void initializeCommon(BalmRegistrars registrars) {
        ClientTweaksConfig.initialize();
    }

    public static void initializeClient(BalmClientRegistrars registrars) {
        ClientTweaks.registerTweak(new AdditionalVolumeSlider("master_volume_slider", SoundSource.MASTER, 0){

            @Override
            public boolean isEnabled() {
                ClientTweaksConfigData config = ClientTweaksConfig.getActive();
                return config != null && config.tweaks.masterVolumeSlider;
            }

            @Override
            public void setEnabled(boolean enabled) {
                Balm.config().updateLocalConfig(ClientTweaksConfigData.class, it -> {
                    it.tweaks.masterVolumeSlider = enabled;
                });
            }
        });
        ClientTweaks.registerTweak(new AdditionalVolumeSlider("music_volume_slider", SoundSource.MUSIC, 1){

            @Override
            public boolean isEnabled() {
                ClientTweaksConfigData config = ClientTweaksConfig.getActive();
                return config != null && config.tweaks.musicVolumeSlider;
            }

            @Override
            public void setEnabled(boolean enabled) {
                Balm.config().updateLocalConfig(ClientTweaksConfigData.class, it -> {
                    it.tweaks.musicVolumeSlider = enabled;
                });
            }
        });
        ClientTweaks.registerTweak(new NoOffhandTorchAtAll());
        ClientTweaks.registerTweak(new NoOffhandTorchWithBlock());
        ClientTweaks.registerTweak(new NoOffhandTorchWithEmptyHand());
        ClientTweaks.registerTweak(new OffhandTorchWithToolOnly());
        ClientTweaks.registerTweak(new HideOwnEffectParticles());
        ClientTweaks.registerTweak(new HideOffhandItem());
        ClientTweaks.registerTweak(new StepAssistIsAnnoying());
        ClientTweaks.registerTweak(new AutoClimbLadder());
        ClientTweaks.registerTweak(new HideShieldUnlessHoldingWeapon());
        ClientTweaks.registerTweak(new DoNotUseLastTorch());
        ClientTweaks.registerTweak(new DisableLogStripping());
        ClientTweaks.registerTweak(new NoOffhandTorchWithFood());
        ClientTweaks.registerTweak(new NoOffhandFireworksWithElytra());
        ClientTweaks.registerTweak(new PreventAccidentalMining());
        ClientTweaks.registerTweak(new NoOffhandUseWithFood());
        ClientTweaks.registerTweak(new DoNotUseLastMending());
        ClientTweaks.registerTweak(new ClearRecipeBookSearch());
        ModKeyMappings.initialize(tweaks.values());
    }

    private static void registerTweak(AbstractClientTweak tweak) {
        tweaks.put(tweak.getName(), tweak);
    }

    public static Identifier id(String path) {
        return Identifier.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

