/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks;

import java.util.Collection;
import net.blay09.mods.clienttweaks.ClientTweaks;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.blay09.mods.kuma.api.Kuma;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;

public class ModKeyMappings {
    public static void initialize(Collection<AbstractClientTweak> tweaks) {
        for (AbstractClientTweak tweak : tweaks) {
            if (!tweak.hasKeyBinding()) continue;
            Kuma.createKeyMapping((Identifier)ClientTweaks.id(tweak.getName())).handleWorldInput(event -> {
                ModKeyMappings.toggleTweak(tweak);
                return true;
            }).build();
        }
    }

    private static void toggleTweak(AbstractClientTweak tweak) {
        tweak.setEnabled(!tweak.isEnabled());
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            MutableComponent component = Component.translatable((String)("chat.clienttweaks." + tweak.getName() + ".toggled"), (Object[])new Object[]{Component.translatable((String)(tweak.isEnabled() ? "chat.clienttweaks.on" : "chat.clienttweaks.off"))});
            player.displayClientMessage((Component)component, true);
        }
    }
}

