/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.client.platform.event.callback.ClientTickCallback;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;

public class AutoClimbLadder
extends AbstractClientTweak {
    public AutoClimbLadder() {
        super("auto_climb_ladder");
        ClientTickCallback.BEFORE.register(this::onPlayerTick);
    }

    public void onPlayerTick(Minecraft client) {
        LocalPlayer player = client.player;
        if (player != null && this.isEnabled() && player.onClimbable() && !player.isSuppressingSlidingDownLadder() && player.getXRot() <= -50.0f) {
            player.resetFallDistance();
            Vec3 motion = player.getDeltaMovement();
            player.setDeltaMovement(motion.x, (double)player.getSpeed(), motion.z);
        }
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.autoClimbLadder;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.config().updateLocalConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.autoClimbLadder = enabled;
        });
    }
}

