/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.client.platform.event.callback.ClientItemCallback;
import net.blay09.mods.balm.platform.event.callback.BlockCallback;
import net.blay09.mods.balm.platform.event.callback.InteractionEventResult;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class DoNotUseLastMending
extends AbstractClientTweak {
    public DoNotUseLastMending() {
        super("doNotUseLastMending");
        ClientItemCallback.Use.EVENT.register(this::onRightClick);
        BlockCallback.DigSpeed.EVENT.register(this::onDigSpeed);
    }

    public InteractionEventResult onRightClick(Player player, InteractionHand hand) {
        if (this.isEnabled()) {
            Minecraft minecraft = Minecraft.getInstance();
            ItemStack heldItem = minecraft.player != null ? minecraft.player.getItemInHand(hand) : ItemStack.EMPTY;
            Registry enchantments = minecraft.player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            Holder.Reference mending = enchantments.getOrThrow(Enchantments.MENDING);
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)mending, (ItemStack)heldItem) > 0 && heldItem.getDamageValue() >= heldItem.getMaxDamage() - 1) {
                MutableComponent chatComponent = Component.translatable((String)"chat.clienttweaks.lastMending");
                chatComponent.withStyle(ChatFormatting.RED);
                minecraft.player.displayClientMessage((Component)chatComponent, true);
                return InteractionEventResult.FAIL;
            }
        }
        return InteractionEventResult.DEFAULT;
    }

    public float onDigSpeed(BlockGetter blockGetter, BlockPos pos, BlockState state, Player player, float speed) {
        if (this.isEnabled()) {
            ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            Registry enchantments = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            Holder.Reference mending = enchantments.getOrThrow(Enchantments.MENDING);
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)mending, (ItemStack)heldItem) > 0 && heldItem.getDamageValue() >= heldItem.getMaxDamage() - 1) {
                return 0.0f;
            }
        }
        return speed;
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.doNotUseLastMending;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.config().updateLocalConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.doNotUseLastMending = enabled;
        });
    }
}

