/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.client.platform.event.callback.RenderCallback;
import net.blay09.mods.balm.platform.event.EventPhases;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.mixin.ItemInHandRendererAccessor;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Weapon;

public class HideShieldUnlessHoldingWeapon
extends AbstractClientTweak {
    private boolean wasWeaponInHand;

    public HideShieldUnlessHoldingWeapon() {
        super("hide_shield_unless_holding_weapon");
        RenderCallback.Hand.EVENT.register(EventPhases.HIGHEST, this::onRenderHand);
    }

    public boolean onRenderHand(InteractionHand hand, ItemStack itemStack, float swingProgress) {
        boolean weaponInHand;
        boolean isShield;
        if (!this.isEnabled() || hand != InteractionHand.OFF_HAND) {
            return true;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return true;
        }
        boolean bl = isShield = itemStack.get(DataComponents.BLOCKS_ATTACKS) != null || ClientTweaksConfig.isShieldItem(itemStack);
        if (!isShield) {
            return true;
        }
        boolean isBlocking = player.getUsedItemHand() == InteractionHand.OFF_HAND && player.isBlocking();
        this.wasWeaponInHand = weaponInHand = this.hasWeaponInHand((Player)player);
        if (!weaponInHand && !isBlocking) {
            return false;
        }
        if (weaponInHand && !this.wasWeaponInHand) {
            ItemInHandRenderer itemInHandRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            if (itemInHandRenderer instanceof ItemInHandRendererAccessor) {
                ItemInHandRendererAccessor accessor = (ItemInHandRendererAccessor)itemInHandRenderer;
                accessor.setOOffHandHeight(0.0f);
                accessor.setOffHandHeight(0.0f);
            }
            return false;
        }
        return true;
    }

    private boolean hasWeaponInHand(Player player) {
        ItemStack mainItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        Weapon weaponComponent = (Weapon)player.get(DataComponents.WEAPON);
        if (weaponComponent != null || mainItem.getItem() instanceof AxeItem) {
            return true;
        }
        return ClientTweaksConfig.isShieldWeapon(mainItem);
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.hideShieldUnlessHoldingWeapon;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.config().updateLocalConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.hideShieldUnlessHoldingWeapon = enabled;
        });
    }
}

