/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.schema.BalmConfigSchema;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ClientTweaksConfig {
    public static BalmConfigSchema schema;

    public static ClientTweaksConfigData getActive() {
        return (ClientTweaksConfigData)Balm.getConfig().getActiveConfig(ClientTweaksConfigData.class);
    }

    public static void initialize() {
        schema = Balm.getConfig().registerConfig(ClientTweaksConfigData.class);
    }

    public static boolean isTorchItem(ItemStack itemStack) {
        return ClientTweaksConfig.isItemConfiguredFor(itemStack, ClientTweaksConfig.getActive().customization.torchItems);
    }

    public static boolean isTorchTool(ItemStack itemStack) {
        return ClientTweaksConfig.isItemConfiguredFor(itemStack, ClientTweaksConfig.getActive().customization.torchTools);
    }

    public static boolean isShieldWeapon(ItemStack itemStack) {
        return ClientTweaksConfig.isItemConfiguredFor(itemStack, ClientTweaksConfig.getActive().customization.shieldWeapons);
    }

    public static boolean isShieldItem(ItemStack itemStack) {
        return ClientTweaksConfig.isItemConfiguredFor(itemStack, ClientTweaksConfig.getActive().customization.shieldItems);
    }

    public static boolean isFireworkItem(ItemStack itemStack) {
        return ClientTweaksConfig.isItemConfiguredFor(itemStack, ClientTweaksConfig.getActive().customization.fireworkItems);
    }

    public static boolean isItemConfiguredFor(ItemStack itemStack, List<String> items) {
        if (itemStack.isEmpty()) {
            return false;
        }
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        boolean itemPasses = items.contains(registryName.toString());
        boolean tagPasses = itemStack.getTags().anyMatch(it -> items.contains("#" + String.valueOf(it.location())));
        return itemPasses || tagPasses;
    }
}

