/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.UseItemInputEvent;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class NoOffhandTorchWithBlock
extends AbstractClientTweak {
    public NoOffhandTorchWithBlock() {
        super("no_offhand_torch_with_block");
        Balm.getEvents().onEvent(UseItemInputEvent.class, this::onRightClick);
    }

    public void onRightClick(UseItemInputEvent event) {
        if (this.isEnabled() && event.getHand() == InteractionHand.OFF_HAND) {
            ItemStack mainItem;
            ItemStack heldItem;
            Minecraft client = Minecraft.getInstance();
            ItemStack itemStack = heldItem = client.player != null ? client.player.getItemInHand(event.getHand()) : ItemStack.EMPTY;
            if (ClientTweaksConfig.isTorchItem(heldItem) && !(mainItem = client.player.getMainHandItem()).isEmpty() && mainItem.getItem() instanceof BlockItem) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.noOffhandTorchWithBlock;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.getConfig().updateLocalConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.noOffhandTorchWithBlock = enabled;
        });
    }
}

