/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.mixin;

import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossCollisionBlock.class})
public class CrossCollisionBlockMixin {
    @Inject(method={"getShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="RETURN")}, cancellable=true)
    void getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> callbackInfo) {
        boolean isHoldingCrossCollisionBlock;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft != null ? minecraft.player : null;
        boolean bl = isHoldingCrossCollisionBlock = player != null && Block.byItem((Item)player.getMainHandItem().getItem()) instanceof CrossCollisionBlock;
        if (isHoldingCrossCollisionBlock && ClientTweaksConfig.getActive().tweaks.paneBuildingSupport) {
            VoxelShape originalShape;
            if (!(state.hasProperty((Property)CrossCollisionBlock.EAST) && state.hasProperty((Property)CrossCollisionBlock.WEST) && state.hasProperty((Property)CrossCollisionBlock.NORTH) && state.hasProperty((Property)CrossCollisionBlock.SOUTH))) {
                return;
            }
            boolean isPillarSection = (Boolean)state.getValue((Property)CrossCollisionBlock.EAST) == false && (Boolean)state.getValue((Property)CrossCollisionBlock.WEST) == false && (Boolean)state.getValue((Property)CrossCollisionBlock.NORTH) == false && (Boolean)state.getValue((Property)CrossCollisionBlock.SOUTH) == false;
            boolean isThinSection = CrossCollisionBlockMixin.isOnlyOneTrue((Boolean)state.getValue((Property)CrossCollisionBlock.EAST), (Boolean)state.getValue((Property)CrossCollisionBlock.WEST), (Boolean)state.getValue((Property)CrossCollisionBlock.NORTH), (Boolean)state.getValue((Property)CrossCollisionBlock.SOUTH));
            if ((isThinSection || isPillarSection) && !(originalShape = (VoxelShape)callbackInfo.getReturnValue()).isEmpty()) {
                VoxelShape modifiedShape = Shapes.create((AABB)originalShape.bounds().expandTowards(0.25, 0.0, 0.25).expandTowards(-0.25, 0.0, -0.25).intersect(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)));
                callbackInfo.setReturnValue((Object)modifiedShape);
            }
        }
    }

    private static boolean isOnlyOneTrue(boolean ... args) {
        int trues = 0;
        for (boolean arg : args) {
            if (!arg) continue;
            ++trues;
        }
        return trues == 1;
    }
}

