/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.client.RenderHandEvent;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.mixin.ItemInHandRendererAccessor;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Weapon;

public class HideShieldUnlessHoldingWeapon
extends AbstractClientTweak {
    private boolean wasWeaponInHand;

    public HideShieldUnlessHoldingWeapon() {
        super("hide_shield_unless_holding_weapon");
        Balm.getEvents().onEvent(RenderHandEvent.class, this::onRenderHand, EventPriority.Highest);
    }

    public void onRenderHand(RenderHandEvent event) {
        boolean isShield;
        if (!this.isEnabled() || event.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        boolean bl = isShield = event.getItemStack().get(DataComponents.BLOCKS_ATTACKS) != null || ClientTweaksConfig.isShieldItem(event.getItemStack());
        if (!isShield) {
            return;
        }
        boolean isBlocking = player.getUsedItemHand() == InteractionHand.OFF_HAND && player.isBlocking();
        boolean weaponInHand = this.hasWeaponInHand((Player)player);
        if (!weaponInHand && !isBlocking) {
            event.setCanceled(true);
        } else if (weaponInHand && !this.wasWeaponInHand) {
            ItemInHandRenderer itemInHandRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            if (itemInHandRenderer instanceof ItemInHandRendererAccessor) {
                ItemInHandRendererAccessor accessor = (ItemInHandRendererAccessor)itemInHandRenderer;
                accessor.setOOffHandHeight(0.0f);
                accessor.setOffHandHeight(0.0f);
            }
            event.setCanceled(true);
        }
        this.wasWeaponInHand = weaponInHand;
    }

    private boolean hasWeaponInHand(Player player) {
        ItemStack mainItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        Weapon weaponComponent = (Weapon)player.get(DataComponents.WEAPON);
        if (weaponComponent != null || mainItem.getItem() instanceof AxeItem) {
            return true;
        }
        return ClientTweaksConfig.isShieldWeapon(mainItem);
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.hideShieldUnlessHoldingWeapon;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.getConfig().updateLocalConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.hideShieldUnlessHoldingWeapon = enabled;
        });
    }
}

