/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.UseItemInputEvent;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.HitResult;

public class NoOffhandFireworksWithElytra
extends AbstractClientTweak {
    public NoOffhandFireworksWithElytra() {
        super("no_offhand_fireworks_with_elytra");
        Balm.getEvents().onEvent(UseItemInputEvent.class, this::onRightClick);
    }

    public void onRightClick(UseItemInputEvent event) {
        if (this.isEnabled() && event.getHand() == InteractionHand.OFF_HAND) {
            ItemStack wornChestItem;
            Minecraft client = Minecraft.getInstance();
            LocalPlayer player = client.player;
            if (client.level == null || player == null || client.hitResult == null || client.hitResult.getType() != HitResult.Type.BLOCK) {
                return;
            }
            ItemStack heldItem = player.getItemInHand(event.getHand());
            if (ClientTweaksConfig.isFireworkItem(heldItem) && (wornChestItem = player.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA) && !player.isFallFlying()) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.noOffhandFireworksWithElytra;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.getConfig().updateLocalConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.noOffhandFireworksWithElytra = enabled;
        });
    }
}

