/*
 * Decompiled with CFR 0.152.
 */
package me.bbb908.staffmanagerx.Managers;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            plugin.saveDefaultConfig();
        }
        this.config = plugin.getConfig();
        this.loadDefaults();
        plugin.saveConfig();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    private void loadDefaults() {
        this.config.addDefault("max-time-off", (Object)"5d30m5s");
        this.config.addDefault("demote-command", (Object)"lp user $player$ parent set default");
        this.config.addDefault("webhook-enabled", (Object)false);
        this.config.addDefault("webhook-url", (Object)"");
        this.config.options().copyDefaults(true);
    }

    public boolean getWebhooksEnabled() {
        return this.config.getBoolean("webhook-enabled", false);
    }

    public String getWebhookUrl() {
        return this.config.getString("webhook-url", "");
    }

    public int getMaxTimeOffSeconds() {
        String timeStr = this.config.getString("max-time-off", "100d");
        return this.parseTimeStringToSeconds(timeStr);
    }

    public String getDemoteCommand() {
        return this.config.getString("demote-command", "");
    }

    public int parseTimeStringToSeconds(String time) {
        int seconds = 0;
        Pattern pattern = Pattern.compile("(\\d+)([dhms])");
        Matcher matcher = pattern.matcher(time);
        while (matcher.find()) {
            String unit;
            int value = Integer.parseInt(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "d": {
                    seconds += value * 86400;
                    break;
                }
                case "h": {
                    seconds += value * 3600;
                    break;
                }
                case "m": {
                    seconds += value * 60;
                    break;
                }
                case "s": {
                    seconds += value;
                    break;
                }
            }
        }
        return seconds;
    }

    public String formatSecondsToTime(int totalSeconds) {
        int days = totalSeconds / 86400;
        int remainder = totalSeconds % 86400;
        int hours = remainder / 3600;
        int minutes = (remainder %= 3600) / 60;
        int seconds = remainder % 60;
        StringBuilder formattedTime = new StringBuilder();
        if (days > 0) {
            formattedTime.append(days).append("d");
        }
        if (hours > 0) {
            formattedTime.append(hours).append("h");
        }
        if (minutes > 0) {
            formattedTime.append(minutes).append("m");
        }
        if (seconds > 0 || formattedTime.length() == 0) {
            formattedTime.append(seconds).append("s");
        }
        return formattedTime.toString();
    }
}

