/*
 * Decompiled with CFR 0.152.
 */
package me.bbb908.staffmanagerx.Managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class StaffDataManager {
    private final File dataFile;
    private final YamlConfiguration dataConfig;

    public StaffDataManager(JavaPlugin plugin) {
        this.dataFile = new File(plugin.getDataFolder(), "staffdata.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.getParentFile().mkdirs();
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public long getLastLogin(UUID playerUUID) {
        return this.dataConfig.getLong(playerUUID.toString() + ".lastLogin", 0L);
    }

    public void setLastLogin(UUID playerUUID, long timestamp) {
        this.dataConfig.set(playerUUID.toString() + ".lastLogin", (Object)timestamp);
        this.saveData();
    }

    public List<String> getLast30Commands(UUID playerUUID) {
        List commands = this.dataConfig.getStringList(playerUUID.toString() + ".last30Commands");
        return commands != null ? commands : new ArrayList();
    }

    public void addCommand(UUID playerUUID, String command) {
        List<String> commands = this.getLast30Commands(playerUUID);
        commands.add(command);
        if (commands.size() > 30) {
            commands.remove(0);
        }
        this.dataConfig.set(playerUUID.toString() + ".last30Commands", commands);
        this.saveData();
    }

    public long getWeeklyPlaytime(UUID playerUUID) {
        return this.dataConfig.getLong(playerUUID.toString() + ".weeklyPlaytime", 0L);
    }

    public void addPlaytime(UUID playerUUID, long seconds) {
        long current = this.getWeeklyPlaytime(playerUUID);
        this.dataConfig.set(playerUUID.toString() + ".weeklyPlaytime", (Object)(current + seconds));
        this.saveData();
    }

    public void setPlaytime(UUID playerUUID, long seconds) {
        this.dataConfig.set(playerUUID.toString() + ".weeklyPlaytime", (Object)seconds);
        this.saveData();
    }

    public long getWeekBeginning(UUID playerUUID) {
        return this.dataConfig.getLong(playerUUID.toString() + ".weekBeginning", 0L);
    }

    public void setWeekBeginning(UUID playerUUID, long timestamp) {
        this.dataConfig.set(playerUUID.toString() + ".weekBeginning", (Object)timestamp);
        this.saveData();
    }

    private void saveData() {
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeStaffData(UUID playerUUID) {
        this.dataConfig.set(playerUUID.toString(), null);
        this.saveData();
    }

    public List<UUID> getStaffUUIDs() {
        ArrayList<UUID> staffUUIDs = new ArrayList<UUID>();
        for (String key : this.dataConfig.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                staffUUIDs.add(uuid);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return staffUUIDs;
    }
}

