/*
 * Decompiled with CFR 0.152.
 */
package me.bbb908.staffmanagerx.UIs;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.bbb908.staffmanagerx.StaffManagerX;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class StaffGUI {
    public static void openStaffGUI(Player viewer, List<UUID> staffUUIDs) {
        int size = (staffUUIDs.size() / 9 + 1) * 9;
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)"\u00a7aStaff Members");
        for (UUID uuid : staffUUIDs) {
            OfflinePlayer staff = Bukkit.getOfflinePlayer((UUID)uuid);
            String displayName = staff.getName();
            if (displayName == null) {
                displayName = "Unknown";
            }
            ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            meta.setOwner(staff.getName());
            meta.setDisplayName(displayName);
            long weeklyPlaytimeSeconds = StaffManagerX.getStaffDataManager().getWeeklyPlaytime(uuid);
            long lastLoginTimestamp = StaffManagerX.getStaffDataManager().getLastLogin(uuid);
            String formattedPlaytime = StaffGUI.formatSecondsToTime((int)weeklyPlaytimeSeconds);
            String formattedLastLogin = StaffGUI.formatRelativeTime(lastLoginTimestamp);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("Weekly Playtime: " + formattedPlaytime);
            lore.add("Last Login: " + formattedLastLogin + " ago");
            meta.setLore(lore);
            head.setItemMeta((ItemMeta)meta);
            gui.addItem(new ItemStack[]{head});
        }
        viewer.openInventory(gui);
    }

    private static String formatSecondsToTime(int totalSeconds) {
        int days = totalSeconds / 86400;
        int remainder = totalSeconds % 86400;
        int hours = remainder / 3600;
        int minutes = (remainder %= 3600) / 60;
        int seconds = remainder % 60;
        StringBuilder formattedTime = new StringBuilder();
        if (days > 0) {
            formattedTime.append(days).append("d");
        }
        if (hours > 0) {
            formattedTime.append(hours).append("h");
        }
        if (minutes > 0) {
            formattedTime.append(minutes).append("m");
        }
        if (seconds > 0) {
            formattedTime.append(seconds).append("s");
        }
        if (formattedTime.length() == 0) {
            formattedTime.append("Now");
        }
        return formattedTime.toString();
    }

    private static String formatRelativeTime(long lastLoginTimestamp) {
        if (lastLoginTimestamp <= 0L) {
            return "Never";
        }
        long currentTime = System.currentTimeMillis();
        int diffSeconds = (int)((currentTime - lastLoginTimestamp) / 1000L);
        return StaffGUI.formatSecondsToTime(diffSeconds);
    }
}

