/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.compat.curios;

import com.github.ysbbbbbb.kaleidoscopedoll.item.DollItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class DollItemRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandRenderer itemInHandRenderer;

    public DollItemRenderer(RenderLayerParent<T, M> renderer, ItemInHandRenderer itemInHandRenderer) {
        super(renderer);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public static void translateToHead(PoseStack poseStack) {
        poseStack.m_85837_(0.0, -0.25, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85841_(0.625f, -0.625f, -0.625f);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> handler.getCurios().forEach((id, stacksHandler) -> {
            if (stacksHandler.isVisible() && "head".equals(stacksHandler.getIdentifier())) {
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStacksHandler = stacksHandler.getCosmeticStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    boolean renderable;
                    ItemStack stack = cosmeticStacksHandler.getStackInSlot(i);
                    NonNullList renderStates = stacksHandler.getRenders();
                    boolean bl = renderable = renderStates.size() > i && (Boolean)renderStates.get(i) != false;
                    if (stack.m_41619_() && renderable) {
                        stack = stackHandler.getStackInSlot(i);
                    }
                    if (stack.m_41619_()) continue;
                    this.rendererDollItem(stack, livingEntity, poseStack, bufferIn, packedLightIn);
                }
            }
        }));
    }

    private <T extends LivingEntity, M extends EntityModel<T>> void rendererDollItem(ItemStack itemStack, T livingEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        Item item = itemStack.m_41720_();
        if (item instanceof DollItem) {
            DollItem dollItem = (DollItem)item;
            poseStack.m_85836_();
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
            DollItemRenderer.translateToHead(poseStack);
            this.itemInHandRenderer.m_109322_(livingEntity, itemStack, ItemTransforms.TransformType.HEAD, false, poseStack, multiBufferSource, light);
            poseStack.m_85849_();
        }
    }
}

