/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class GeneralConfig {
    public static ForgeConfigSpec.BooleanValue DOLL_CAN_BE_THROWN;
    public static ForgeConfigSpec.BooleanValue DOLL_AFFECTED_BY_WATER;
    public static ForgeConfigSpec.BooleanValue DOLL_AFFECTED_BY_GRAVITY;
    public static ForgeConfigSpec.BooleanValue DOLL_THROW_PARTICLE_EFFECT;
    public static ForgeConfigSpec.BooleanValue DOLL_CAN_KNOCKBACK_ENTITIES;
    public static ForgeConfigSpec.DoubleValue DOLL_KNOCKBACK_FORCE;
    public static ForgeConfigSpec.BooleanValue DOLL_CAN_MOUNT_ENTITIES;
    public static ForgeConfigSpec.BooleanValue ENABLE_PHANTOM_DOLL_SPAWN;
    public static ForgeConfigSpec.DoubleValue PHANTOM_DOLL_SPAWN_CHANCE;
    public static ForgeConfigSpec.IntValue PHANTOM_DOLL_EXIST_TICKS;

    public static ForgeConfigSpec init() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("doll");
        builder.comment("Whether dolls can be thrown by players");
        builder.comment("\u73a9\u5076\u662f\u5426\u53ef\u4ee5\u88ab\u73a9\u5bb6\u4e22\u51fa");
        DOLL_CAN_BE_THROWN = builder.define("DollCanBeThrown", true);
        builder.comment("Whether dolls can be pushed by water flow");
        builder.comment("\u73a9\u5076\u662f\u5426\u4f1a\u88ab\u6c34\u6d41\u63a8\u52a8");
        DOLL_AFFECTED_BY_WATER = builder.define("DollAffectedByWater", true);
        builder.comment("Whether dolls are affected by gravity");
        builder.comment("\u73a9\u5076\u662f\u5426\u53d7\u91cd\u529b\u5f71\u54cd");
        DOLL_AFFECTED_BY_GRAVITY = builder.define("DollAffectedByGravity", true);
        builder.comment("Whether throwing dolls produces particle effects");
        builder.comment("\u4e22\u51fa\u73a9\u5076\u65f6\u662f\u5426\u4ea7\u751f\u7c92\u5b50\u6548\u679c");
        DOLL_THROW_PARTICLE_EFFECT = builder.define("DollThrowParticleEffect", true);
        builder.comment("Whether thrown dolls can knockback other entities");
        builder.comment("\u88ab\u4e22\u51fa\u7684\u73a9\u5076\u662f\u5426\u80fd\u51fb\u9000\u5176\u4ed6\u5b9e\u4f53");
        DOLL_CAN_KNOCKBACK_ENTITIES = builder.define("DollCanKnockbackEntities", true);
        builder.comment("The knockback force of thrown dolls, the larger the value, the stronger the knockback effect");
        builder.comment("\u88ab\u4e22\u51fa\u7684\u73a9\u5076\u7684\u51fb\u9000\u6548\u679c\u5f3a\u5ea6\uff0c\u6570\u503c\u8d8a\u5927\u51fb\u9000\u6548\u679c\u8d8a\u5f3a");
        DOLL_KNOCKBACK_FORCE = builder.defineInRange("DollKnockbackForce", 1.0, 0.0, 10.0);
        builder.comment("Whether dolls can be placed directly on other entities");
        builder.comment("\u73a9\u5076\u662f\u5426\u53ef\u4ee5\u76f4\u63a5\u653e\u7f6e\u5728\u5176\u4ed6\u5b9e\u4f53\u4e0a");
        DOLL_CAN_MOUNT_ENTITIES = builder.define("DollCanMountEntities", true);
        builder.comment(new String[]{"Enable dolls spawning on phantoms", "\u542f\u7528\u5e7b\u7ffc\u9644\u5e26\u73a9\u5076\u751f\u6210"});
        ENABLE_PHANTOM_DOLL_SPAWN = builder.define("EnablePhantomDollSpawn", true);
        builder.comment(new String[]{"Chance for phantom to spawn with a doll", "\u5e7b\u7ffc\u9644\u5e26\u73a9\u5076\u7684\u751f\u6210\u6982\u7387"});
        PHANTOM_DOLL_SPAWN_CHANCE = builder.defineInRange("PhantomDollSpawnChance", 0.03, 0.0, 1.0);
        builder.comment(new String[]{"Ticks for phantom spawned doll to exist, set to 0 to disable despawn", "\u5e7b\u7ffc\u9644\u5e26\u73a9\u5076\u7684\u5b58\u5728\u65f6\u95f4\uff0c\u8bbe\u4e3a -1 \u5219\u4e0d\u4f1a\u6d88\u5931"});
        PHANTOM_DOLL_EXIST_TICKS = builder.defineInRange("PhantomDollExistTicks", 3600, -1, Integer.MAX_VALUE);
        builder.pop();
        return builder.build();
    }
}

