/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.datagen;

import com.github.ysbbbbbb.kaleidoscopedoll.datagen.AdvancementGenerator;
import com.github.ysbbbbbb.kaleidoscopedoll.datagen.BlockStateGenerator;
import com.github.ysbbbbbb.kaleidoscopedoll.datagen.ItemModelGenerator;
import com.github.ysbbbbbb.kaleidoscopedoll.datagen.LootTableGenerator;
import com.github.ysbbbbbb.kaleidoscopedoll.datagen.ModRecipeProvider;
import com.github.ysbbbbbb.kaleidoscopedoll.datagen.TagBlock;
import com.github.ysbbbbbb.kaleidoscopedoll.datagen.TagItem;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture registries = event.getLookupProvider();
        DataGenerator.PackGenerator vanillaPack = generator.m_253147_(true);
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput pack = generator.getPackOutput();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(pack, Set.of(), List.of(new LootTableProvider.SubProviderEntry(LootTableGenerator.BlockLootTables::new, LootContextParamSets.f_81421_))));
        TagBlock blockTagsProvider = (TagBlock)vanillaPack.m_253108_(packOutput -> new TagBlock(packOutput, registries, "kaleidoscope_doll", existingFileHelper));
        vanillaPack.m_253108_(packOutput -> new TagItem(packOutput, registries, blockTagsProvider.m_274426_(), "kaleidoscope_doll", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(generator));
        generator.addProvider(true, (DataProvider)new ForgeAdvancementProvider(pack, registries, existingFileHelper, Collections.singletonList(new AdvancementGenerator())));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(pack, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(pack, existingFileHelper));
    }
}

